/*
   ibmpc/host.c

   IBM-PC host program
*/

#include <stdio.h>
#include <setjmp.h>
#include <errno.h>
#include <stdlib.h>
#include <alloc.h>
#include <assert.h>
#include <fcntl.h>

#include "lib.h"
#include "host.h"

char *mailbox, *name, *homedir;
char *maildir, *newsdir, *confdir, *spooldir, *pubdir, *tempdir;
char *domain, *nodename, *mailserv;
int E_tzoffset;
char *E_tzname;
char *E_indevice, *E_inspeed;
char *E_editor, *E_pager;
char *E_filesent, *E_signature;

jmp_buf	dcpexit;

int main(argc, argv)
int argc;
char *argv[];
{
#ifdef CWDSPOOL
	char *currdir;
#endif
	int status;

	if (!configure())
		return 1;	/* system configuration failed */

	/* Turbo C needs these for time() to work right. */
	daylight = 0;
	timezone = - E_tzoffset * 60;

#ifdef CWDSPOOL
	/* move to the spooling directory */
	currdir = getcwd(nil(char), 80);
	CHDIR(spooldir);
#endif

	/* setup longjmp for error exit's */
	status = 10;	/* set default in case we get out via a longjmp */
	if (setjmp(dcpexit) == 0)
		status = MAIN(argc, argv);

#ifdef CWDSPOOL
	/* go back to the start-up directory */
	CHDIR(currdir);
#endif

	return status;

} /*main*/


/*
   importpath - convert a canonical name to a format the host can handle

   Thise routines convert file name between canonical form, which is
   defined as a 'unix' style pathname, and the MS-DOS all uppercase
   "xxxxxxxx.xxx" format.

   Mung the canonical file name as follows:
     1 - skip any path from the canonical name
     2 - copy up to 8 character from the canonical name converting . to _
         and uppercase to lowercase.
     3 - if the name was longer than 8 character copy a . to the host name
         and then copy the up to three characters from the tail of the
         canonical name to the host name.
*/

#define min(x,y) (((x) < (y)) ? (x) : (y))

void importpath(host, canon)
char *host, *canon;
{
   char *s, *out, c;
   int i, j, l;

   out = host;

   /* get a pointer to the last component of the path */
   if ((s = strrchr(canon, '/')) == (char *)NULL)
      s = canon;
   else
      s++;

   j = min(l = strlen(s), 8);

   for (i = 0; i < j; i++) {
      c = *s++;
      *out++ = (c == '.') ? '_' : tolower(c);
   }
   *out = '\0';

   while (*s != '\0') s++;

   if (l>8)
      for (i=0; i<3; i++)
         if (*--s == '.') {
            s++;
            break;
         }

   if (*s != '\0') {
      (void)strcat(out, ".");
      (void)strcat(out, s);
   }

} /*importpath*/


/*
   mkfilename - build a path name out of a directory name and a file name
*/

void mkfilename(pathname, path, name)
char *pathname, *path, *name;
{

   sprintf(pathname, "%s/%s", path, name);

} /*mkfilename*/


/*
	getrcnames - return the name of the configuration files
*/

#define	SYSRCSYM	"UUPCSYSRC"
#define USRRCSYM	"UUPCUSRRC"

int getrcnames(sysp, usrp)
char **sysp, **usrp;
{

	if ((*sysp = getenv(SYSRCSYM)) != nil(char))
		*sysp = strcpy(malloc(strlen(*sysp) + 1), *sysp);
	else {
		printf("environment variable %s must be specified\n", SYSRCSYM);
		return FALSE;
	}

	if ((*usrp = getenv(USRRCSYM)) != nil(char))
		*usrp = strcpy(malloc(strlen(*usrp) + 1), *usrp);

	return TRUE;

} /*getrcnames*/


/*
	filemode - default the text/binary mode for subsequently opened files
*/

void filemode(mode)
char mode;
{

   assert((mode == BINARY) || (mode == TEXT));
   _fmode = (mode == TEXT) ? O_TEXT : O_BINARY;

} /*filemode*/
