/*
 *      pw_open.c: Open a password file
 *
 *      Stephen C. Trier
 *      March 26, 1990
 *
 *      This program is in the public domain
 *
 *      pw_openfile should usually be regarded as an internal function for
 *      the use of the passwd library only.  However, if your software has
 *      its own way of specifying the location of the password file, you may
 *      wish to use pw_openfile to pass that location to the library.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>

extern FILE *_pw_file;

int pw_openfile(char *name)
{
    if (name == NULL)
	name = getenv("PASSWD");
    if (name == NULL)
	name = "\\etc\\passwd";
    return (_pw_file = fopen(name, "r")) != NULL;
}


