;PPMPX4a.ASM 3.3(for DPMI)
;	MACHINE LANGUAGE SUBROUTINES
;	FOR PPMPQS
;	1991-97 by YUJI KIDA
;
.386P

code	segment	use16
	assume	cs:code,ds:code

	INCLUDE	UBP.MAC
	include	ppmpx.h


inactivesteplog	equ	9


	org	100h

start:
	jmp	start0

	include	dpmi4ub.h
	include	dpmi4ub.lib


start0:
;branch

	MOV_AX	AR0		;ARRAY[0] is the command
	MOV	BX,OFFSET CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	dw	INITIALIZE,GETPRIME,STORE_DATA,SETACTIVE,COUNTCOLUMN
	dw	DELETEROW,GAUSS1,GAUSS2,CUTEXCESSROW,MAKERFB,freememory

	even
maxlen		dw	0
P_OFF		dw	?
P_SEG		dw	?
primeadrnow	dd	?

W_OFF		dw	?
W_SEG		dw	?

Drv_OFF		dw	?
Drv_SEG		dw	?

FBsize		dd	?
primes		dd	?
rowstotal	dd	?
rowsnow		dd	?
columnsweight0	dd	?
excessrows	dd	?

heavycolweight	dw	?

	align	4
offnow		dd	?
primenow	dd	?

count0		dd	?
count1		dd	?
count2		dd	?

inactivenow	dd	?
inactivenext	dd	?
inactivecount	dd	?

primehandle	dw	?
decomhandle	dw	?
histhandle	dw	?

ptrbuffer2	dw	?
ptrbuffer3	dw	?
length1		dw	?
length2		dw	?
spmem		dw	?

didsomesw	dw	0

	align	4
pointernow	dd	?
datanow		dd	?
columncount	dd	?

counterbase	dd	?
pointerbase	dd	?
database	dd	?
activeflgbase	dd	?


;
; free DPMI memory
;
;command#=10

freememory:
	call	freemainDATAmemory
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


;
; make reduced FactorBase file
; and revived Row number file
;
;command#=9

RFBhandle	dw	?
RFBFILENAME	db	'PPMPRFB.PPM',0
ROWShandle	dw	?
ROWSFILENAME	db	'PPMPROWS.PPM',0

makeRFB:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	[spmem],sp

	mov	ah,3eh			;close history
	mov	bx,[histhandle]
	or	bx,bx
	jz	short makeRFB0
	int	21h
makeRFB0:
	mov	dx,offset RFBFILENAME
	mov	ah,3ch			;create handle
	mov	cx,0
	int	21h
	jc	makeRFBdiskerror
	mov	[RFBhandle],ax

	call	real2protB

	xor	edx,edx			;counter
	mov	ebx,[activeflgbase]
	mov	ecx,[FBsize]
makeRFB10:
	push	ebx
	push	ecx

	mov	eax,-1		;non use mark
	cmp	byte ptr fs:[ebx],1
	jne	short makeRFB20
	mov	eax,edx
	inc	edx
makeRFB20:
	push	edx
	mov	bx,offset BUFFER
	mov	[bx],eax

	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,4
	mov	bx,[RFBhandle]
	mov	ah,40h			;write
	int	21h
	jc	makeRFBdiskerror	

	call	real2protB

	pop	edx
	pop	ecx
	pop	ebx

	inc	ebx
	dec	ecx
	jnz	makeRFB10

	push	edx
	call	prot2real
	pop	edx

	cmp	edx,[inactivenow]
	jne	makeRFBdataerror

	push	edx			;/*

	mov	ah,3eh			;close
	mov	bx,[RFBhandle]
	or	bx,bx
	jz	short makeROWS
	int	21h

makeROWS:
	mov	dx,offset ROWSFILENAME
	mov	ah,3ch			;create handle
	mov	cx,0
	int	21h
	jc	makeRFBdiskerror
	mov	[ROWShandle],ax

	call	real2protB

	xor	edx,edx			;counter
	mov	ebx,[pointerbase]
	mov	ecx,[FBsize]
makeROWS10:
	test	dword ptr fs:[ebx],deletedmark4B
	jnz	short makeROWS20

	push	ebx
	push	ecx
	push	edx

	mov	bx,offset BUFFER
	mov	eax,[FBsize]
	sub	eax,ecx
	mov	[bx],eax

	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,4
	mov	bx,[ROWShandle]
	mov	ah,40h			;write
	int	21h
	jc	makeRFBdiskerror

	call	real2protB

	pop	edx
	pop	ecx
	pop	ebx

	inc	edx

makeROWS20:
	add	ebx,4
	dec	ecx
	jnz	makeROWS10

	push	edx
	call	prot2real
	pop	edx

	pop	eax			;*/
	cmp	eax,edx
	jae	short makeROWS30
	mov	eax,edx
makeROWS30:
	add	eax,matrixunitsize-1
	and	eax,matrixunitmask
	shr	eax,1			;reduced matrix size / 2

makeRFBret:
	mov	sp,[spmem]

	mov	bx,AR0
	mov	word ptr [bx],ax

	mov	ah,3eh			;close
	mov	bx,[RFBhandle]
	or	bx,bx
	jz	short makeRFBskip
	int	21h

makeRFBskip:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

makeRFBdiskerror:
	mov	ax,8001h
	jmp	makeRFBret

makeRFBdataerror:
	mov	ax,8002h		;data error
	jmp	makeRFBret

;
; cut excess rows
;
;command#=8

CUTEXCESSROW:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	[excessrows],0
	mov	eax,[rowsnow]
	mov	edx,[FBsize]
	add	edx,[inactivenow]
	sub	edx,[columnsweight0]
	add	edx,8			;for safety
	sub	eax,edx
	jbe	excessout		;no excess
	mov	[excessrows],eax

	mov	cx,ax			;clear buffer
	shl	cx,1
	mov	di,offset BUFFER
	xor	eax,eax
	rep	stosd
	dec	eax
	stosd				;sentinel

	call	real2protB

	mov	ecx,[rowstotal]
	mov	ebx,[pointerbase]
	xor	edx,edx			;row#
excess10:
	push	ecx
	mov	esi,fs:[ebx]
	test	esi,deletedmark4B
	jnz	short excess20

	mov	ax,fs:[esi]		;weight
	mov	di,offset BUFFER
	cmp	ax,[di]
	jb	short excess20
	call	storethisrownumber
excess20:
	add	ebx,4
	inc	edx
	pop	ecx
	dec	ecx
	jnz	excess10

	;now delete highest weight rows

	mov	si,offset BUFFER
	mov	ecx,[excessrows]
excess50:
	add	si,4
	lodsd
	or	eax,eax
	jz	short excess60
	shl	eax,2
	add	eax,[pointerbase]
	or	dword ptr fs:[eax],deletedmark4B
	dec	[rowsnow]
excess60:
	dec	ecx
	jnz	excess50
	call	prot2real

excessout:
	mov	eax,[excessrows]	;//must rewrite if > 2^15
	mov	bx,AR0
	mov	[bx],ax

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

storethisrownumber:
	push	ebx
storethisrow10:
	mov	bx,[di+8]
	mov	ecx,[di+12]
	cmp	ax,bx
	jb	short storethisrow50
	mov	[di],bx
	mov	[di+4],ecx
	add	di,8
	jmp	storethisrow10
storethisrow50:
	mov	[di],ax			;weight
	mov	[di+4],edx		;row#
	pop	ebx
	ret


;
; GAUSSian elimination using the rows of weight 2
;
;command#=7

GAUSS2:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	mov	[spmem],sp
	mov	[didsomesw],0

	call	real2protB

	mov	ebx,[pointerbase]
	mov	ecx,[rowstotal]
gauss210:
	push	ecx
	push	ebx
	mov	esi,fs:[ebx]
	test	esi,deletedmark4b
	jnz	short gauss220

	mov	ax,fs:[esi]		;weight
	cmp	ax,2
	jne	short gauss220

	or	dword ptr fs:[ebx],deletedmark4B
	dec	[rowsnow]
	call	setpivotnumber
	call	gauss2sub
	call	appendhistory
gauss220:
	pop	ebx
	add	ebx,4
	pop	ecx
	dec	ecx
	jnz	gauss210

	call	prot2real

	mov	ax,[didsomesw]
	mov	bx,AR0
	mov	[bx],ax

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


gauss2sub:
	mov	edx,fs:[esi+4]		;dx = pivot smaller value
	mov	eax,fs:[esi+8]		;ax = pivot larger value

	mov	ebx,[pointerbase]
	mov	ecx,[rowstotal]
gauss2submainlp:
	push	ecx			;*
	mov	esi,fs:[ebx]
	test	esi,deletedmark4b
	jnz	short gauss2sub20

	mov	cx,fs:[esi]
	jcxz	short gauss2sub20
gauss2sub12:
	add	esi,4
	cmp	eax,fs:[esi]
	jb	short gauss2sub20
	je	short gauss2sub30
	loop	gauss2sub12

gauss2sub20:
	add	ebx,4
	pop	ecx			;*
	dec	ecx
	jnz	gauss2submainlp
	ret

gauss2sub30:
	push	eax
	call	replacethis
	call	memooperation
	pop	eax
	jmp	gauss2sub20

replacethis:
	mov	edi,fs:[ebx]		;top adr
	mov	ecx,esi
	sub	ecx,edi
	shr	ecx,2
	dec	cx			;data# to be checked
	jz	short replacethisret
replacethislp:
	mov	eax,fs:[esi-4]
	cmp	eax,edx
	jb	short replacethisret
	je	short cutthis2
	mov	fs:[esi],eax
	sub	esi,4
	loop	replacethislp
replacethisret:
	mov	fs:[esi],dx
replacethisret2:
	ret

cutthis2:
	mov	ax,fs:[edi]		;weight
	mov	cx,ax
	sub	ax,2
	mov	fs:[edi],ax
	jz	replacethisret2
	mov	eax,esi
	sub	eax,edi
	shr	eax,2
	sub	cx,ax	
	jz	replacethisret2
cutthis2lp:
	add	esi,4
	mov	ax,fs:[esi]
	mov	fs:[esi-8],ax		;cut 2 members
	loop	cutthis2lp
	jmp	replacethisret2

;
; GAUSSian elimination using the rows of weight 1
;
;command#=6

GAUSS1:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	mov	[spmem],sp
	mov	[didsomesw],0

	call	real2protB

gauss1mainlp:
	mov	ebx,[pointerbase]
	mov	ecx,[rowstotal]
gauss110:
	push	ecx
	push	ebx

	mov	esi,fs:[ebx]
	test	esi,deletedmark4b
	jnz	short gauss120

	mov	ax,fs:[esi]		;weight
	cmp	ax,1
	jne	short gauss120
gaussweight1:
	or	dword ptr fs:[ebx],deletedmark4B
	dec	[rowsnow]
	call	setpivotnumber
	call	gauss1sub
	call	appendhistory
gauss120:
	pop	ebx
	add	ebx,4
	pop	ecx
	dec	ecx
	jnz	gauss110

	call	prot2real

	mov	ax,[didsomesw]
	mov	bx,AR0
	mov	[bx],ax
gauss1out:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

appendhistory:
	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,[ptrbuffer2]
	sub	cx,dx
	jbe	short historyret
	mov	bx,[histhandle]

	mov	ah,40h			;write
	int	21h
	jc	gauss1diskerror
	mov	[didsomesw],1
historyret:
	call	real2protB
	ret

GAUSS1diskerror:
	mov	sp,[spmem]
	mov	bx,AR0
	mov	word ptr [bx],8001h
	jmp	gauss1out


setpivotnumber:
	mov	eax,ebx			;pivot element number
	sub	eax,[pointerbase]
	shr	eax,2
	mov	di,offset BUFFER0
	stosd
	mov	[ptrbuffer2],di
	ret


gauss1sub:
	mov	eax,fs:[esi+4]		;ax = pivot value
	mov	ebx,[pointerbase]
	mov	ecx,[rowstotal]
gauss1submainlp:
	push	ecx			;*
	mov	esi,fs:[ebx]
	test	esi,deletedmark4b
	jnz	short gauss1sub20

	mov	cx,fs:[esi]
	jcxz	short gauss1sub20
gauss1sub12:
	add	esi,4
	cmp	eax,fs:[esi]
	jb	short gauss1sub20
	je	short gauss1sub30
	loop	gauss1sub12

gauss1sub20:
	add	ebx,4
	pop	ecx			;*
	dec	ecx
	jnz	gauss1submainlp
	ret

gauss1sub30:
	push	eax
	call	cutthis
	call	memooperation
	pop	eax
	jmp	gauss1sub20

cutthis:
	mov	edi,fs:[ebx]		;top adr
	mov	cx,fs:[edi]
	dec	cx
	mov	fs:[edi],cx
	inc	cx			;total data#
	mov	eax,esi
	sub	eax,edi
	shr	eax,2			;checked data#
	sub	cx,ax			;remaining data#
	jbe	short cutthisret	;if last data
cutthislp:
	mov	ax,fs:[esi+4]		;cut 1 member
	mov	fs:[esi],ax
	add	esi,4
	loop	cutthislp
cutthisret:
	ret

memooperation:
	mov	di,[ptrbuffer2]
	mov	eax,ebx
	sub	eax,[pointerbase]
	shr	eax,2
	stosd				;memo target
	mov	eax,[BUFFER0]
	stosd			;memo pivot
	mov	[ptrbuffer2],di
	ret


;
; delete row containing 1 data column
;
;command#=5

deleterow:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	[count0],0
	mov	[count1],0

	call	real2protB

	mov	ecx,[FBsize]
	mov	ebx,[counterbase]
delrow10:
	cmp	dword ptr fs:[ebx],1
	ja	short delrow20
	je	short delrow15
	inc	[count0]
	jmp	short delrow20
delrow15:
	inc	[count1]
	mov	eax,fs:[ebx+4]
	shl	eax,2
	add	eax,[pointerbase]
	or	dword ptr fs:[eax],deletedmark4b
	dec	[rowsnow]
delrow20:
	add	ebx,8
	dec	ecx
	jnz	delrow10

	call	prot2real

	mov	eax,[count0]	;//must rewite if > 2^15
	mov	bx,AR0
	mov	[bx],ax
	mov	eax,[count1]	;//
	mov	bx,AR1
	mov	[bx],ax

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf	


;
; count column weight
;
;command#=4

countcolumn:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	call	real2protB

	mov	edi,[counterbase]
	xor	eax,eax			
	mov	ecx,[FBsize]
countc10:				;clear counter
	mov	fs:[edi],eax
	add	edi,8
	dec	ecx
	jnz	countc10

	mov	ebx,[pointerbase]
	mov	ecx,[rowstotal]
	xor	edx,edx			;row#
countc20:
	push	ecx			;/*

	mov	esi,fs:[ebx]
	test	esi,deletedmark4b
	jnz	short countc50

	mov	cx,fs:[esi]
	jcxz	short countc50
countc30:
	add	esi,4
	mov	eax,fs:[esi]
	shl	eax,3			;*8
	add	eax,[counterbase]
	inc	dword ptr fs:[eax]	;count
	mov	fs:[eax+4],edx		;row#
	loop	countc30
countc50:
	inc	edx
	add	ebx,4
	pop	ecx			;*/
	dec	ecx
	jnz	countc20

	mov	[count0],0		;counters for
	mov	[count1],0		;weight 0 and 1

	mov	esi,[counterbase]
	mov	ecx,[FBsize]
countc60:
	cmp	word ptr fs:[esi],1
	jbe	short countc70
countc65:
	add	esi,8
	dec	ecx
	jnz	countc60
	jmp	short countc90

countc70:
	je	short countc80
	inc	[count0]
	jmp	countc65
countc80:
	inc	[count1]
	jmp	countc65

countc90:
	call	prot2real

	mov	eax,[count0]	;//must rewite if > 2^15
	mov	bx,AR0
	mov	[bx],ax
	mov	[columnsweight0],eax
	mov	eax,[count1]	;//
	mov	bx,AR1
	mov	[bx],ax

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

;
; set active/inactive
;
;command#=3

SETACTIVE:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	;count column weight

	call	real2protB

	mov	edi,[counterbase]
	xor	eax,eax			
	mov	ecx,[FBsize]
setact10:			;clear counter
	mov	fs:[edi],eax
	add	edi,8
	dec	ecx
	jnz	setact10

	mov	ebx,[pointerbase]
	mov	ecx,[rowstotal]
setact20:
	push	ecx			;*
	mov	esi,fs:[ebx]
	test	esi,deletedmark4b
	jnz	short setact50
	mov	cx,fs:[esi]
	jcxz	short setact50
setact30:
	add	esi,4
	mov	eax,fs:[esi]
	shl	eax,3			;*8
	add	eax,[counterbase]
	inc	dword ptr fs:[eax]	;count
	loop	setact30
setact50:
	add	ebx,4
	pop	ecx			;*
	dec	ecx
	jnz	setact20

	;count rows for each weight
setact100:
	mov	di,offset BUFFER
	mov	cx,1024		;max column weight
	xor	eax,eax
	rep	stosd

	xor	dx,dx			;maxweight
	mov	ebx,[counterbase]
	mov	ecx,[FBsize]
setact110:
	mov	ax,fs:[ebx]
	cmp	ax,1024
	jb	short setact120
	mov	ax,1023
setact120:
	cmp	ax,dx
	jbe	short setact130
	mov	dx,ax
setact130:
	shl	ax,2
	add	ax,offset BUFFER
	mov	si,ax
	inc	dword ptr [si]	;count this weight
	add	ebx,8
	dec	ecx
	jnz	setact110

	;decide heavy weight

	or	dx,dx
	jz	setactdone

	mov	bx,dx
	mov	cx,dx
	shl	bx,2
	add	bx,offset BUFFER+4
	mov	eax,[inactivenow]
	push	eax			;/*
setact200:
	sub	bx,4
	add	eax,[bx]
	cmp	eax,[inactivenext]
	jae	short setact220
	loop	setact200
	jmp	short setact225
setact220:
	mov	eax,[inactivenext]
setact225:
	mov	[inactivenow],eax
	mov	edx,eax
	mov	eax,[FBsize]
	sub	eax,edx
	shr	eax,inactivesteplog
	inc	eax			;avoid 0
	add	eax,edx
	cmp	eax,[FBsize]
	jbe	short setact230
	mov	eax,[FBsize]
setact230:
	mov	[inactivenext],eax

	mov	ax,bx
	sub	ax,offset BUFFER
	shr	ax,2			;define heavy weight >= ax
	mov	[heavycolweight],ax

	;make inactive

	pop	edx			;*/
	mov	eax,[inactivenow]
	sub	eax,edx
	jz	short setact330
	mov	[inactivecount],eax

	xor	edx,edx			;column#
	mov	ebx,[counterbase]
	dec	edx
	sub	ebx,8
setact310:
	inc	edx
	add	ebx,8
	mov	ax,fs:[ebx]
	cmp	ax,[heavycolweight]
	jb	setact310
	call	deleteDX
	dec	[inactivecount]
	jnz	setact310

setact330:
	mov	ax,[heavycolweight]
setactret:
	push	ax
	call	prot2real
	pop	ax

	mov	bx,AR1
	mov	[bx],ax

	mov	eax,[inactivenow]	;must change if >= 2^15
	mov	bx,AR0
	mov	[bx],ax

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

setactdone:
	xor	ax,ax
	jmp	setactret

deleteDX:
	push	ebx
	mov	ebx,edx
	add	ebx,[activeflgbase]
;	cmp	byte ptr fs:[ebx],1
;	je	short deldxerr		;already inactive
	mov	byte ptr fs:[ebx],1

	mov	ebx,[pointerbase]
	mov	ecx,[rowstotal]
deldx10:
	push	ecx
	mov	esi,fs:[ebx]
	test	esi,deletedmark4B
	jnz	short deldx40

	mov	ecx,fs:[esi]
	or	ecx,ecx
	jz	short deldx40
deldx20:
	add	esi,4
;deldx30:
	cmp	edx,fs:[esi]
	jb	short deldx40
	je	short deldx50
	dec	ecx
	jnz	deldx20	
deldx40:
	add	ebx,4
	pop	ecx
	dec	ecx
	jnz	deldx10

deldxret:
	pop	ebx
	ret

deldx50:
	mov	edi,fs:[ebx]		;top adr
	dec	dword ptr fs:[edi]	;dec elements#
	dec	ecx
	jz	deldx40			;if last element
	push	esi
	push	ecx
deldx60:
	mov	ax,fs:[esi+4]		;slide down
	mov	fs:[esi],ax		;
	add	esi,4
	dec	ecx
	jnz	deldx60
	pop	ecx
	pop	esi
	jmp	deldx40

;
; set row data
; copy PPMPDCMP.PPM to higher address(from [database])

;COMMAND#=2

STORE_DATA:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	si,offset decomfilename
	call	setpathname
	mov	dx,offset BUFFER
	mov	ax,3d00h		;open for read
	int	21h
	jc	storediskerror
	mov	[decomhandle],ax

	mov	[rowstotal],0

	call	real2protB

	;read decomposition data and set in memory
storelp:
	call	prot2real

	mov	dx,offset BUFFER0	;read number of members
	mov	cx,4
	mov	bx,[decomhandle]
	mov	ah,3fh
	int	21h
	or	ax,ax
	jz	decomeof

	mov	bx,offset BUFFER0	;read all members
	lea	dx,[bx+4]
	mov	cx,[bx]			;use ony 2 byte
	shl	cx,2
	mov	bx,[decomhandle]
	mov	ah,3fh
	int	21h

	call	real2protB

	mov	ebx,[pointernow]
	mov	edi,[datanow]
	mov	fs:[ebx],edi
	add	ebx,4
	mov	[pointernow],ebx

	; set to protect memory neglecting duplicate data

 	mov	si,offset BUFFER0
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	mov	cx,ax
	jcxz	short setdatajp
setdata2:				;cut small primes
	lodsd
	cmp	eax,[inactivenow]
	jae	short setdata6
	loop	setdata2
	jmp	short setdatajp

setdata5:
	lodsd
setdata6:
	dec	cx
	jz	short setdata20
setdatalp:
	mov	edx,eax			;old value
	lodsd
	cmp	eax,edx
	jne	short setdata10
	dec	cx
	jz	short setdatajp
	jmp	setdata5
setdata10:
	mov	fs:[edi],edx
	add	edi,4
	loop	setdatalp
setdata20:
	mov	fs:[edi],eax
	add	edi,4
setdatajp:
	mov	ebx,[datanow]
	mov	[datanow],edi
	sub	edi,ebx
	shr	edi,2
	dec	di
	mov	fs:[ebx],di		;# of elements
	inc	[rowstotal]
	jmp	storelp

decomeof:
	mov	eax,[rowstotal]
	mov	[rowsnow],eax

	mov	ah,3eh			;close
	mov	bx,[decomhandle]
	or	bx,bx
	jz	short decompeofskip
	int	21h

decompeofskip:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

storediskerror:
	mov	bx,AR0
	mov	word ptr [bx],8001h	;-1 of UB
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

decomfilename	db	'PPMPDCMP.PPM',0

;
; get and set primes
; copy PPMPPRMS.PPM to higher address

;command#=1

getprime:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	si,offset primefilename
	call	setpathname
	mov	dx,offset BUFFER
	mov	ax,3d00h		;open for read
	int	21h
	jc	getprimediskerror
	mov	[primehandle],ax

	call	real2protB

	mov	edi,fs:[_primeadr]
primelp:
	push	edi		;/*

	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,400h
	mov	bx,[primehandle]
	mov	ah,3fh
	int	21h
	or	ax,ax
	jz	short primeeof

	push	ax
	call	real2protB
	pop	ax

	pop	edi		;*/

	shr	ax,2
	mov	cx,ax
	mov	si,offset BUFFER
prime50:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	prime50
	jmp	primelp

primeeof:
	pop	edi		;*/ dummy

	mov	ah,3eh
	mov	bx,[primehandle]
	or	bx,bx
	jz	short primeeofskip
	int	21h

primeeofskip:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

getprimediskerror:
	mov	bx,AR0
	mov	word ptr [bx],8001h	;-1 of UB
	jmp	primeeof

primefilename	db	'PPMPPRMS.PPM',0


;
;* Initialize
;COMMAND#=0

;	V1 = P
;	V2 = W#
;	V3 = datadrivename
;	AR[1]	TOTAL SIZE \ 32
;	AR[2]	DRIVE NUMBER

INITIALIZE:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	MOV	BX,V1		;adr of P
	MOV	AX,[BX]
	MOV	[P_OFF],AX
	MOV	AX,[BX+2]
	MOV	[P_SEG],AX

	MOV	BX,V2		;adr of W#
	MOV	AX,[BX]
	MOV	[W_OFF],AX
	MOV	AX,[BX+2]
	MOV	[W_SEG],AX

	MOV	BX,V3		;set the address of Drv$
	MOV	AX,[BX]
	MOV	[Drv_OFF],AX
	MOV	AX,[BX+2]
	MOV	[Drv_SEG],AX

	xor	eax,eax
	MOV_AX	AR1
	shl	eax,5		;*32
	mov	[FBsize],eax
	dec	eax
	mov	[primes],eax
	inc	eax

	shr	eax,5			;start from 1/32(//)
	sub	eax,16
	mov	[inactivenext],eax
	add	eax,16
	shr	eax,1
	mov	[inactivenow],eax

	;DPMI initialize

	mov	eax,[FBsize]
	mov	ecx,eax
	shl	eax,2
	mov	ebx,eax
	mov	[activeflgbase],eax
	add	eax,ecx		;active flg uses 1 byte
	mov	[counterbase],eax
	add	eax,ebx
	add	eax,ebx		;counter uses 8 byte
	mov	[pointerbase],eax
	mov	[pointernow],eax
	add	eax,ebx		;pointer uses 4 byte
	mov	[database],eax
	mov	[datanow],eax

	;needs memories after [database]
	;   which is >= size of PPMPDCMP.PPM file

	mov	dx,offset decomfilename
	mov	ax,3d00h		;read open
	int	21h

	push	ax
	mov	bx,ax
	mov	ax,4202h		;move file ptr to end
	xor	cx,cx
	xor	dx,dx
	int	21h
					;now dx:ax = file size
	pop	bx
	push	dx
	push	ax

	mov	ah,3eh			;close file
	int	21h

	pop	eax
	add	eax,[database]
	add	eax,15			;for alignment safety
	mov	[DPMImemorysize],eax
	call	DPMIinit
	jc	DPMIerror

	mov	eax,dword ptr [DPMIaddresslow]
	add	eax,0fh
	and	ax,0fff0h
	mov	fs:[_primeadr],eax
	mov	[primeadrnow],eax
	add	[activeflgbase],eax
	add	[counterbase],eax
	add	[pointerbase],eax
	add	[pointernow],eax
	add	[database],eax
	add	[datanow],eax

	mov	esi,[activeflgbase]	;set active/inactive
	mov	al,1
	mov	ecx,[inactivenow]
init80:
	mov	fs:[esi],al
	inc	esi
	dec	ecx
	jnz	init80

	xor	al,al
	mov	ecx,[FBsize]
	sub	ecx,[inactivenow]
init90:
	mov	fs:[esi],al
	inc	esi
	dec	ecx
	jnz	init90

	call	prot2real

	mov	dx,offset historyfilename
	mov	ah,3ch			;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[histhandle],ax

	mov	ax,word ptr [DPMImemorysize+2]
	mov	bx,AR1
	mov	[bx],ax

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

diskerror:
	mov	bx,AR0
	mov	word ptr [bx],8001h	;-1 of UB

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

dpmierror:
;	call	prot2real
	mov	bx,AR1
	mov	word ptr [bx],8001h	;-1 of UB
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


setpathname:		;input si
			;must be in real mode
	push	ax
	push	cx
	push	di

	push	ds			;/*
	push	si

	lds	si,dword ptr [Drv_off]
	mov	di,offset BUFFER
	lodsw
	mov	cx,ax
	shl	cx,1
	and	cx,00ffh		;cut 255 chars
	shl	ax,1
	jnc	short setpath10
	dec	cx
setpath10:
	rep	movsb

	pop	si
	pop	ds			;*/

setpath20:
	lodsb
	stosb
	or	al,al
	jnz	setpath20

	pop	di
	pop	cx
	pop	ax
	ret


historyfilename	db	'PPMPHIST.PPM',0

	align	4
BUFFER0	dd	?
BUFFER	dd	2000h dup(0)


CODE	ENDS
END	START
