;PPMPX3.ASM 3.3 (for DPMI)
;	MACHINE LANGUAGE SUBROUTINES
;	FOR PPMPQS 3A,3B,XDAT
;	1991-97 by YUJI KIDA
;
.386P

code	segment	use16
	assume cs:code, ds:code


	INCLUDE	UBP.MAC
	include	ppmpx.h

transadr	macro
	shl	eax,2		;mult 12=RAMUNITBYTES
	mov	edx,eax		;
	shl	eax,1		;
	add	eax,edx		;
	add	eax,[lpptop]
endm

changestack	macro
	cli
	mov	cs:[ssmem],ss
	mov	cs:[spmem],sp
	mov	ax,cs
	mov	ss,ax
	mov	esp,offset mystackend
	sti
	endm

restorestack	macro
	cli
	mov	ax,cs:[ssmem]
	mov	sp,cs:[spmem]
	mov	ss,ax
	mov	ds,ax
	mov	es,ax
	sti
	endm


	org	100h
start:
	JMP	START0

	include	dpmi4ub.h
	include	dpmi4ub.lib


	align	4
sortwork	dd	RAMUNITBYTES/4 dup(?)

R1_OFF	dw	?
R1_SEG	dw	?
R2_OFF	dw	?
R2_SEG	dw	?
X_OFF	dw	?
X_SEG	dw	?

lpptop		dd	?
lppptr		dd	?
lppover		dd	?
lppcount	dd	?
lppptr2         dd      ?
erasecount      dd      ?

baseXbytes	dw	?,0
baseunitbytes	dw	?,0

basefileptr	dd	?
getreladr	dd	?

basehandle	dw	0	;must be 0
combihandle	dw	0	;"

ssmem		dw	?
spmem		dw	?

R1_buffer	db	4 dup(?)
R2_buffer	db	4 dup(?)
X_buffer	db	maxXbytes dup(?)
X2_buffer	db	maxXbytes dup(?)

bufferptr	dw	?
buffer1		db	COMBIUNITBYTES dup (?)
buffer2		db	COMBIUNITBYTES dup (?)

elimcount	dd	?
exchangesw	db	?


;* branching


START0:
	MOV_AX	AR0		;ARRAY[0] is the command number
	MOV	BX,offset CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	dw	ALLINIT,lppINIT,SETDATA,QSORT,ISORT
	dw	ELIMINATION,GETRELATION,GETBASES,CLOSEHANDLE
	dw	freememory,checkdata,getdata

;
; command#=11
;
getdata:
	changestack

	mov	ax,cs
	mov	ds,ax

	call	real2protB

	mov	ebx,[lppptr2]
getdatalp:
	cmp	ebx,[lppover]
	jae	getdataover

	mov	esi,fs:[ebx+8]
	cmp	esi,-1
	jne	getdatain

	add	ebx,RAMUNITBYTES
	jmp	getdatalp		;if erased data

getdatain:
	add	ebx,RAMUNITBYTES
	mov	[lppptr2],ebx

	xor	esi,COMBIMASK
	push	esi		;/*

	call	prot2real

	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	bx,[basehandle]
	pop	dx		;*/
	pop	cx		;
	mov	ax,4200h	;move pointer absolute
	int	21h
	mov	bx,[basehandle]
	mov	dx,offset R1_buffer
	mov	cx,[baseunitbytes]
	mov	ah,3fh			;read handle
	int	21h

	les	di,dword ptr [R1_off]
	mov	cx,2
	mov	ax,word ptr [R1_buffer]
	mov	dx,word ptr [R1_buffer+2]
	mov	es:[di+2],ax
	mov	es:[di+4],dx
	mov	cx,2
	or	dx,dx
	jnz	getdata50
	dec	cx
	or	ax,ax
	jnz	getdata50
	dec	cx
getdata50:
	mov	es:[di],cx

	les	di,dword ptr [R2_off]
	mov	cx,2
	mov	ax,word ptr [R2_buffer]
	mov	dx,word ptr [R2_buffer+2]
	mov	es:[di+2],ax
	mov	es:[di+4],dx
	mov	cx,2
	or	dx,dx
	jnz	getdata60
	dec	cx
	or	ax,ax
	jnz	getdata60
	dec	cx
getdata60:
	mov	es:[di],cx

	les	di,dword ptr [X_off]
	mov	si,offset X_buffer
	mov	cx,[si]
	inc	cx
	rep	movsw

	restorestack
	retf

getdataover:
	call	prot2real

	mov	ax,cs
	mov	ds,ax
	lds	si,dword ptr [R1_off]
	mov	word ptr [si],0		;end mark

	restorestack
	retf


; sweep down the '1'

sweep1:
	mov	esi,[lpptop]
	mov	edi,ebx			;input from the main
	mov	ebx,edi			;last '1'
	mov	edx,RAMUNITBYTES
sweepLP:
	mov	eax,1

	;find '1' from the top
sweep10:
	add	esi,edx
	cmp	eax,fs:[esi]
	jne	sweep10

	;find non '1' from the bottom
sweep20:
	sub	edi,edx
	cmp	eax,fs:[edi]
	je	sweep20
	cmp	esi,edi
	ja	sweepret

	mov	eax,fs:[esi]
	xchg	eax,fs:[edi]
	mov	fs:[esi],eax
	mov	eax,fs:[esi+4]
	xchg	eax,fs:[edi+4]
	mov	fs:[esi+4],eax
	mov	eax,fs:[esi+8]
	xchg	eax,fs:[edi+8]
	mov	fs:[esi+8],eax
	mov	ebx,edi			;last '1'
	jmp	sweepLP
sweepret:
	ret


; check whether the sorting worked well
; inp ebx:start ecx:end
check:
	mov	eax,ebx
	transadr
	mov	esi,eax
	sub	ecx,ebx
	jbe	checkret	;no data to compare
checklp:
	mov	eax,fs:[esi]
	mov	edx,fs:[esi+4]
	add	esi,RAMUNITBYTES
	cmp	eax,fs:[esi]
	jb	checkerror
	ja	checknext
	cmp	edx,fs:[esi+4]
	ja	checkerror
checknext:
	dec	ecx
	jnz	checklp
checkret:
	clc
	ret
checkerror:
	stc
	ret

;
; * free DPMI memories
; commane#=9
freememory:
	changestack
	call	freemainDATAmemory
	restorestack
	retf


;
; close&delete base- and combination- files
; command#=8

CLOSEHANDLE:
	mov	ax,cs
	mov	ds,ax

	mov	bx,[basehandle]
	or	bx,bx
	jz	closejp10
	mov	ah,3eh
	int	21h
	mov	[basehandle],0

;	mov	ah,41h
;	mov	dx,offset BASEFILENAME
;	int	21h

closejp10:
	mov	bx,[combihandle]
	or	bx,bx
	jz	closejp20
	mov	ah,3eh
	int	21h
	mov	[combihandle],0

;	mov	ah,41h
;	mov	dx,offset COMBIFILENAME
;	int	21h

closejp20:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

;
; get combination members
; command#=7

GETBASES:
	mov	ax,cs
	mov	ds,ax

	mov	si,[bufferptr]
	mov	dx,[si]
	mov	cx,[si+2]	;cx:dx = file ptr
	mov	ax,dx
	or	ax,cx
	jz	getbasesnomore
	add	si,4
	mov	[bufferptr],si
	mov	ah,42h		;move file ptr
	mov	al,0		;absolute
	mov	bx,[basehandle]
	int	21h

	mov	ah,3fh		;read handle
	mov	dx,offset R1_buffer
	mov	cx,[baseunitbytes]
	int	21h

	;set R1,R2,X

	les	di,dword ptr [R1_off]
	mov	eax,dword ptr [R1_buffer]
	mov	es:[di+2],eax
	mov	cx,1
	xor	ax,ax
	or	eax,eax
	jz	short getbase50
	inc	cx
getbase50:
	mov	es:[di],cx

	les	di,dword ptr [R2_off]
	mov	eax,dword ptr [R2_buffer]
	mov	es:[di+2],eax
	mov	cx,1
	xor	ax,ax
	or	eax,eax
	jz	short getbase60
	inc	cx
getbase60:
	mov	es:[di],cx

	les	di,dword ptr [X_off]
	mov	si,offset X_buffer
	mov	cx,[si]
	and	cx,LENMASK
	inc	cx
	rep	movsw

getbasesret:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

getbasesnomore:
	les	di,dword ptr [R1_off]	;set R1=0
	mov	word ptr es:[di],0
	jmp	getbasesret


;
; find relation
; command#=6

GETRELATION:
	changestack

	mov	ax,cs
	mov	ds,ax

	call	real2protB

getrelationLP:
	mov	ebx,[getreladr]
	sub	ebx,RAMUNITBYTES
	mov	[getreladr],ebx

	cmp	dword ptr fs:[ebx],1
	jne	short nomorerelation

	mov	eax,fs:[ebx+8]
	or	eax,eax
	jz	getrelationLP		;erased data

	mov	dx,offset buffer1
	call	getcombi
	mov	si,offset buffer1
	mov	[bufferptr],si
getrelation50:
	add	si,4
	cmp	dword ptr [si-4],COMBIMASK
	jb	getrelation50
	xor	dword ptr [si-4],COMBIMASK
	mov	dword ptr [si],0	;end mark
	call	prot2real
getrelationret:
	restorestack
	retf

nomorerelation:
	call	prot2real

	mov	bx,AR0
	mov	word ptr [bx],0
	jmp	getrelationret


;
; pseudo-Gaussian elimination
; command#=5

ELIMINATION:
	changestack

	mov	ax,cs
	mov	ds,ax

	mov	dx,offset COMBIFILENAME	;create combination file
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[combihandle],ax
	mov	bx,ax

	call	writeinitcombi		;dummy

	mov	eax,[lppptr]
	mov	[lppover],eax
	push	eax

	call	real2protB

	pop	eax
	mov	dword ptr fs:[eax],1	;sentinel

	sub	eax,[lpptop]
	xor	edx,edx
	mov	ecx,RAMUNITBYTES
	div	ecx
	dec	eax
	mov	[lppcount],eax		;# of data
	mov	ecx,eax

elimIN:
	mov	[exchangesw],0
	mov	ebx,[lpptop]
	add	ebx,RAMUNITBYTES

elimLP1:
	mov	eax,fs:[ebx]	;R
	cmp	eax,1
	je	short elimdone
	mov	esi,ebx
elimLP2:
	add	esi,RAMUNITBYTES
	cmp	eax,fs:[esi]	;next R
	je	elimmatch
	mov	ebx,esi
	jmp	short elimLP1

elimdone:
	call	sweep1		;sweep down the '1's (use ebx)

	mov	eax,ebx
	sub	eax,[lpptop]
	xor	edx,edx
	mov	ecx,RAMUNITBYTES
	div	ecx
	dec	eax
	mov	[elimcount],eax

	cmp	[exchangesw],0
	je	short elim_alldone

	mov	ecx,eax
	push	ecx
	mov	ebx,1
	call	qsortmain
	pop	ecx
	push	ecx
	call	isortmain
	pop	ecx
	mov	ebx,1		;ebx:start, ecx:end
	call	check
jc stop
	jmp	elimIN

stop:
jmp stop		;endless loop



elim_alldone:
	call	number_relations
	mov	eax,[lppover]
	mov	[getreladr],eax
	push	ecx

	call	prot2real

	pop	ecx
	lds	si,dword ptr [X_OFF]
	mov	[si+2],ecx
	xor	ax,ax
elim90:
	jecxz	short elim100
	inc	ax
	shr	ecx,16
	jmp	elim90
elim100:
	mov	[si],ax

	restorestack
	retf


elimmatch:
	mov	[exchangesw],-1
elimmatchLP:
	mov	ecx,fs:[ebx+4]
	mov	edx,fs:[esi+4]
	cmp	ecx,edx
	je	short fullmatch
halfmatch:
	mov	fs:[esi],edx	;new R1 = max of old R2 & R2'
	mov	fs:[esi+4],ecx	;new R2 = min of old R2 & R2'
	jmp	short rewritecombi
fullmatch:
	mov	dword ptr fs:[esi],1	;new R1 = 1
	mov	dword ptr fs:[esi+4],1	;new R2 = 1

rewritecombi:
	push	esi			;/
	push	ebx			;/*
	mov	eax,fs:[esi+8]
	mov	dx,offset buffer1
	call	getcombi
	pop	ebx			;*/
	push	ebx			;/*
	mov	eax,fs:[ebx+8]
	mov	dx,offset buffer2
	call	getcombi
	push	si
	call	linkcombi
	pop	si
	sub	di,offset buffer1
	cmp	di,COMBIUNITBYTES
	ja	short toolonglink
	call	putnewcombi
	pop	ebx			;*/
	pop	esi			;/
	mov	fs:[esi+8],eax		;new file ptr
	jmp	elimLP2


toolonglink:
	mov	dword ptr fs:[esi],1	;erased marks
	mov	dword ptr fs:[esi+4],1	;
	mov	dword ptr fs:[esi+8],0	;
	pop	ebx
	pop	esi
	jmp	elimLP2

getcombi:
	cmp	eax,COMBIMASK
	jae	short getcombidirect

	push	esi		;/*

	push	dx
	push	eax
	call	prot2real
	pop	eax
	mov	dx,ax
	shr	eax,16
	mov	cx,ax		;cx:dx = file ptr
	mov	ah,42h		;move pointer
	mov	al,0		;absolute
	mov	bx,[combihandle]
	int	21h

	pop	dx
	mov	ah,3fh		;read handle
	mov	cx,COMBIUNITBYTES
	int	21h

	call	real2protB

	pop	esi		;*/
	ret

getcombidirect:
	mov	bx,dx
	mov	[bx],eax
	ret


linkcombi:
	mov	di,offset buffer1-4
	mov	si,offset buffer2
linkcombi10:
	add	di,4
	cmp	dword ptr [di],COMBIMASK
	jb	linkcombi10
	xor	dword ptr [di],COMBIMASK
	add	di,4
linkcombi20:
	mov	eax,[si]
	mov	[di],eax
	add	si,4
	add	di,4
	cmp	eax,COMBIMASK
	jb	linkcombi20
	ret			;di = next of endmark

putnewcombi:
	push	esi		;/
	push	di		;/* size

	call	prot2real

	mov	ah,42h		;move pointer
	mov	al,2		;to the end
	mov	bx,[combihandle]
	xor	cx,cx
	xor	dx,dx
	int	21h

	pop	cx		;*/
	push	dx		;/* dx:ax = new ptr
	push	ax		;/**

	mov	dx,offset buffer1
	mov	ah,40h		;write handle
	int	21h
	cmp	ax,cx
	jne	short combidiskfull

	call	real2protB

	pop	eax		;**/ */ eax = new ptr
	pop	esi		;/
	clc
	ret

writeinitcombi:		;must be in real mode
	mov	dx,offset buffer1
	mov	ah,40h		;write handle
	mov	bx,[combihandle]
	mov	cx,4
	int	21h
	cmp	ax,cx
	jne	short combidiskfull
	clc
	ret

combidiskfull:		;must be in real mode
	mov	word ptr ds:[AR0],8001h

	restorestack
	retf


number_relations:
	mov	eax,[elimcount]
	mov	edx,RAMUNITBYTES
	mul	edx
	add	eax,[lpptop]
	mov	ebx,eax
	xor	ecx,ecx
numrel10:
	add	ebx,RAMUNITBYTES
	cmp	ebx,[lppover]
	jae	short numrel100

	cmp	dword ptr fs:[ebx+8],0
	je	numrel10		;erased data
	inc	ecx
	jmp	numrel10
numrel100:
	mov	eax,ecx
	ret			;eax = ecx = result


;
; insertion sort wrt R1 as 1stKey and R2 as 2ndKey
; command#=4

copydsSIfsDI	macro
	mov	eax,ds:[esi]	;12 bytes
	mov	fs:[edi],eax
	mov	eax,ds:[esi+4]
	mov	fs:[edi+4],eax
	mov	eax,ds:[esi+8]
	mov	fs:[edi+8],eax
endm
copyfsSIfsDI	macro
	mov	eax,fs:[esi]	;12 bytes
	mov	fs:[edi],eax
	mov	eax,fs:[esi+4]
	mov	fs:[edi+4],eax
	mov	eax,fs:[esi+8]
	mov	fs:[edi+8],eax
endm
copyfsSIdsDI	macro
	mov	eax,fs:[esi]	;12 bytes
	mov	ds:[edi],eax
	mov	eax,fs:[esi+4]
	mov	ds:[edi+4],eax
	mov	eax,fs:[esi+8]
	mov	ds:[edi+8],eax
endm


ISORT:
	changestack

	call	real2protB

	mov	ecx,[lppcount]
	call	isortmain

	call	prot2real

	restorestack
	retf


	align	4
isortmain:
	dec	ecx		;loop times
	mov	ebx,2*RAMUNITBYTES
	add	ebx,[lpptop]	;ebx = adr of a[2]

isort10:
	; if a[i] <= a[i-1] then skip this

	mov	eax,fs:[ebx]
	cmp	eax,fs:[ebx-RAMUNITBYTES]
	ja	short isort15
	jb	isortskip
	mov	eax,fs:[ebx+4]
	cmp	eax,fs:[ebx-RAMUNITBYTES+4]
	jae	isortskip
isort15:
	; w := a[i] , a[0] := a[i] = sentinel

	mov	esi,ebx
	mov	edi,offset sortwork
	copyfsSIdsDI

	mov	esi,ebx
	mov	edi,[lpptop]
	copyfsSIfsDI

	; j:= i-1;

	lea	esi,[ebx-RAMUNITBYTES]	; esi = &a[j]

	; while w > a[j] do

	mov	edx,[sortwork+4]
isort20:
	mov	eax,[sortwork]
	cmp	eax,fs:[esi]
	jb	short isort50
	ja	short isort30
	cmp	edx,fs:[esi+4]
	jae	short isort50
isort30:
	; a[j+1]:= a[j]; j:= j-1;

	lea	edi,[esi+RAMUNITBYTES]
	copyfsSIfsDI
	sub	esi,RAMUNITBYTES
	jmp	isort20
isort50:
	; a[j+1]:= w;

	lea	edi,[esi+RAMUNITBYTES]
	mov	esi,offset sortwork
	copydsSIfsDI

isortskip:
	add	ebx,RAMUNITBYTES
	dec	ecx
	jnz	isort10
	ret

;
; shell sort
;

	align	4
varH	dd	?
varN	dd	?
Hskip	dd	?

ssortmain:
	; h:= 1;
	; while h<n do h:= h*3+1;

	mov	[varN],ecx
	mov	eax,1
ssort5:
	mov	edx,eax
	shl	eax,1
	add	eax,edx
	inc	eax
	cmp	eax,ecx		;//qsortcutoff
	jb	ssort5
	mov	[varH],eax

	; while h>1 do
ssort8:
	mov	eax,[varH]
	cmp	eax,1
	jbe	ssortout

	; h:= h div 3;

	xor	edx,edx
	mov	ebx,3
	div	ebx
	mov	[varH],eax
	mov	edx,RAMUNITBYTES
	mul	edx
	mov	[Hskip],eax

	; for i:= h+1 to n do

	mov	ecx,[varN]
	mov	eax,[varH]
	sub	ecx,eax
	inc	eax
	transadr
	mov	ebx,eax
ssort10:
	push	ecx		;/*

	; w:= a[i]; j:= i-h;

	mov	esi,ebx
	mov	edi,offset sortwork
	copyfsSIdsDI

	mov	esi,ebx
	sub	esi,[Hskip]

	; while w>a[j] do
ssort30:
	mov	eax,[sortwork]
	cmp	eax,fs:[esi]
	jb	short ssortLABEL1
	ja	short ssort40
	mov	eax,[sortwork+4]
	cmp	eax,fs:[esi+4]
	jae	short ssortLABEL1
ssort40:
	; a[j+h]:= a[j]; j:= j-h;

	mov	edi,esi
	add	edi,[Hskip]
	copyfsSIfsDI

	sub	esi,[Hskip]

	; if j<=0 then goto 1

	cmp	esi,[lpptop]
	ja	ssort30

	; a[j+h]:= w;

ssortLABEL1:
	mov	edi,esi
	add	edi,[Hskip]
	mov	esi,offset sortwork
	copydsSIfsDI
ssort50:
	add	ebx,RAMUNITBYTES
	pop	ecx			;*/
	dec	ecx
	jnz	ssort10
	jmp	ssort8
ssortout:
	ret

;
; quick sort
; command#=3

QSORT:
	changestack
	mov	ax,cs
	mov	ds,ax

	mov	dx,offset COMBIFILENAME	;create combination file
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[combihandle],ax
	mov	bx,ax

	call	writeinitcombi		;dummy

	mov	eax,[lppptr]
	mov	[lppover],eax
	push	eax

	call	real2protB

	pop	eax
	mov	dword ptr fs:[eax],1	;sentinel

	sub	eax,[lpptop]
	xor	edx,edx
	mov	ecx,RAMUNITBYTES
	div	ecx
	dec	eax
	mov	[lppcount],eax		;# of data

	;go to qsort

	mov	ebx,1		;start index
	mov	ecx,[lppcount]	;end index

	call	qsortmain

	call	prot2real

	mov	ah,3eh
	mov	bx,[combihandle]	;close file
	int	21h

	restorestack
	retf

;
; quick sort
; do not sort precisely
; stop s
;    if stack almost empty
;    if number of data <= _QSORTCUTOFF

_s	equ	0
_e	equ	4
_i	equ	8
_j	equ	12
_pivot	equ	16

	align	4
qsortmain:				;ebx=S,ecx=E
	push	bp
	sub	sp,24
	cmp	sp,offset mystacktop
	jb	qsortret

	mov	eax,ebx
	add	eax,_QSORTCUTOFF
	cmp	eax,ecx
	jae	qsortret

	mov	bp,sp
	mov	[bp+_s],ebx
	mov	[bp+_i],ebx
	mov	[bp+_e],ecx
	mov	[bp+_j],ecx

	mov	eax,ebx
	add	eax,ecx
	shr	eax,1		;eax=(E+S)/2
	transadr
	mov	eax,fs:[eax]
	mov	[bp+_pivot],eax

qsort10:
	mov	eax,[bp+_i]
	transadr
	mov	eax,fs:[eax]
	cmp	eax,[bp+_pivot]
	jbe	short qsort20
	inc	dword ptr [bp+_i]
	jmp	qsort10
qsort20:
	mov	eax,[bp+_j]
	transadr
	mov	eax,fs:[eax]
	cmp	eax,[bp+_pivot]
	jae	short qsort30
	dec	dword ptr [bp+_j]
	jmp	qsort20
qsort30:
	mov	eax,[bp+_i]
	cmp	eax,[bp+_j]
	ja	short qsort50
	transadr
	mov	esi,eax

	mov	eax,[bp+_j]
	transadr
	mov	edi,eax

	mov	eax,fs:[esi]
	xchg	eax,fs:[edi]
	mov	fs:[esi],eax
	mov	eax,fs:[esi+4]
	xchg	eax,fs:[edi+4]
	mov	fs:[esi+4],eax
	mov	eax,fs:[esi+8]
	xchg	eax,fs:[edi+8]
	mov	fs:[esi+8],eax

	inc	dword ptr [bp+_i]
	dec	dword ptr [bp+_j]
qsort50:
	mov	eax,[bp+_i]
	cmp	eax,[bp+_j]
	jbe	qsort10
	mov	ebx,[bp+_s]
	mov	ecx,[bp+_j]
	call	qsortmain
	mov	ebx,[bp+_i]
	mov	ecx,[bp+_e]
	call	qsortmain
qsortret:
	add	sp,24
	pop	bp
	ret

;
; set lpp data
; command#=2

SETDATA:
	changestack

	;set R1,R2,X on buffer

	lds	si,dword ptr cs:[R1_OFF]
	call	getEAX
	mov	dword ptr cs:[R1_buffer],eax	;set R1

	lds	si,dword ptr cs:[R2_OFF]
	call	getEAX
	mov	dword ptr cs:[R2_buffer],eax	;set R2

	mov	ax,cs			;set X
	mov	es,ax
	mov	di,offset X_buffer
	lds	si,dword ptr cs:[X_OFF]
	mov	cx,[si]
	inc	cx
	rep	movsw

	;write to disk

	mov	ax,cs
	mov	ds,ax
	mov	bx,[basehandle]
	mov	dx,offset R1_buffer
	mov	cx,[baseunitbytes]

	mov	ah,40h			;write handle
	int	21h
	jc	diskerror

	call	real2protB

	mov	ebx,[lppptr]
	mov	eax,dword ptr [R1_buffer]
	mov	fs:[ebx],eax
	mov	eax,dword ptr [R2_buffer]
	mov	fs:[ebx+4],eax
	mov	eax,[basefileptr]
	or	eax,COMBIMASK		;direct pointer to BASEFILE
	mov	fs:[ebx+8],eax
	xor	eax,COMBIMASK
	add	eax,dword ptr [baseunitbytes]
	mov	[basefileptr],eax
	add	ebx,RAMUNITBYTES
	mov	[lppptr],ebx

	call	prot2real

	restorestack
	retf

getEAX:			;get DWORD to EAX from DS:SI
	xor	eax,eax
	lodsw
	and	ax,LENMASK
	mov	cx,ax
	lodsd
	cmp	cx,1
	jne	short getEAX10
	and	eax,0000ffffh
getEAX10:
	ret

;
; lpp initialize
; command#=1

lppINIT:
	changestack

	mov	ax,cs
	mov	ds,ax

	mov	eax,dword ptr [DPMIaddresslow]
	add	eax,0fh
	and	al,0f0h
	mov	[lpptop],eax

	call	real2protB

	mov	ebx,[lpptop]
	xor	eax,eax
	mov	fs:[ebx],eax		;dummy data
	mov	fs:[ebx+4],eax		;
	mov	fs:[ebx+8],eax		;
	add	ebx,RAMUNITBYTES		
	mov	[lppptr],ebx
	mov	[lppptr2],ebx

	call	prot2real

	mov	ah,0dh
;	mov	dx,offset BASEFILENAME
	int	21h

	mov	dx,offset BASEFILENAME	;create base file
	mov	ah,3ch			;create handle
	mov	cx,0
	int	21h
	jc	short diskerror
	mov	[basehandle],ax

	mov	bx,ax			;write dummy
	mov	dx,offset R1_buffer
	mov	cx,[baseunitbytes]
	mov	ah,40h			;write handle
	int	21h
	jc	short diskerror

	mov	eax,dword ptr [baseunitbytes]
	mov	[basefileptr],eax

	restorestack
	retf

diskerror:
	mov	word ptr ds:[AR0],8001h

	restorestack
	retf


BASEFILENAME	db	'PPMPBASE.PPM',0
COMBIFILENAME	db	'PPMPCOMB.PPM',0


;
; command#=10
;	erase duplicated data
checkdata:
	changestack

	mov	ax,cs
	mov	ds,ax

	call	real2protB

	xor	ecx,ecx		;clear higher 16bits
	mov	[erasecount],ecx
	mov	ebx,[lpptop]
dupchkLP1:
	add	ebx,RAMUNITBYTES
	cmp	ebx,[lppover]
	jae	dupchkalldone

	mov	eax,fs:[ebx]	;R
	mov	edx,fs:[ebx+4]	;R2
	mov	edi,ebx
dupchkLP2:
	add	edi,RAMUNITBYTES
	cmp	edi,[lppover]
	jae	dupchkalldone

	cmp	eax,fs:[edi]	;next R
	jne	dupchkLP1
	cmp	edx,fs:[edi+4]	;next R2
	jne	dupchkLP1
	push	eax
	push	ebx
	push	edx
	push	edi
	mov	esi,fs:[ebx+8]
	mov	edi,fs:[edi+8]
	xor	esi,COMBIMASK
	xor	edi,COMBIMASK
	add	esi,8
	add	edi,8
	call	compdiskdata
	pop	edi
	pop	edx
	pop	ebx
	pop	eax
	jne	dupchkLP2
	mov	dword ptr fs:[ebx+8],-1	;erase mark
	inc	[erasecount]
	jmp	dupchkLP1

dupchkalldone:

dupchkend:
	mov	eax,[erasecount]
	push	eax			;# of erased data
	sub	[lppcount],eax		;# of data

	call	prot2real

	lds	si,dword ptr [X_OFF]
	pop	ecx
	mov	[si+2],ecx
	xor	ax,ax
dupchk90:
	jecxz	short dupchk100
	inc	ax
	shr	ecx,16
	jmp	dupchk90
dupchk100:
	mov	[si],ax

	restorestack
	retf

compdiskdata:
	;compare data indisk
	; esi, edi : file pointer

	push	esi
	push	edi

	call	prot2real

	;read from disk

	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	bx,[basehandle]
	pop	dx
	pop	cx
	mov	ax,4200h	;move pointer absolute
	int	21h
	mov	bx,[basehandle]
	mov	dx,offset X_buffer
	mov	cx,2			;attributes
	mov	ah,3fh			;read handle
	int	21h
	mov	bx,[basehandle]
	mov	dx,offset X_buffer+2
	mov	cx,word ptr [X_buffer]
	add	cx,cx
	mov	ah,3fh			;read handle
	int	21h

	mov	bx,[basehandle]
	pop	dx
	pop	cx
	mov	ax,4200h	;move pointer absolute
	int	21h
	mov	bx,[basehandle]
	mov	dx,offset X2_buffer
	mov	cx,2			;attributes
	mov	ah,3fh			;read handle
	int	21h
	mov	bx,[basehandle]
	mov	dx,offset X2_buffer+2
	mov	cx,word ptr [X2_buffer]
	add	cx,cx
	mov	ah,3fh			;read handle
	int	21h

	mov	si,offset X_buffer
	mov	di,offset X2_buffer
	mov	cx,[si]
	inc	cx
	repe	cmpsw
	pushf
	call	real2protB
	popf
	ret



;
; initialize work area
;COMMAND#=0

;	V1=R1
;	V2=R2
;	V3=X

ALLINIT:
	changestack

	MOV	BX,V1		;set R1 ADDRESS
	mov	ax,cs:[bx]
	MOV	CS:[R1_OFF],ax
	mov	ax,cs:[bx+2]
	MOV	CS:[R1_SEG],ax

	MOV	BX,V2		;set R2 ADDRESS
	mov	ax,cs:[bx]
	MOV	CS:[R2_OFF],ax
	mov	ax,cs:[bx+2]
	MOV	CS:[R2_SEG],ax

	MOV	BX,V3		;set X ADDRESS
	mov	ax,cs:[bx]
	MOV	CS:[X_OFF],ax
	mov	ax,cs:[bx+2]
	MOV	CS:[X_SEG],ax

	mov_ax	AR1
	mov	cs:[baseXbytes],ax
	add	ax,R1_BYTES+R2_BYTES
	mov	cs:[baseunitbytes],ax

	xor	eax,eax
	mov_ax	AR2
	or	ax,ax
	jz	short init90		;use full memory
	shl	eax,10		;number of LPV data
	inc	eax
	mov	edx,RAMUNITBYTES
	mul	edx
init90:
	mov	cs:[DPMImemorysize],eax

init100:
	mov	ax,cs
	mov	ds,ax

	mov	[realSEG],ax
	mov	[realSTACKSEG],ss

	mov	ax,_memoseg
	mov	es,ax

	xor	di,di
	mov	cx,80h
	xor	ax,ax
	rep	stosw

;must set memory size properly

	call	DPMIinit		;use [DPMImemorysize]
	jc	dpmierror

	call	prot2real

	mov	bx,AR1
	mov	word ptr cs:[bx],0

dpmiout:
	restorestack
	retf

dpmierror:
;	call	prot2real
	mov	bx,AR1
	mov	word ptr cs:[bx],8001h	;-1 of UB
	jmp	dpmiout


	align	4
		db	30 dup(0)	;for safety
mystacktop	db	30*256 dup(0)
mystackend	db	30 dup(0)

code	ends
end	start
