/*
  LISTCNFG - Configure LIST.COM V 7.4a & UP
	     (c) L.Ottersbach,  GoodShit, Inc.
    This program will configure some of the variables that are
    not 'cloneable' in the classic LIST PLUS program LIST.COM
    by Vernon D. Buerg. It eliminates the need to use DOS DEBUG.
    It will save the configuration variables area for future use
    (If Vern doesn't change their offsets) allowing an easy update
    of your configuration in a later version of LIST.  It was written
    as an exercise in the use of the CXL functions library.

  SYNTAX -
    LISTCNFG [/B]
      LISTCNFG creates a backup .CFG file of the cloneable area of
      LIST.COM.  If the /B option is specified, LISTCNFG will use this
      saved file to restore previous values to the current version of
      LIST.COM.  It will always write out a new .CFG file.  Use the
      ALT-C option in LIST to save the other configuration values, then
      run LISTCNFG.

  COMPILER -
    LISTCNFG was compiled using TURBO C++ V 1.0 and the CXL Function
    Library V 5.2.

*/
#include <sys\stat.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>

#include <cxlwin.h>
#include <cxlvid.h>
#include <cxlmou.h>

typedef enum {FALSE, TRUE} Boolean;

/* define offset of configuration variables */
#define CONFIG 0x32

struct cnfg_vars {
  char special;
  char undef1;
  char normal;
  char undef3;
  char bright;
  char undef5;
  char win1_color;
  char win2_color;
  char flag3;
  char flag4;
  int  find_row;
  int  scroll_incr;
  int  scroll_start;
  int  tab_value;
  int  tab_mask;
  int  loudness;
  char key_rate;
  int  overlap;
  char wildcard_esc;
  int  altv_up;
  char eye_catcher[4];
  char com_port[2];
  char sort_offset;
  char undef35[2];
  char modem_init[30];
  char editor_name[8];
  char undef75;
  char modem_hangup[9];
  char temp_varname[4];
};

/* miscellaneous global variables */
static int *savescrn, crow, ccol;

/* function declarations */
int getopt(int argc, char *argv[], char *optionS);
static void initialize(void);
static void cleanup(void);
void get_cnfg_vars(int handle1, struct cnfg_vars *);

main(int argc, char *argv[])
{
  int handle, handle1;
  char editor[9], comport[2], init_str[31], hang_str[10], env_str[5];
  char c_bg, c_fg, c_rev;
  Boolean Use_backup = FALSE;
  struct cnfg_vars list, cnfg;
  int optCh;
  extern char *optarg;  /* pointer to option string in getopt.c */
  extern int optind;    /* option counter in getopt.c */
  char *optionS = "Bb";  /* allowable command line options */

  /* this is set up to allow multiple command line options */
  while ((optCh = getopt(argc, argv, optionS)) != EOF) {
    switch (toupper(optCh)) {
      case 'B': Use_backup = TRUE; break;
    }
  }

  /* open LIST.COM */
  if ((handle = open("LIST.COM", O_RDWR | O_BINARY)) == -1) {
    perror("Error:");
    return 1;
  }

  /* open LIST.CFG if it exists else create it */
  if ((handle1 = open("LIST.CFG",
       O_RDWR | O_CREAT | O_BINARY,
       S_IREAD | S_IWRITE)) == -1) {
    perror("Error:");
    return 1;
  }

  /* get the configuration variables from LIST.COM */
  lseek(handle, CONFIG, SEEK_SET);
  read(handle, &list, sizeof(list));

  /* get the configuration variables from LIST.CFG if needed */
  if (Use_backup) get_cnfg_vars(handle1, &list);

  initialize();

  /* set up the data entry field values */
  c_fg = (list.bright & 0x07) << 4;
  c_bg = (list.bright & 0xf0) >> 4;
  c_rev = c_fg | c_bg;

  strcpy(comport, (list.com_port[1] == '\x03') ? "1" : "2");
  memcpy(init_str, list.modem_init, sizeof(list.modem_init));
  init_str[30] = '\0';
  memcpy(editor, list.editor_name, sizeof(list.editor_name));
  editor[8] = '\0';
  memcpy(hang_str, list.modem_hangup, sizeof(list.modem_hangup));
  hang_str[9] = '\0';
  memcpy(env_str, list.temp_varname, sizeof(list.temp_varname));
  env_str[4]=  '\0';

  wopen(2,9,17,71,5,list.special,list.normal);
  wshadow(LGREY|_BLACK);
  wprints(0,0,list.special,
	  "      LIST Configuration Program - for Version 7.4a and up     ");
  wprints(15,0,list.special,
	  "            [CNTL] Enter = Finished   [ESC] = Abort            ");

  winpbeg(CYAN|_BLACK,YELLOW|_BLACK);

  wprints(3,4,list.normal,"Editor: <");
  wprints(3,21,list.normal,">");
  winpdef(3,13,editor,"********",' ',2,NULL,0);

  wprints(5,4,list.normal,"COM Port: <");
  wprints(5,16,list.normal,">");
  winpdef(5,15,comport,"<12>",' ',2,NULL,0);

  wprints(7,4,list.normal,"Modem Init: <");
  wprints(7,47,list.normal,">");
  winpdef(7,17,init_str,"??????????????????????????????",' ',2,NULL,0);

  wprints(9,4,list.normal,"Modem Disconnect: <");
  wprints(9,32,list.normal,">");
  winpdef(9,23,hang_str,"?????????",' ',2,NULL,0);


  wprints(11,4,list.normal,"Environment Variable: <");
  wprints(11,31,list.normal,">");
  winpdef(11,27,env_str,"****",' ',2,NULL,0);

  wprints(13,4,list.bright,"This is the current ");
  wprints(13,24,c_rev,"FIND STRING");
  wprints(13,35,list.bright," color set.");

  if(winpread()) {
    cleanup();
    return(1);
  }

  /* move data entry fields into the configuration variables */
  list.com_port[1] = (comport[0] == '1') ? '\x03' : '\x02';
  memcpy(list.modem_init, init_str, sizeof(list.modem_init));
  memcpy(list.editor_name, editor, sizeof(list.editor_name));
  memcpy(list.modem_hangup, hang_str, sizeof(list.modem_hangup));
  memcpy(list.temp_varname, env_str, sizeof(list.temp_varname));

  /* write the updated LIST.COM */
  lseek(handle, CONFIG, SEEK_SET);
  write(handle, &list, sizeof(list));
  close(handle);

  /* write the updated LIST.CFG for later retrieval */
  lseek(handle1, 0, SEEK_SET);
  write(handle1, &list, sizeof(list));
  close(handle1);

  cleanup();
  return(0);

}  /* end main */

/*
  Initialize CXL's video, mouse, keyboard, and help systems
*/

static void initialize(void)
{
    /* initialize the CXL video system and save current screen info */
    videoinit();
    readcur(&crow,&ccol);
    if((savescrn=ssave())==NULL) exit(-1);

    /* if mouse exists, turn on full mouse support */
    if(msinit()) mssupport(MS_FULL);

}  /* end initialize */

/*
  This function restores the saved environment.
*/
static void cleanup(void)
{
    srestore(savescrn);
    gotoxy_(crow,ccol);
    showcur();
}  /* end cleanup */

/*
  This function retrieves the backup configuration variables and copies
  them to the original structure field by field because of undocumented
  fields in the middle of the variables.  (*list = cnfg is much simpler)
*/
void get_cnfg_vars(int handle1, struct cnfg_vars *list)
{
  struct cnfg_vars cnfg;

  lseek(handle1, 0, SEEK_SET);
  read(handle1, &cnfg, sizeof(cnfg));
/*
  *list = cnfg;
*/
  list->special = cnfg.special;
  list->normal = cnfg.normal;
  list->bright = cnfg.bright;
  list->win1_color = cnfg.win1_color;
  list->win2_color = cnfg.win2_color;
  list->flag3 = cnfg.flag3;
  list->flag4 = cnfg.flag4;
  list->find_row = cnfg.find_row;
  list->scroll_incr = cnfg.scroll_incr;
  list->scroll_start = cnfg.scroll_start;
  list->tab_value = cnfg.tab_value;
  list->tab_mask = cnfg.tab_mask;
  list->loudness = cnfg.loudness;
  list->key_rate = cnfg.key_rate;
  list->overlap = cnfg.overlap;
  list->wildcard_esc = cnfg.wildcard_esc;
  list->altv_up = cnfg.altv_up;
  memcpy(list->eye_catcher, cnfg.eye_catcher, sizeof(cnfg.eye_catcher));
  memcpy(list->com_port, cnfg.com_port, sizeof(cnfg.com_port));
  list->sort_offset = cnfg.sort_offset;
  memcpy(list->modem_init, cnfg.modem_init, sizeof(cnfg.modem_init));
  memcpy(list->editor_name, cnfg.editor_name, sizeof(cnfg.editor_name));
  memcpy(list->modem_hangup, cnfg.modem_hangup, sizeof(cnfg.modem_hangup));
  memcpy(list->temp_varname, cnfg.temp_varname, sizeof(cnfg.temp_varname));

}  /* end get_cnfg_vars */
