'TABIT replaces spaces with tabs and vice versa
'
' $INCLUDE: 'qb.bi'

DECLARE FUNCTION exists (filename$)

DIM SHARED inregs AS RegTypeX, outregs AS RegTypeX
CONST YES = 1, NO = 0

	  com$ = COMMAND$
	  length = LEN(com$)
	  max = (length / 2) + 1
	  DIM arg$(max)
	  true = -1: false = 0: i = 1: num = 0: inword = true
	  WHILE i <= length
			 ch$ = MID$(com$, i, 1)
			 IF ch$ <> " " THEN
					IF NOT inword THEN inword = true
					arg$(num) = arg$(num) + ch$
			 ELSEIF inword THEN
					num = num + 1
					inword = false
			 END IF
			 i = i + 1
	  WEND
	  y = 1
	  IF NOT arg$(0) = "" THEN GOTO BEGINNING
HELP:
	  PRINT " "
	  PRINT "TABIT replaces spaces with TABs in a file and vice versa. "
	  PRINT "(c)1990 David A. Wesson"
	  PRINT " "
	  PRINT "Syntax: TABIT  [d:]filename  T or S  num"
	  PRINT " where  filename = original file  [drive optional]      "
	  PRINT "         T or S  = T  for make TABs  or  S  for make SPACEs"
	  PRINT "            num  = number of SPACEs for each TAB "
	  PRINT ""
	  PRINT "NOTE: TABIT makes a backup of the original file named filename.OLD ."
	  END
BEGINNING:
	  infile$ = arg$(0)
	  IF exists(infile$) = NO THEN GOTO NOFIND
	  OPEN infile$ FOR INPUT AS #1
	  outfile$ = "temp"
	  OPEN outfile$ FOR OUTPUT AS #2
	  GOSUB filename
	  oldfile$ = file$ + ".OLD"
	  switch$ = arg$(1)
	  IF switch$ = "" THEN GOTO MISSWITCH
	  num = VAL(arg$(2))
	  IF num = 0 THEN GOTO MISSNUM
	  IF switch$ = "T" OR switch$ = "t" THEN
			 GOTO TABIN
	  ELSEIF switch$ = "S" OR switch$ = "s" THEN GOTO TABOUT
	  ELSE GOTO MISSWITCH
	  END IF
TABIN:
	  COLOR 15: PRINT "TABIT "; : COLOR 7: PRINT "Fast TAB inserter"
INNUM:
	  PRINT "Replacing"; num; "spaces with TABs in "; infile$; ", creating "; oldfile$
	  PRINT "Hit [Ctrl]+[Break] to terminate."
	  PRINT "Starting time: "; TIME$
	  PRINT "   Processing: ";
	  z = 0
INCYCLE:
	  IF EOF(1) THEN GOTO FINISH
	  LINE INPUT #1, l$
	  z = z + 1
	  strt = 1
	  LOCATE , 15: PRINT z;
INSEARCH:
	  lfpos = INSTR(strt, l$, STRING$(num, 32))
	  IF lfpos < 1 THEN GOTO INDUMP
	  GOTO INSPLIT
INNEXTLOOK:
	 strt = lfpos + 1: GOTO INSEARCH
INSPLIT:
	 lpart$ = LEFT$(l$, lfpos - 1)
	 rpos = lfpos + num
	 rpart$ = RIGHT$(l$, (LEN(l$) - rpos) + 1)
	 s$ = lpart$ + CHR$(9) + rpart$
	 l$ = s$
	 GOTO INNEXTLOOK
INNEWOUT:
	  PRINT #2, s$
	  GOTO INCYCLE
INDUMP:
	  PRINT #2, l$
	  GOTO INCYCLE
'*****************************************************************************
TABOUT:
	  COLOR 15: PRINT "TABIT "; : COLOR 7: PRINT "Fast TAB replacer"
OUTNUM:
	  PRINT "Replacing TABs with"; num; "spaces in "; infile$; ", creating "; oldfile$
	  PRINT "Hit [Ctrl]+[Break] to terminate."
	  PRINT "Starting time: "; TIME$
	  PRINT "   Processing: ";
	  z = 0
OUTCYCLE:
	  IF EOF(1) THEN GOTO FINISH
	  LINE INPUT #1, l$
	  z = z + 1
	  LOCATE , 15: PRINT z;
	  strt = 1
OUTSEARCH:
	  lfpos = INSTR(strt, l$, CHR$(9))
	  IF lfpos < 1 THEN GOTO OUTDUMP
	  GOTO OUTSPLIT
OUTNEXTLOOK:
	  strt = lfpos + num: GOTO OUTSEARCH
OUTSPLIT:
	  lpart$ = LEFT$(l$, lfpos - 1)
	  rpos = lfpos
	  rpart$ = RIGHT$(l$, LEN(l$) - rpos)
	  s$ = lpart$ + STRING$(num, 32) + rpart$
	  l$ = s$
	  GOTO OUTNEXTLOOK
OUTNEWOUT:
	  PRINT #2, s$
	  GOTO OUTCYCLE
OUTDUMP:
	  PRINT #2, l$
	  GOTO OUTCYCLE
NOFIND:
	  PRINT "ERROR: No file by that name found."
	  GOTO HELP
MISSWITCH:
	  PRINT "ERROR: Missing T or S switch"
	  GOTO HELP
MISSNUM:
	  PRINT "ERROR: Missing SPACE NUMBER specifier."
	  GOTO HELP
FINISH:
	  CLOSE
	  IF exists(oldfile$) = YES THEN KILL oldfile$
NOOLD:
	  NAME infile$ AS oldfile$
	  NAME outfile$ AS infile$
	  PRINT ""
	  PRINT "  Finish time: "; TIME$
	  END
filename:                                         'splits infile$ into
		  period = INSTR(infile$, ".")              'file$ and ext$
		  IF period = 0 THEN
					file$ = UCASE$(infile$)
					ext$ = ""
					ELSE
						  file$ = UCASE$(LEFT$(infile$, period - 1))

						  ext$ = UCASE$(MID$(infile$, period + 1))
		  END IF
		  RETURN

FUNCTION exists (search$)
	 savefile$ = search$
	 inregs.ax = &H4E00
	 inregs.cx = 1     '3 for hidden
	 search$ = search$ + CHR$(0)
	 inregs.dx = SADD(search$)
	 inregs.ds = -1
	 CALL INTERRUPTX(&H21, inregs, outregs)
	 IF (outregs.flags AND 1) = 1 THEN
			exists = NO
	 ELSE
			exists = YES
	 END IF
	 search$ = savefile$
END FUNCTION

