
{*******************************************************}
{                                                       }
{       Graphics Vision Demo program                    }
{                                                       }
{       Copyright (c) 1993 Stefan Milius                }
{                                                       }
{*******************************************************}

Program DemoRez;

{ Diese Program generiert die Resourcendatei fr DEMO.PAS.

  This program creates the resource file for DEMO.PAS.
  If you wish to create the English version you will have to
  set the conditional define "english". Just remove the comment
  parentheses in the next line and build this program.
}

(* {$DEFINE english} *)

Uses Dos, Objects, Drivers, ExtGraph, GVDriver, Views, GVViews, GVDialog,
     GVMenus, GVApp, GVStdDlg, GVColor, Graph, Gr, BGI, MetaGr, DemoType,
     Memory, MyMouse, MyFonts, VGAMem, HistList;

Var

{ Dialog variables }

  Dialog: PDialog;
  P: PGView;
  R: TRect;

(*************************** Resource procedures ****************************)

procedure CreateStatusHints;
var HintList: PStrListMaker;
Begin
  HintList:=New (PStrListMaker,Init ($4000,50));
  With HintList^ do Begin
    {$IFDEF english}
    { Menus }
    Put (hcFile, 'Basic file operations (open change directory etc.)');
    Put (hcOpen, 'Opens a file in a text window');
    Put (hcChangeDir, 'Changes the current directory');
    Put (hcInfo, 'Shows version number and copyright information');
    Put (hcColor, 'Changes the application''s colors');
    Put (hcExit, 'Exit this programm');
    Put (hcWindow, 'Commands of the window manager');
    Put (hcGWindow, 'Opens a graphic window');
    Put (hcDialog, 'Opens the demo dialog window');
    Put (hcResize, 'Changes size and/or position of the current window');
    Put (hcZoom, 'Zooms the current window');
    Put (hcTile, 'Arranges all windows by tiling on the desktop');
    Put (hcCascade, 'Arranges all windows by cascading on the desktop');
    Put (hcNext, 'Selects next window');
    Put (hcPrev, 'Selects previous window');
    Put (hcClose, 'Closes the current window');
    Put (hcMusic, 'Commands for sound effects');
    Put (hcEnableMusic, 'Enables or Disables the sound effects');
    Put (hcNormalTune, 'Chooses the standard tune to be current sound effect');
    Put (hcIndyTune, 'Where''s my Indy-Wear(TM)-Hat ???????!');
    Put (hcPlay, 'New in GV - Bitmaps as menu options; Plays the sound effect');

    { Dialogs }
    Put (hcOk, 'Accepts the current settings');
    Put (hcCancel, 'Closes the dialog box without making changes');
    Put (hcYes, 'Answers given question with "yes"');
    Put (hcNo, 'Answers given question with "no"');
    Put (hcFOpenInput, 'Please enter directory and file name');
    Put (hcFOpenList, 'Small characters for files / big characters for directories');
    Put (hcFOpenOpBut,'Opens the chosen file');
    Put (hcFChDirInput, 'Please enter drive and/or directory');
    Put (hcFChDirList, 'Use the cursor keys to move');
    Put (hcFChDirChDirBut, 'Changes into the chosen directory');
    Put (hcFChDirRevBut, 'Returns to original directory');
    Put (hcColorGroupList, 'Please choose a group');
    Put (hcColorItemList, 'Please choose the palette entry you want to change');
    Put (hcSelector, 'Please choose a color');
    Put (hcWDlgR1, 'Each item of a radiobutton can have another hint');
    Put (hcWDlgR2, 'Choose 2');
    Put (hcWDlgR3, 'No. 3 for president');
    Put (hcWDlgR4, 'All good things are 4');
    Put (hcWDlgR5, 'Winner of the test');
    Put (hcWDlgR6, 'Last one');
    Put (hcWDlgGButton, 'Only in GV: a graphical button');
    Put (hcWDlgInput, 'An inputline that is connected with a TLabel object');
    Put (hcWDlgTextButton, 'A standard text button (sends a command if you push it)');
    Put (hcWDlgC1, 'Only for POWER USERS');
    Put (hcWDlgC2, 'Cat, dog and other periphery');
    Put (hcWDlgC3, 'Small, quadrangular and always with defect sectors');
    Put (hcWDlgC4, 'Formatted especially pleasant -> scraaaaaaaatch');
    Put (hcWDlgC5, 'Only way out when developing graphical environments');
    Put (hcWDlgC6, 'Please only mark if being in serious danger');
    Put (hcWDlgRegler, 'Only in GV: a controller to change real number');
    Put (hcWDlgList, 'A listbox (connected with scrollbar and icon)');
    Put (hcWDlgNumInput, 'An inputline for integer numbers');
    Put (hcWDlgMC1, 'New in GV: Multicheckboxes');
    Put (hcWDlgMC2, 'Multivitamine nectar');
    Put (hcWDlgMC3, 'Coming soon: Multi - Tasking');
    Put (hcWDlgMC4, 'Multi silly; Multi - Plication');
    {$ELSE}
    { Menus }
    Put (hcFile, 'Dateioperationen (ffnen Verzeichnis wechseln etc.)');
    Put (hcOpen, 'ffnen einer Datei in einem Textfenster');
    Put (hcChangeDir, 'ndern des aktuellen Verzeichnises');
    Put (hcInfo, 'Zeigt Versionsnummer und Copyright Information an');
    Put (hcColor, 'Verndern der Farben der Oberflche');
    Put (hcExit, 'Beendet dieses Programm');
    Put (hcWindow, 'Kommandos der Fensterverwaltung');
    Put (hcGWindow, 'ffnen eines grafischen Fensters');
    Put (hcDialog, 'ffnen eines Demo-Dialog-Fensters');
    Put (hcResize, 'ndern von Gre bzw. Position des aktuellen Fensters');
    Put (hcZoom, 'Vergrern bzw. Verkleinern dews aktuellen Fensters');
    Put (hcTile, 'Kachelfrmige Anordnung der Fenter');
    Put (hcCascade, 'Kaskadenfrmige Anordnung der Fenster');
    Put (hcNext, 'Aktivieren des nchsten Fensters');
    Put (hcPrev, 'Aktivieren des vorherigen Fensters');
    Put (hcClose, 'Schlieen des aktiven Fensters');
    Put (hcMusic, 'Kommandos fr Soundeffekte');
    Put (hcEnableMusic, 'Schaltet die Soundeffekte an bzw. aus');
    Put (hcNormalTune, 'Whlt den Standard-Soundeffekt aus');
    Put (hcIndyTune, 'Wo ist mein Indy-Wear(TM)-Hut ?????!');
    Put (hcPlay, 'Neu in GV - Bitmaps als Menoptionen; Spielt die Melodie');

    { Dialogs }
    Put (hcOk, 'Akzeptiert die aktuelle Einstellungen');
    Put (hcCancel, 'Schliet die Dialogbox ohne nderungen');
    Put (hcYes, 'Beantwortet die gestellte Frage mit "ja"');
    Put (hcNo, 'Beantwortet die gestellte Frage mit "nein"');
    Put (hcFOpenInput, 'Geben Sie Verzeichnis- und Dateiname an');
    Put (hcFOpenList, 'kleine Buchstaben-Dateien / groe-Verzeichnisse');
    Put (hcFOpenOpBut,'ffnet die ausgewhlte Datei');
    Put (hcFChDirInput, 'Geben Sie Laufwerk und/oder Verzeichnis an');
    Put (hcFChDirList, 'Benutzen Sie die Cursortasten zum bewegen');
    Put (hcFChDirChDirBut, 'Wechselt in das gewhlte Verzeichnis');
    Put (hcFChDirRevBut, 'Kehrt zum ursprnglichen Verzeichnis zurck');
    Put (hcColorGroupList, 'Whlen Sie eine Gruppe aus');
    Put (hcColorItemList, 'Whlen Sie den zu ndernden Farbeintrag aus');
    Put (hcSelector, 'Whlen Sie eine Farbe');
    Put (hcWDlgR1, 'Jedes Item eines RadioButtons kann eine anderen Hinweis haben');
    Put (hcWDlgR2, 'Whle 2');
    Put (hcWDlgR3, 'Nr. 3 for president');
    Put (hcWDlgR4, 'Alle guten Dinge sind 4');
    Put (hcWDlgR5, 'Testsieger');
    Put (hcWDlgR6, 'Schlulicht');
    Put (hcWDlgGButton, 'Nur in GV: Ein grafischer Schalter');
    Put (hcWDlgInput, 'Eine Eingabezeile, die mit einem Label verbunden ist');
    Put (hcWDlgTextButton, 'Ein Textschalter (sendet bei Bettigung ein Kommando ab)');
    Put (hcWDlgC1, 'Only for POWER USERS');
    Put (hcWDlgC2, 'Katze, Hund und andere Peripherie');
    Put (hcWDlgC3, 'Klein, viereckig und immer mit defekten Sektoren');
    Put (hcWDlgC4, 'Formatiert besonders erfreulich -> Scraaaaaaaatch');
    Put (hcWDlgC5, 'Einziger Ausweg beim entwickeln von grafischen Oberflchen');
    Put (hcWDlgC6, 'Bitte nur im uersten Notfall ankreuzen');
    Put (hcWDlgRegler, 'Nur in GV: Ein Regler, mit dem eine reelle Zahl verndert wird');
    Put (hcWDlgList, 'Ein Listenfeld (verbunden mit Rollbalken und Icon)');
    Put (hcWDlgNumInput, 'Ein Eingabezeile fr ganze Zahlen');
    Put (hcWDlgMC1, 'Neu in GV: Mehrfachstatus-Markierungsfelder');
    Put (hcWDlgMC2, 'Multivitamin Nektar');
    Put (hcWDlgMC3, 'Multi - Tasking kommt bald');
    Put (hcWDlgMC4, 'Multi bldsinnig; Multi - Plizieren');
    {$ENDIF}
  End;
  RezFile.Put (HintList, 'StatusHints');
  Dispose (HintList, Done);
End;

procedure CreateMenuBar;
var B: Pointer;

 function NewCheckItem(Name, Param: TMenuStr; KeyCode, Command, AHelpCtx: Word;
                       ADisabled: Byte; Next: PMenuItem): PMenuItem;
 var Item: PMenuItem;
 Begin
   Item := NewItem(Name, Param, KeyCode, Command, AHelpCtx, Next);
   Item^.Disabled := ADisabled;
   NewCheckItem := Item;
 End;

 function GetBitmap: Pointer;
 var i: Integer;
     B: Pointer;
 Begin
   SetFillStyle(SolidFill, White); Bar(0, 0, 70, 30);
   SetColor(Black);
   For i := 1 to 5 do HoriLine(0, i*5, 80);
   SetFillStyle(SolidFill, 0); FillCircle(20, 20, 3);
   VertLine(23, 20, 2);
   Graph.SetColor(Black);
   Arc(23, 8, 330, 90, 5);

   FillCircle(50, 10, 3);
   VertLine(47, 10, 28);
   Graph.SetColor(Black);
   Arc(47, 22, 270, 30, 5);
   GetMem(B, ImageSize(0, 0, 70, 30));
   GetImage(0, 0, 70, 30, B^);
   GetBitmap := B;
 End;

Begin
  B := GetBitmap;

  R.Assign (0,0,SizeX-71,21);
  {$IFDEF english}
  P:=New (PMenuBar, Init (R, NewMenu (
    NewSubMenu ('~F~ile', hcFile, NewMenu (
      NewItem ('~I~nfo...', 'F1', kbF1, cmInfo, hcInfo,
      NewLine (
      NewItem ('~O~pen...', 'F3', kbF3, cmOpen, hcOpen,
      NewItem ('Change ~d~irectory...', 'F4', kbF4, cmChDir, hcChangeDir,
      NewLine (
      NewItem ('Change ~c~olors...', '', kbNoKey, cmColor, hcColor,
      NewLine (
      NewItem ('~E~xit', 'Alt+X', kbAltX, cmQuit, hcExit, nil))))))))),
    NewSubMenu ('~W~indow', hcWindow, NewMenu (
      NewItem ('~G~raphical window', 'F9', kbF9, cmGWindow, hcGWindow,
      NewItem ('~D~emo dialog', 'Alt+F9', kbAltF9, cmDialog, hcDialog,
      NewLine (
      StdWindowMenuItems(nil))))),
    NewSubMenu ('~M~usic', hcMusic, NewMenu (
      NewCheckItem ('~M~usic on/off', 'Shift+F8', kbShiftF8, cmEnableMusic,
                    hcEnableMusic, dfMenuCheck + dfCheckState,
      NewLine (
      NewCheckItem ('~N~ormal tune', '', kbNoKey, cmNormalTune, hcNormalTune,
                    dfMenuCheck + dfRadio,
      NewCheckItem ('~I~ndy''s tune', '', kbNoKey, cmIndyTune, hcIndyTune,
                    dfMenuCheck + dfRadio,
      NewLine (
      NewBitmap (B, kbF8, cmPlay, hcPlay, nil))))))),
    nil))))));
  {$ELSE}
  P:=New (PMenuBar, Init (R, NewMenu (
    NewSubMenu ('~D~atei', hcFile, NewMenu (
      NewItem ('~I~nfo...', 'F1', kbF1, cmInfo, hcInfo,
      NewLine (
      NewItem ('~f~fnen...', 'F3', kbF3, cmOpen, hcOpen,
      NewItem ('~V~erzeichnis wechseln...', 'F4', kbF4, cmChDir, hcChangeDir,
      NewLine (
      NewItem ('Fa~r~ben verndern...', '', kbNoKey, cmColor, hcColor,
      NewLine (
      NewItem ('~E~nde', 'Alt+X', kbAltX, cmQuit, hcExit, nil))))))))),
    NewSubMenu ('~F~enster', hcWindow, NewMenu (
      NewItem ('~G~rafisches Fenster', 'F9', kbF9, cmGWindow, hcGWindow,
      NewItem ('~D~emo Dialog', 'Alt+F9', kbAltF9, cmDialog, hcDialog,
      NewLine (
      StdWindowMenuItems(nil))))),
    NewSubMenu ('~M~usik', hcMusic, NewMenu (
      NewCheckItem ('~M~usik an/aus', 'Umschalt+F8', kbShiftF8, cmEnableMusic,
                    hcEnableMusic, dfMenuCheck + dfCheckState,
      NewLine (
      NewCheckItem ('~S~tandardmelodie', '', kbNoKey, cmNormalTune, hcNormalTune,
                    dfMenuCheck + dfRadio,
      NewCheckItem ('~I~ndy''s Melodie', '', kbNoKey, cmIndyTune, hcIndyTune,
                    dfMenuCheck + dfRadio + dfCheckState,
      NewLine (
      NewBitmap (B, kbF8, cmPlay, hcPlay, nil))))))),
    nil))))));
  {$ENDIF}
  FreeMem(B, ImageSize(0, 0, 70, 30));
  RezFile.Put (P, 'MenuBar');
  Dispose (P, Done);
End;

procedure CreateDesktop;
Begin
  R.Assign (0, 21, SizeX, SizeY-21);
  P:=New (PDesktop, Init (R));
  RezFile.Put (P, 'Desktop');
  Dispose (P, Done);
End;

procedure CreateStatusLine;
Begin
  R.Assign (0,SizeY-21, SizeX-71, SizeY);
  {$IFDEF english}
  P:=New (PDemoStatusLine, Init (R,
    NewStatusDef (0, 0,
      NewStatusKey ('~F1~ Info', kbF1, cmInfo,
      NewStatusKey ('~F3~ Open', kbF3, cmOpen,
      NewStatusKey ('~F4~ Change directory', kbF4, cmChDir,
      NewStatusKey ('~F10~ Menu', kbF10, cmMenu,
      NewStatusKey ('~Alt+X~ Exit', kbAltX, cmQuit, nil))))),
    NewStatusDef (1, 1,
      NewStatusKey (#2'~'#27#26#25#24'~ Move',kbNoKey,cmError,
      NewStatusKey (#2'~Shift-'#27#26#25#24'~ Size',kbNoKey,cmError, 
      NewStatusKey (#2'~'#17'~ Accept',kbNoKey,cmError,
      NewStatusKey (#2'~Esc~ Cancel',kbNoKey,cmError,nil)))),
    NewStatusDef (2, 999,
      NewStatusKey ('~Alt+F3~ Close', kbAltF3, cmClose, nil),
    NewStatusDef (1000, 9999,
      NewStatusKey ('~F1~ Info', kbF1, cmInfo,
      NewStatusKey ('~F3~ Open', kbF3, cmOpen,
      NewStatusKey ('~F4~ Change directory', kbF4, cmChDir,
      NewStatusKey ('~F10~ Menu', kbF10, cmMenu,
      NewStatusKey ('~Alt+F10~ Local menu', kbAltF10, cmLocalMenu, nil))))),
    NewStatusDef (10000, $FFFF,
      NewStatusKey ('~Alt+X~ Exit', kbAltX, cmQuit, nil),nil)))))));
  {$ELSE}
  P:=New (PDemoStatusLine, Init (R,
    NewStatusDef (0, 0,
      NewStatusKey ('~F1~ Info', kbF1, cmInfo,
      NewStatusKey ('~F3~ ffnen', kbF3, cmOpen,
      NewStatusKey ('~F4~ Verzeichnis wechseln', kbF4, cmChDir,
      NewStatusKey ('~F10~ Men', kbF10, cmMenu,
      NewStatusKey ('~Alt+X~ Beenden', kbAltX, cmQuit, nil))))),
    NewStatusDef (1, 1,
      NewStatusKey (#2'~'#27#26#25#24+'~ Verschieben',kbNoKey,cmError,
      NewStatusKey (#2'~Umschalt-'#27#26#25#24'~ Gre',kbNoKey,cmError, 
      NewStatusKey (#2'~'#17'~ Beenden',kbNoKey,cmError,
      NewStatusKey (#2'~Esc~ Abbruch',kbNoKey,cmError,nil)))),
    NewStatusDef (2, 999,
      NewStatusKey ('~Alt+F3~ Schlieen', kbAltF3, cmClose, nil),
    NewStatusDef (1000, 9999,
      NewStatusKey ('~F1~ Info', kbF1, cmInfo,
      NewStatusKey ('~F3~ ffnen', kbF3, cmOpen,
      NewStatusKey ('~F4~ Verzeichnis wechseln', kbF4, cmChDir,
      NewStatusKey ('~F10~ Men', kbF10, cmMenu,
      NewStatusKey ('~Alt+F10~ Lokales Men', kbAltF10, cmLocalMenu, nil))))),
    NewStatusDef (10000, $FFFF,
      NewStatusKey ('~Alt+X~ Beenden', kbAltX, cmQuit, nil),nil)))))));
  {$ENDIF}
  RezFile.Put (P, 'StatusLine');
  Dispose (P, Done);
End;

procedure CreateLocalMenu;
Begin
  R.Assign(0, 0, 0, 0);
  {$IFDEF english}
  P := New(PMenuPopup, Init(R, NewMenu(
    NewItem ('~I~nfo...', 'F1', kbF1, cmInfo, hcInfo,
    NewLine (
    NewItem ('~O~pen...', 'F3', kbF3, cmOpen, hcOpen,
    NewItem ('Change ~d~irectory...', 'F4', kbF4, cmChDir, hcChangeDir,
    NewLine (
    NewItem ('~S~ize/Move', 'Ctrl+F5', kbCtrlF5, cmResize, hcResize,
    NewItem ('~Z~oom', 'F5', kbF5, cmZoom, hcZoom,
    NewItem ('~C~lose', 'Alt+F3', kbAltF3, cmClose, hcClose, nil)))))))))));
  {$ELSE}
  P := New(PMenuPopup, Init(R, NewMenu(
    NewItem ('~I~nfo...', 'F1', kbF1, cmInfo, hcInfo,
    NewLine (
    NewItem ('~f~fnen...', 'F3', kbF3, cmOpen, hcOpen,
    NewItem ('~V~erzeichnis wechseln...', 'F4', kbF4, cmChDir, hcChangeDir,
    NewLine (
    NewItem ('~G~re/Position', 'Strg+F5', kbCtrlF5, cmResize, hcResize,
    NewItem ('~V~ergrern', 'F5', kbF5, cmZoom, hcZoom,
    NewItem ('~S~chlieen', 'Alt+F3', kbAltF3, cmClose, hcClose, nil)))))))))));
  {$ENDIF}
  RezFile.Put (P, 'LocalMenu');
  Dispose (P, Done);
End;



procedure CreateFOpenDlg;
const Help: Array [1..4] Of Word = (hcFOpenInput,hcFOpenList,hcFOpenOpBut,
                                    hcCancel);
{$IFDEF english}
const Title = 'Open a file';
{$ELSE}
const Title = 'ffnen einer Datei';
{$ENDIF}
Begin
  Dialog := New (PFileDialog, Init ('*.PAS',Title,'~N~ame',
    fdOpenButton+fdHelpButton+fdNoLoadDir, 30));
  SetHelpCtx (Dialog, Help);
  RezFile.Put (Dialog,'FOpenDlg');
  Dispose (Dialog,Done);
End;

procedure CreateFChDirDlg;
const Help: Array [1..5] Of Word = (hcOk,hcFChDirChDirBut,hcFChDirRevBut,
                                    hcFChDirInput,hcFChDirList);
Begin
  Dialog := New (PChDirDialog, Init (cdNoLoadDir+cdHelpButton, 31));
  SetHelpCtx (Dialog, Help);
  RezFile.Put (Dialog,'FChDirDlg');
  Dispose (Dialog,Done);
End;

procedure CreateFColorDlg;
const Help: Array [1..5] Of Word = (hcColorGroupList, hcColorItemList,
                                    hcSelector, hcOk, hcCancel);
Begin
  {$IFDEF english}
  Dialog := New (PColorDialog, Init ('',
    ColorGroup ('desktop',
      ColorItem ('background', 1, nil),
    ColorGroup ('menu',
      ColorItem ('text normal ', 2,
      ColorItem ('text disabled', 3,
      ColorItem ('text shortcut', 4,
      ColorItem ('selected normal', 5,
      ColorItem ('selected disabled', 6,
      ColorItem ('selected shortcut', 7,
      ColorItem ('normal background', 8,
      ColorItem ('selected background', 9, nil)))))))),
    ColorGroup ('file viewer',
      ColorItem ('text', 50,
      ColorItem ('background', 52, nil)), nil)))));
  {$ELSE}
  Dialog := New (PColorDialog, Init ('',
    ColorGroup ('Desktop',
      ColorItem ('Hintergrund', 1, nil),
    ColorGroup ('Men',
      ColorItem ('Text normal ', 2,
      ColorItem ('Text deaktiviert', 3,
      ColorItem ('Text shortcut', 4,
      ColorItem ('Selektiert normal', 5,
      ColorItem ('Selektiert deaktiviert', 6,
      ColorItem ('Selektiert shortcut', 7,
      ColorItem ('Normaler Hintergrund', 8,
      ColorItem ('Selekt. Hintergrund', 9, nil)))))))),
    ColorGroup ('Fenstertext',
      ColorItem ('Text', 50,
      ColorItem ('Hintergrund', 52, nil)), nil)))));
  {$ENDIF}
  SetHelpCtx (Dialog, Help);
  RezFile.Put (Dialog, 'ColorDlg');
  Dispose (Dialog, Done);
End;

procedure CreateFInfo;
const Help: Word = hcOK;
      Texts: Array [1..2] of String[12] = ('Demo program','Demoprogramm');
Begin
   R.Assign (0,0,300,200);
   Dialog:=New (PDialog, Init (R, 'Info'));
   With Dialog^ do Begin
     Options:=Options or ofCentered;
     R.Assign (100, 45, 290, 61);
     Insert (New (PStaticText, Init (R, 'Graphics Vision')));
     R.Move (0,16);
     Insert (New (PStaticText, Init (R, 'Version '+Version)));
     R.Move (0,20);
     Insert (New (PStaticText, Init (R, Texts[Language])));
     R.Move (0,20);
     Insert (New (PStaticText, Init (R, 'Copyright (c) 1993 by')));
     R.Move (0,16);
     Insert (New (PStaticText, Init (R, 'Stefan Milius')));
     R.Assign (100, 155, 200, 180);
     Insert (New (PButton, Init (R, 'O~k~', cmOk, bfDefault)));
   End;
   SetHelpCtx (Dialog, Help);
   RezFile.Put (Dialog, 'Info');
   Dispose (Dialog, Done);
End;

procedure Icons; Assembler;
Asm
	DW	12
	DW	0000000000000000B
	DW	0100000000010000B
	DW	0010000000100000B
	DW	0001000001000000B
	DW	0000100010000000B
	DW	0000010100000000B
	DW	0000000000000000B
	DW	0000010100000000B
	DW	0000100010000000B
	DW	0001000001000000B
	DW	0010000000100000B
	DW	0100000000010000B
        DW	11
        DW      00000000000000000B
        DW      00000000001000000B
        DW      00000000001000000B
        DW      00000000011000000B
        DW      00000000010000000B
        DW      00000000110000000B
        DW      00011000100000000B
        DW      00001101100000000B
        DW      00000101000000000B
        DW      00000111000000000B
        DW      00000010000000000B
	DW	11
        DW	0000000000000000B
        DW	0000000000000000B
        DW	0000001110000000B
        DW	0000011110000000B
        DW	0000110110000000B
        DW	0001000110000000B
        DW	0000000110000000B
        DW	0000000110000000B
        DW	0000000110000000B
        DW	0000000110000000B
        DW	0000000110000000B
	DW	10
        DW	0000000000000000B
        DW      0000000000000000B
        DW	0000011100000000B
        DW	0000110110000000B
        DW	0001100011000000B
        DW	0000000011000000B
        DW	0000000110000000B
        DW	0000011100000000B
        DW	0001110000000000B
        DW	0001111111000000B
End;

procedure CreateWDialogDlg;
const Help: Array [1..10] Of Word = (hcWDlgRadio, hcWDlgGButton, hcWDlgInput,
                                    hcWDlgTextButton, hcWDlgCheck, hcWDlgRegler,
                                    hcWDlgList, hcWDlgNumInput, hcWDlgMultiCheck,
                                    hcOk);
      rad  = 12;
      StartX = 15;
      StartY = 13;
{$IFDEF english}
      Str: String = 'the inputline is for comfortable editing of text';
{$ELSE}
      Str: String = 'Die Eingabezeile dient der komfortablen Eingabe von Text';
{$ENDIF}
      Data: LongInt = $E4;

var Sign: Pointer;
    S: Word;
    P: PGView;
Begin
  R.Assign (0,0,500,400);
  {$IFDEF english}
  Dialog:=New (PDialog, Init (R, 'Demo dialog'));
  {$ELSE}
  Dialog:=New (PDialog, Init (R, 'Demo-Dialog'));
  {$ENDIF}
  With Dialog^ do Begin
    Options:=Options or ofCentered;

    { StaticText }
    R.Assign (0, 45, 360, 65);
    SetTextParams (ftSansSerif, 0, 0, true);
    {$IFDEF english}
    R.A.X:=(Size.X-TextWidth ('Middle')) div 2-5;
    Insert (New (PStaticText, Init (R, 'Middle')));
    {$ELSE}
    R.A.X:=(Size.X-TextWidth ('Mitte')) div 2-5;
    Insert (New (PStaticText, Init (R, 'Mitte')));
    {$ENDIF}

    { RadioButtons }
    R.Assign (10, 35, 100, 135);
    Insert (New (PRadioButtons, Init (R,
      NewSItem ('~O~ption 1',
      NewSItem ('O~p~tion 2',
      NewSItem ('Op~t~ion 3',
      NewSItem ('Opt~i~on 4',
      NewSItem ('Opti~o~n 5',
      NewSItem ('Optio~n~ 6', nil)))))))));

    { Graphic Button }
    (* Drawsaucer *)
    SetFillStyle (SolidFill, Cyan);
    Bar (0,0,SignX,SignY);
    Graph.SetColor(White);
    Ellipse(StartX, StartY, 0, 360, rad, (rad div 3)+2);
    Ellipse(StartX, StartY-4, 190, 357, rad, rad div 3);
    SetColor (Magenta);
    Line(StartX+8, StartY-4, StartX+10, StartY-10);
    Circle(StartX+10, StartY-10, 2);
    SetColor (Blue);
    Line(StartX-8, StartY-4, StartX-10, StartY-10);
    Circle(StartX-10, StartY-10, 2);
    Graph.SetFillStyle(SolidFill, LightRed);
    FloodFill(StartX+1, StartY+4, White);
    (* ReadSaucerImage *)
    S := ImageSize (0, 0, SignX, SignY);
    Sign := MemAlloc (S);
    GetImage (0, 0, SignX, SignY, Sign^);
    (* MakeButton *)
    R.Assign (120, 35, 180, 75);
    Insert (New (PGButton, Init (R, Sign, cmGButton, bfNormal + bfBroadCast)));

    { InputLine }
    R.Assign (120,105,343,125);
    P:=New (PInputLine, Init (R, 80));
    Insert (P);
    P^.SetData (Str);
    R.Assign (120,85,220,105);
    {$IFDEF english}
    Insert (New (PLabel, Init (R, '~I~nputline',P)));
    {$ELSE}
    Insert (New (PLabel, Init (R, '~E~ingabezeile',P)));
    {$ENDIF}
    R.Assign(342, 105, 360, 125);
    Insert(New (PHistory, Init (R, PInputLine(P), 40)));

    { Text Button }
    R.Assign (300,35,360,75);
    Insert (New (PButton, Init (R, '~T~ext', cmButton, bfNormal + bfBroadCast)));

    { CheckBoxes }
    R.Assign (380, 35, 490, 135);
    {$IFDEF english}
    Insert (New (PCheckBoxes, Init (R,
      NewSItem ('Mouse~p~ad',
      NewSItem ('~M~ouse',
      NewSItem ('~D~iskette',
      NewSItem ('~H~ard disk',
      NewSItem ('~R~eset',
      NewSItem ('~W~hat''s left',nil)))))))));
    {$ELSE}
    Insert (New (PCheckBoxes, Init (R,
      NewSItem ('Mouse~p~ad',
      NewSItem ('~M~ouse',
      NewSItem ('~D~iskette',
      NewSItem ('~F~estplatte',
      NewSItem ('~R~eset',
      NewSItem ('~S~onstiges',nil)))))))));
    {$ENDIF}

    { Regler }
    R.Assign (50, 150, 70, 300);
    {$IFDEF english}
    Insert (New (PRegler, Init (R, -500, 500, 'A controller','-500','0','500')));
    {$ELSE}
    Insert (New (PRegler, Init (R, -500, 500, 'Ein Regler','-500','0','500')));
    {$ENDIF}

    { ListBox }
    R.Assign (332, 150, 350, 250);
    P:=New (PScrollBar, Init (R));
    Insert (P);
    R.Assign (150, 150, 333, 250);
    Insert (New (PMyListBox, Init (R, PScrollBar (P))));

    { Icon }
    R.Assign (232, 260, 267, 286);
    Insert (New (PIcon, Init (R, Sign, First)));
    R.Assign (275, 262, 490, 282);
    {$IFDEF english}
    Insert (New (PStaticText, Init (R, 'This is an icon')));
    {$ElSE}
    Insert (New (PStaticText, Init (R, 'Das ist ein Icon')));
    {$ENDIF}

    { StaticSign }
    R.Assign (232, 300, 267, 326);
    Insert (New (PStaticSign, Init (R, Sign)));
    R.Assign (275, 302, 490, 322);
    {$IFDEF english}
    Insert (New (PStaticText, Init (R, 'This is a TStaticSign object')));
    {$ElSE}
    Insert (New (PStaticText, Init (R, 'Das ist ein StaticSign')));
    {$ENDIF}

    { PNumInput }
    R.Assign (449, 200, 462, 220);
    P:=New (PArrowField, Init (R));
    Insert (P);
    R.Assign (420, 200, 450, 220);
    Insert (New (PNumInput, Init (R, -100, 100, PArrowField (P))));
    {$IFDEF english}
    R.Assign (405, 180, 485, 200);
    Insert (New (PStaticText, Init (R, 'Inputline')));
    R.Assign (410, 220, 480, 240);
    Insert (New (PStaticText, Init (R, 'for numbers')));
    {$ELSE}
    R.Assign (405, 180, 485, 200);
    Insert (New (PStaticText, Init (R, 'Eingabezeile')));
    R.Assign (410, 220, 480, 240);
    Insert (New (PStaticText, Init (R, 'fr Zahlen')));
    {$ENDIF}

    { MultiCheckBoxes }
    R.Assign (150, 260, 220, 325);
    P := New (PMultiCheckBoxes, Init (R,
      NewSItem ('Multi ~1~',
      NewSItem ('Multi ~2~',
      NewSItem ('Multi ~3~',
      NewSItem ('Multi ~4~', nil)))), 4, cfTwoBits, @Icons));
    P^.SetData (Data);
    Insert (P);

    R.Assign (200, 350, 300, 380);
    Insert (New (PButton, Init (R, 'O~k~', cmOk, bfDefault)));
  End;
  SetHelpCtx (Dialog, Help);
  RezFile.Put (Dialog, 'DemoDialog');
  FreeMem (Sign, S);
  Dispose (Dialog, Done);
End;

Begin
  {$IFNDEF VER60}
  PathToDriver := 'C:\BP\BGI';
  {$ELSE}
  PathToDriver := 'C:\TP\BGI';
  {$ENDIF}

  {$IFDEF change}
  {$IFDEF english}
  Language := lfEnglish;
  {$ENDIF}
  {$ENDIF}

  InitMemory;
  InitVideo;
  InitFonts;
  InitHistory;

  RezStream := New(PProtectedStream, Init('DEMO.REZ', stCreate, 4096));
  RezFile.Init (RezStream);

  RegisterType (RStrListMaker);
  RegisterDemo;

  CreateStatusHints;
  CreateDesktop;
  CreateMenuBar;
  CreateStatusLine;
  CreateLocalMenu;
  CreateFOpenDlg;
  CreateFColorDlg;
  CreateFInfo;
  CreateFChDirDlg;
  CreateWDialogDlg;

  RezFile.Done;
  DoneHistory;
  DoneFonts;
  DoneVideo;
  DoneMemory;
End.