.AUTODEPEND

#		*Translator Definitions*
# Root directory, change as appropriate
ROOT = C:\BORLANDC

#compiler, assumed in ROOT\bin directory
CC = $(ROOT)\bin\bcc +cpp3.cfg

#Library and Include directory
LIBPATH = $(ROOT)\LIB;$(ROOT)\TVISION\LIB
INCLUDEPATH = $(ROOT)\INCLUDE;$(ROOT)\TVISION\INCLUDE


#		*Implicit Rules*
.cpp.obj:
  $(CC) -c {$< }

#		*List Macros*

EXE_dependencies1 =  \
 cpprsrc.obj \
 readscpt.obj \
 tinplong.obj \
 tcolortx.obj \
 sinplong.obj \
 scolortx.obj \
 snocstr.obj \
 tnocstr.obj \
 scombo.obj \
 tcombo.obj

EXE_dependencies =  \
 cppsrc1.obj \
 readscpt.obj

EXE_dependencies2 =  \
 cppsrc2.obj \
 readscpt.obj

EXE_dependencies3 =  \
 readrsrc.obj \
 tinplong.obj \
 tcolortx.obj \
 sinplong.obj \
 scolortx.obj \
 snocstr.obj \
 tnocstr.obj \
 scombo.obj \
 tcombo.obj

#		*Explicit Rules*
def: readscpt1 all

noblink: readscpt2 all

readscpt1: cpp3.cfg readscpt.cpp
  $(CC) +cpp3.cfg -c readscpt.cpp

readscpt2: cpp3.cfg readscpt.cpp
  $(CC) +cpp3.cfg -c -DNoBlink readscpt.cpp

all: cppsrc1.exe cppsrc2.exe cpprsrc.exe readrsrc.exe delete

cpprsrc.exe: cpp3.cfg $(EXE_dependencies1)
  tlink /x/c/L$(LIBPATH) @&&|
c0l.obj+
cpprsrc.obj+
readscpt.obj+
tinplong.obj+
tcolortx.obj+
sinplong.obj+
scolortx.obj+
snocstr.obj+
tnocstr.obj+
scombo.obj+
tcombo.obj
cpprsrc
     #no map file -- leave blank
tv.lib+
cl.lib
|


cppsrc1.exe: cpp3.cfg $(EXE_dependencies)
  tlink /x/c/L$(LIBPATH) @&&|
c0l.obj+
cppsrc1.obj+
readscpt.obj
cppsrc1
     #no map file -- leave blank
tv.lib+
cl.lib
|

cppsrc2.exe: cpp3.cfg $(EXE_dependencies2)
  tlink /x/c/L$(LIBPATH) @&&|
c0l.obj+
cppsrc2.obj+
readscpt.obj
cppsrc2
     #no map file -- leave blank
tv.lib+
cl.lib
|

readrsrc.exe: cpp3.cfg $(EXE_dependencies3)
  tlink /x/c/L$(LIBPATH) @&&|
c0l.obj+
readrsrc.obj+
tinplong.obj+
tcolortx.obj+
sinplong.obj+
scolortx.obj+
snocstr.obj+
tnocstr.obj+
scombo.obj+
tcombo.obj
readrsrc
     #no map file -- leave blank
tv.lib+
cl.lib
|

delete:
   del cpprsrc.obj
   del readscpt.obj
   del tinplong.obj
   del sinplong.obj
   del tcolortx.obj
   del scolortx.obj
   del cppsrc1.obj
   del cppsrc2.obj
   del readrsrc.obj
   del snocstr.obj
   del tnocstr.obj
   del scombo.obj
   del tcombo.obj
   del cpp3.cfg
   del cpp3.csm


#		*Individual File Dependencies*
cpprsrc.obj: cpp3.cfg cpprsrc.cpp
tinplong.obj: cpp3.cfg tinplong.cpp
sinplong.obj: cpp3.cfg sinplong.cpp
scolortx.obj: cpp3.cfg scolortx.cpp
snocstr.obj: cpp3.cfg snocstr.cpp
tnocstr.obj: cpp3.cfg tnocstr.cpp
scombo.obj: cpp3.cfg scombo.cpp
tcombo.obj: cpp3.cfg tcombo.cpp
readrsrc.obj: cpp3.cfg readrsrc.cpp
cppsrc1.obj: cpp3.cfg cppsrc1.cpp
cppsrc2.obj: cpp3.cfg cppsrc2.cpp

#		*Compiler Configuration File*
cpp3.cfg: cpp3.mak
  copy &&|
-ml
-DTV1
-f-
-v-
-H
-H=cpp3.csm
-I$(INCLUDEPATH)
-L$(LIBPATH)
| cpp3.cfg


