PROGRAM mickey;

{ TABSize = 3 !!! }

{ Mouse test program by    Mark Stehr 15.03.1994 }
{ Random signal display by Alpo Vrri 17.03.1994 }

USES
	 Graph,VGraph,Mouse,Dos,Crt;

{$DEFINE Copy}									{ Copy | NoCopy }
{$DEFINE NoVirtual}							{ Virtual | NoVirtual }
{$DEFINE MODE3}
{
  MODE1 = Text modes. These modes are supported by the driver.
  MODE2 = BGI modes. These modes are supported by the driver, too.
  MODE3 = SVGA modes. We have to draw our own cursor
}

CONST
	OldX	: INTEGER = 0;
	OldY	: INTEGER = 0;

VAR
	pal         				: PaletteType;
	color							: LONGINT;
	MaxX,MaxY					: INTEGER;
	startx,starty,endx,endy	: INTEGER;
	x,y,dx,dy					: INTEGER;
	NumberOfButtons,Button,count : WORD;
	SenseX,SenseY,Double		: WORD;
	ok								: BOOLEAN;
	K,J,Py      				: Integer;

	grDriver,grMode			: INTEGER;
	Visible						: ViewPortType;

PROCEDURE check(VAR x,y : INTEGER);
BEGIN
	IF (x>= Visible.X2-16) AND (Visible.X2 < MaxX) THEN BEGIN
		scroll(16,0);
		Inc(Visible.X1,16);
		Inc(Visible.X2,16);
	END;
	IF (x<= Visible.X1+16) AND (Visible.X1>0) THEN BEGIN
		scroll(-16,0);
		Dec(Visible.X1,16);
		Dec(Visible.X2,16);
	END;
	IF (y>= Visible.Y2-16) AND (Visible.Y2 < MaxY) THEN BEGIN
		scroll(0,16);
		Inc(Visible.Y1,16);
		Inc(Visible.Y2,16);
	END;
	IF (y<= Visible.Y1+16) AND (Visible.Y1>0) THEN BEGIN
		scroll(0,-16);
		Dec(Visible.Y1,16);
		Dec(Visible.Y2,16);
	END;
END;

BEGIN
	IF NOT MouseDriverInstalled THEN BEGIN
		WriteLn('No mouse driver installed.');
		Halt(1);
	END;

{$ifdef MODE1}									{ Text mode }
	InitDriver(NumberOfButtons,TEXT,Ok);
	ShowPointer;
	REPEAT
		GetMotionCount(x,y);
		IF (x<>0) OR (y<>0) THEN BEGIN
			GetMousePosition(x,y);
			GotoXY(1,1);
			Write('X:',x:3,' Y:',y:3,' ');
		END;
   	button := ButtonPressed;
   	IF Button <> 0 THEN BEGIN
			HidePointer;
			GotoXY(1,2);
			CASE Button OF
				LeftButton : Write('Left   ');
				MiddleButton : Write('Middle   ');
				RightButton : Write('Right   ');
			END;
			ShowPointer;
		END;
	UNTIL KeyPressed;
	HidePointer;
	ResetMouseDriver(Ok);
{$ENDIF}

{$ifdef MODE2}									{ BGI mode }
	grDriver := detect;
	grMode := VGAHi;
	InitGraph(grDriver,grMode,'');

	graph.SetColor(Blue);
	for K:=0 to 7 do begin
		Y:=(graph.GetMaxY div 8)*K;
		PY:=Y;
		graph.MoveTo(0,Y+Random(graph.GetMaxY div 8));
		for J:=1 to graph.GetMaxX-1 do begin
			PY:=(3*PY+Y+Random(graph.GetMaxY div 8)) div 4;
			graph.LineTo(J,PY);
		end;
	end;

	InitDriver(NumberOfButtons,TEXT,Ok);
	SetPointerShape(-1,-1,NIL);
	ShowPointer;
	REPEAT
   	Inc(color);
		graph.SetColor(color);

		GetMousePosition(x,y);
		IF (x<>oldx) OR (y<>oldy) THEN BEGIN
			DX := X-OldX;
			DY := Y-OldY;
			HidePointer;
			graph.Bar(0,0,200,graph.TextHeight('X'));
			graph.OuttextXY(0,0,'X:'+st(x)+' Y:'+st(y)+' DX:'+st(dx)+' DY:'+st(dy));
			ShowPointer;
			OldX := X;
			OldY := Y;
		END;

		GetPressInfo(LeftButton,button,count,x,y);
		IF button = LeftButton THEN BEGIN
			startx := x;
			starty := y;
		END;

		GetPressInfo(RightButton,button,count,x,y);
		IF button = RightButton THEN BEGIN
			Sound(100);
		END;

		GetReleaseInfo(LeftButton,button,count,x,y);
		IF count > 0 THEN BEGIN
			endx := x;
			endy := y;
			HidePointer;
			graph.Line(startx,starty,endx,endy);
			ShowPointer;
		END;

		GetReleaseInfo(RightButton,button,count,x,y);
		IF count > 0 THEN
			NoSound;

	UNTIL KeyPressed;
	HidePointer;
	ResetMouseDriver(Ok);
	CloseGraph;
{$ENDIF}

{$IFDEF MODE3}									{ VESA mode }

{	InitVesa(V320x200x256);}
	InitVesa(V640x480x256);
	GetViewSettings(Visible);

	MaxX := GetMaxX;
	MaxY := GetMaxY;

{$IFDEF Virtual}
	SetVirtualWidth(1024);
	MaxX := GetVMaxX;
	MaxY := GetVMaxY;
{$ENDIF}

	SetRGBPal(255,255,255,255);
   SetRGBPal(0,40,40,40); 					{ Background light gray }

	{ The following is a good example of how my application looks like.        }
	{ The signal displayed looks very much like certain type of epileptic EEG. }

	SetColor(Blue);
 	for K:=0 to 7 do begin
  		Y:=(GetMaxY div 8)*K;
  		PY:=Y;
  		MoveTo(0,Y+Random(GetMaxY div 8));
  		for J:=1 to GetMaxX-1 do begin
   		PY:=(3*PY+Y+Random(GetMaxY div 8)) div 4;
   		LineTo(J,PY);
  		end;
	end;

	SetColor(GetMaxColor);
	Line(0,0,MaxX,MaxY);
	Line(0,MaxY,MaxX,0);

{$ifdef COPY}
	SetWriteMode(CopyPut);
{$else}
	SetWriteMode(XorPut);
{$endif}

	InitDriver(NumberOfButtons,GRAPHICS,Ok);
	SetLimits(0,0,MaxX-16,MaxY-16);

	ShowPointer;
	REPEAT
		Inc(color);
		SetColor(color);

		GetMousePosition(x,y);
{$IFDEF Virtual}
		Check(x,y);
{$ENDIF}
		IF (x<>oldx) OR (y<>oldy) THEN BEGIN
			DX := X-OldX;
			DY := Y-OldY;
			HidePointer;
			Bar(0,0,200,TextHeight('X'));
			OuttextXY(0,0,'X:'+st(x)+' Y:'+st(y)+' DX:'+st(dx)+' DY:'+st(dy));
			ShowPointer;
			OldX := X;
			OldY := Y;
		END;

   	GetPressInfo(LeftButton,button,count,x,y);
      IF button = LeftButton THEN BEGIN
        	startx := x;
			starty := y;
		END;

      GetPressInfo(RightButton,button,count,x,y);
   	IF button = RightButton THEN BEGIN
      	Sound(100);
		END;

      GetReleaseInfo(LeftButton,button,count,x,y);
      IF count > 0 THEN BEGIN
      	endx := x;
         endy := y;
         HidePointer;
         Line(startx,starty,endx,endy);
         ShowPointer;
      END;

      GetReleaseInfo(RightButton,button,count,x,y);
      IF count > 0 THEN
			NoSound;
	UNTIL KeyPressed;

   HidePointer;
	ResetMouseDriver(Ok);
{$IFDEF Virtual}
	SetVirtualWidth(0);
{$ENDIF}
	CloseVesa;
{$ENDIF}
END.