
unit LexDFA;

(* 2-5-91 AG *)

(* Copyright (c) 1990,91 by Albert Graef, Schillerstr. 18,
   6509 Schornsheim/Germany
   All rights reserved *)

interface

(* DFA table construction. This code, admittedly, is not the most aesthetic,
   but it's quite efficient (and that's the main goal). For further
   explanation, refer to Aho/Sethi/Ullman 1986, Section 3.9. *)

procedure makeDFATable;
  (* construct DFA from position table *)

implementation

uses LexBase, LexTables;

procedure makeDFATable;
  var i : Integer;
  begin
    (* initialize start states: *)
    for i := 2 to 2*n_start_states+1 do
      setunion(first_pos_table^[i]^, first_pos_table^[i mod 2]^);
    for i := 0 to 2*n_start_states+1 do
      act_state := newState(first_pos_table^[i]);
    act_state := -1;
    while succ(act_state)<n_states do
      begin
        inc(act_state);
        (* add transitions for active state: *)
        startStateTrans;
        for i := 1 to size(state_table^[act_state].state_pos^) do
          with pos_table^[state_table^[act_state].state_pos^[i]] do
            if pos_type=char_pos then
              addTrans([c], follow_pos)
            else if pos_type=cclass_pos then
              addTrans(cc^, follow_pos)
            else if pos=0 then
              state_table^[act_state].final := true;
        (* assign next states: *)
        for i := state_table^[act_state].trans_lo to n_trans do
          with trans_table^[i] do
            next_state := addState(follow_pos);
        (* merge transitions for the same next state: *)
        mergeTrans;
        (* sort transitions: *)
        sortTrans;
        endStateTrans;
      end;
  end(*makeDFATable*);

end(*LexDFA*).