{-------------------------------------------------------------------|
|   OpenDOS    |  Unit dedicated to OpenDOS multitasking functions. |
|--------------'                                                    |
|                                                                   |
| Author: Gautier.deMontmollin@Maths.UniNe.CH       v. 15 VII 1997  |
|-------------------------------------------------------------------}

{$B-}
unit OpenDOS;

interface

{====------------------ Basic functions of task manager -----------------====}

{==== Installation, status, informations ====}

function  Task_manager_installed: boolean;
procedure Get_status(var tasks, maximum_tasks, foreground_task_index: word;
                     var major_version, minor_version: byte);
function  Get_foreground_task_index: word; 
function  Check_open_files(task_index:word):word; 
procedure Get_swap_space_info(var available_KB, total_KB: word); 
function  Get_per_task_EMS_limit: word; 
procedure Set_per_task_EMS_limit(limit: word; var new_limit: word);

{==== Switching and shelling tasks ====}

procedure Switch_to(task_index:word); 
procedure Switch_to_task_manager; 
procedure Task_shelling(comline: String; new_task: boolean);

{==== Names, IDs ====}

type task_name = string[8];
const invalid_task_ID=$ffff;

function  Get_task_name(index: word): task_name;
procedure Name_task(task_index: word; name: task_name; { ''=clear renaming }
                    var flag:byte; var ID:word);
function  Index_to_ID(index:word):word; 
function  ID_to_index(id:word):word; 

{----------------------------------------------------------------------------}

implementation

uses DOS;

const pseudo_max_tasks=5000;

type id_table     = array[0..pseudo_max_tasks] of word;
     p_id_table   = ^id_table;
     task_name_a  = array[0..7] of char;
     name_table   = array[0..pseudo_max_tasks] of task_name_a;
     p_name_table = ^name_table;


function Task_manager_installed: boolean; assembler;
  asm mov ax,$2700; int $2F; 
      cmp al,$ff; mov ax,0; jnz @@F01non; inc ax; @@F01non: end;

procedure Get_status(var tasks, maximum_tasks, foreground_task_index: word;
                     var major_version, minor_version: byte); assembler;
  asm mov ax,$2701; int $2F;
      LES DI,tasks; DB $26; MOV [DI],cx;
      LES DI,maximum_tasks; DB $26; MOV [DI],ax;
      LES DI,foreground_task_index; DB $26; MOV [DI],bx;
      LES DI,major_version; DB $26; MOV [DI],dl;
      LES DI,minor_version; DB $26; MOV [DI],dh;
  end;

procedure Get_name_table_pointer(var pn: p_name_table); assembler; {interne}
  asm mov ax,$2701; int $2F;
      MOV DX,ES; MOV AX,DI;
      LES DI,pn; DB $26; MOV [DI],AX; DB $26; MOV [DI+2],DX {pn:= ptr(DX,AX)}
  end;

function Get_foreground_task_index: word; assembler;
  asm mov ax,$2701; int $2F; mov ax,bx end;

function Get_per_task_EMS_limit: word; assembler;
  asm mov ax,$2702; int $2F; mov ax,dx end;
  
procedure Set_per_task_EMS_limit(limit: word; var new_limit: word); assembler;
  asm mov ax,$2703; mov dx,limit; int $2F;
      LES DI,new_limit; DB $26; MOV [DI],dx end;

procedure Switch_to(task_index:word); assembler;
  asm mov ax,$2706; mov dx,task_index; int $2F end;

procedure Switch_to_task_manager; assembler;
  asm mov ax,$2715; int $2F end;  

function Get_task_name(index: word): task_name;
  var names: p_name_table; r:task_name; i:byte; n:task_name_a;
  begin
    Get_name_table_pointer(names);
    n:= names^[index];
    r:='';
    i:=0;
    while (i<=7) and (n[i]<>#0) do begin
    r:= r+ n[i];
    inc(i) end;
    Get_task_name:= r 
  end;

procedure Name_task_a(task_index, n_seg,n_ofs: word;
                      var flag:byte; var id:word); assembler;
  asm push ds
      mov ax,$2709;
      mov dx,task_index;
      mov bx,n_seg; mov cx,n_ofs; mov ds,bx; mov si,cx; int $2F;
      LES DI,flag; DB $26; MOV [DI],al;
      LES DI,id; DB $26; MOV [DI],bx;
      pop ds
  end;

procedure Cvt_task_name(t:task_name; var r: task_name_a); {interne}
  var i,l:byte;
  begin
    for i:= 0 to 7 do r[i]:= #0;
    l:= length(t); if l>8 then l:= 8;
    for i:= 1 to l do r[i-1]:= t[i];
  end;

procedure Name_task(task_index: word; name: task_name; 
                    var flag:byte; var id:word);
  var name_a: task_name_a;
  begin
    Cvt_task_name(name, name_a);
    Name_task_a(task_index, seg(name_a), ofs(name_a), flag, id)
  end;

function Index_to_id(index:word):word; assembler;
  asm mov ax,$270A; mov dx,index; int $2F; mov ax,dx end;   

function Id_to_index(id:word):word; assembler;
  asm mov ax,$270B; mov dx,id; int $2F; mov ax,dx end;   

function Check_open_files(task_index:word):word; assembler;
  asm mov ax,$270C; mov dx,task_index; int $2F end;   

procedure Get_swap_space_info(var available_KB, total_KB: word); assembler;
  asm mov ax,$2714; int $2F;
      LES DI,available_KB; DB $26; MOV [DI],dx;
      LES DI,total_KB; DB $26; MOV [DI],cx end;
      
procedure Task_shelling(comline: String; new_task: boolean);
  var COMSPEC: string;

  procedure Command(tm:boolean; cp: string);
    begin
      SwapVectors;
      if tm then Exec(GetEnv('OPENDOSCFG')+'\taskmgr.exe', cp)
            else Exec(COMSPEC, cp);
      SwapVectors
    end;

  BEGIN
    COMSPEC:= GetEnv('COMSPEC');
    if new_task and Task_manager_installed then begin
      if comline='' then Command(true, '/C'+COMSPEC)
                    else Command(true, '/C'+comline)
    end else begin
      if comline='' then Command(false, '')
                    else Command(false, '/C'+comline)
    end
  END;

end.
