{
        Object-Oriented Archive-viewer: ARJ-part
}

unit OOAVArj;

interface

uses      Dos,OOAV;

Type      AFHeader = Record
                       HeadId  : Word;                         { 60000 }
                       BHdrSz  : Word;             { Basic Header Size }
                       FHdrSz  : Byte;              { File Header Size }
                       AVNo    : Byte;
                       MAVX    : Byte;
                       HostOS  : Byte;
                       Flags   : Byte;
                       SVer    : Byte;
                       FType   : Byte;    { must be 2 for basic header }
                       Res1    : Byte;
                       DOS_DT  : LongInt;
                       CSize   : LongInt;            { Compressed Size }
                       OSize   : LongInt;            { Original Size }
                       SEFP    : LongInt;
                       FSFPos  : Word;
                       SEDLgn  : Word;
                       Res2    : Word;
                       NameDat : array[1..120] of char;{ start of Name, etc. }
                       Res3    : array[1..10] of char;
                     end;


type      PArjArchive=^TArjArchive;
          TArjArchive=object(TGeneralArchive)
                        constructor Init;
                        procedure FindFirst(var sr:SearchRec);virtual;
                        procedure FindNext(var sr:SearchRec);virtual;
                      private
                        _FHdr:AFHeader;
                        _SL:longint;
                        procedure GetHeader(var sr:SearchRec);
                      end;

implementation

const     BSize=4096;
var       BUFF:array[1..BSize] of Byte;



constructor TArjArchive.Init;
begin
  FillChar(_FHdr,sizeof(_FHdr),0);
end;


procedure TArjArchive.GetHeader(var sr:SearchRec);
var       bc:word;
          b:byte;
begin
  FillChar(_FHdr,SizeOf(_FHdr),#0);
  FillChar(BUFF,BSize,#0);
  Seek(_FArchive,_SL);
  BlockRead(_FArchive,BUFF,BSIZE,bc);
  Move(BUFF[1],_FHdr,SizeOf(_FHdr));
  with _FHdr do
  begin
    if BHdrSz>0 then
    begin
      b:=1;sr.Name:='';
      while NameDat[b]<>#0 do
      begin
        if NameDat[b]='/' then
          sr.Name:=''
        else
          sr.Name:=sr.Name+NameDat[b];
        inc(b);
      end;
      sr.Size:=BHdrSz+CSize;
      if FType=2 then sr.Size:=BHdrSz;
      if BHdrSz=0 then sr.Size:=0;
      inc(_SL,sr.Size+10);
      sr.Time:=DOS_DT;
    end;
  end;
end;


Procedure TArjArchive.FindFirst(var sr:SearchRec);
begin
  _SL:=0;
  GetHeader(sr);
  GetHeader(sr);
{ Why a call to GetHeader() twice?
  Because ARJ stores the name of the archive in the first field }
end;


procedure TArjArchive.FindNext(var sr:SearchRec);
begin
  GetHeader(sr);
end;


end.
