PROGRAM Automenu;
{$R-,I+,F-,B-,N-}
{$M 12000,0,64000}
{$V-}                {Disable STRING LENGTH Checks}

Uses printer,Dos,Crt,Scl;

VAR
  Mypath,
  Wrkstr:String80;
  Action_To_Be_Described,  {these 3 boolean variables}
  Progname_To_Be_Written,  {are used to control the}
  Paramline_To_Be_Cleared, {backgroud tasks to be done}
  First :BOOLEAN;
  Count,
  This_Entry,
  Next_Entry,
  Highest_Valid_Entry:INTEGER;
  Dta                : Searchrec;


PROCEDURE New_Field(VAR Old,NEW:INTEGER); {deselects old and}
VAR                                       {selects new field.}
  Progname:String13;
BEGIN;
  W_Sel(Old,FALSE);       {remove highlighting from old field}
  W_Sel(NEW,TRUE);        {highlight new field}
  Old:=NEW;               {new field is now the current one}
  Action_To_Be_Described:=TRUE;      {schedule activities}
  Progname_To_Be_Written:=TRUE;      {to be performed as a }
  Paramline_To_Be_Cleared:=TRUE;     {background task as soon}
END;                                 {as we find time...}

PROCEDURE Write_Action;             {called by user_slow_batch}
VAR                                 {as a background task}
  Progname:String13;                {does required update to}
BEGIN;                              {field number 47}
  Progname:=G_Cont(This_Entry);
  IF POS('<DIR>',Progname) > 0 THEN
    W_Cont(47,'Change Dir to')
  ELSE
    W_Cont(47,'Run Program');
  Action_To_Be_Described:=FALSE;    {this batch job done...}
END;


PROCEDURE Write_Progname; {another low priority batch job}
VAR                       {we only do if we have time to do it}
  Progname:String13;      {It updates field 48 and is called}
BEGIN;                    {by procedure user_slow_batch}
  Progname:=G_Cont(This_Entry);
  CASE POS('.',Progname) OF      {do the formatting..}
    0:Progname:=Justify_Left(Progname,8); {must be subdirectory}
    1:Progname:='<Parent Dir>'            {parent directory}
    ELSE
      Progname:=COPY(Progname,1,POS('.',Progname)-1); {program}
  END;
  W_Cont(48,Progname);           {write it to field 48}
  Progname_To_Be_Written:=FALSE; {this batch job done..}
END;

PROCEDURE Clear_Params;  {our third batch job. clears field 49,}
BEGIN;                   {if there is something in it}
  IF G_Cont(49) > ' ' THEN        {if there is something then..}
    C_Cont(49);                   {..clear it.}
  Paramline_To_Be_Cleared:=FALSE; {this batch job is done..}
END;

(*$F+*)   (* Force Far Calls Option; Required FOR Background Tasks*)
PROCEDURE Lp_Background_Task; {our background processing task}
{for low priority batch jobs. We use it here to update the screen
 whenever there is spare time to do it}
BEGIN;
  IF Progname_To_Be_Written THEN
    Write_Progname                 {our three batch jobs}
  ELSE                             {in sequence of their}
  IF Paramline_To_Be_Cleared THEN  {priority.}
    Clear_Params
  ELSE
  IF Action_To_Be_Described THEN
    Write_Action;
END;
(*$F-*)   (* RESET Force Far Calls Option*)

PROCEDURE Scl_Defaults;
BEGIN;
  Auto_Help_Set:=FALSE;           {AutoHelp feature disabled}
  Beep_Time:=1;                   {very short beep}
END;

PROCEDURE Pick_It_If_We_Need_It; {we want to display all }
                      {executable files plus all directory}
VAR                   {entries except the one for the current}
  Ext:String10;       {subdirectory, shown as a single dot}
  Len:INTEGER;

PROCEDURE Pick_It;
BEGIN;
  W_Cont(Count,Wrkstr); {write the file name to the next field}
  Count:=SUCC(Count);   {point to one field above}
END;

BEGIN;
  Wrkstr:=Dta.Name;
  Ext:=COPY(Wrkstr,POS('.',Wrkstr)+1,3); {get the extension}
  IF (Ext='BAT') OR (Ext='COM') OR (Ext='EXE') THEN
    Pick_It                           {write it to our format}
  ELSE
    IF (Dta.Attr AND $10) = $10 THEN {subdirectory}
      BEGIN;
        IF (Wrkstr[1]<>'.') OR (POS('..',Wrkstr) <>0) THEN
          BEGIN; {it is not a single dot ('this subdirectory')}
            Wrkstr:=Justify_Left(Wrkstr,8)+'<DIR>';
            Pick_It;   {mark it as a 'dir' entry and write it}
          END;         {to our format as well}
      END;
END;

PROCEDURE Init_Dir_Search;
BEGIN;
  First:=TRUE;
  Wrkstr:=Mypath+'*.*';
END;

PROCEDURE Update_Mydir;
BEGIN;
  Getdir(0,Mypath);                  {current path to 'mypath'}
  IF LENGTH(Mypath) > 3 THEN         {if it is not the root dir}
    Mypath:=Mypath + '\';            {then add a backslash.}
END;

PROCEDURE Notify_User;
BEGIN;
  TEXTCOLOR(Textattr+128);    {blink}
  WRITELN('Press RETurn to go back to AMENU');
  READLN; {maybe there is some info on the screen the }
END;      {user wants to read before we clear it}


PROCEDURE Display_Files; {get all files in the current directory}
BEGIN;
  W_Cont(1,Mypath);   {write the present path to field 1}
  Count:=2;           {our filename entries start here}
  REPEAT
    IF First THEN
      BEGIN;
        Findfirst(Wrkstr,(Anyfile-(Hidden+Volumeid+Sysfile)),Dta);
        First:=FALSE;
      END
    ELSE
      Findnext(Dta);     {get a filename}
    IF Doserror = 0 THEN        {we found one..}
      Pick_It_If_We_Need_It
    ELSE
      Init_Dir_Search;     {for the next time}
  UNTIL (Doserror>0) OR (Count>46); {no more files or format full}
  Highest_Valid_Entry:=Count - 1; {no file names beyond there}
  IF Count <= 46 THEN             {clear the remaining fields}
    FOR Count:=Count TO 46 DO     {because they still might }
      C_Cont(Count);       {contain something from last time}
  Next_Entry:=2;           {the field we want to highlight}
  New_Field(This_Entry,Next_Entry); {do it.}
END;

PROCEDURE Handle_Key;    {user function key handling procedure}
BEGIN;
  IF Char_Code = Code_F9 THEN   {next page}
    BEGIN;
      W_Sel(This_Entry,FALSE);  {deselect currently highlighted}
      Display_Files; {field and refill the format. 'first' }
    END   {determines whether this is the first page or not}
  ELSE
  IF (Char_Code = Code_Right) THEN
    Next_Entry:= This_Entry + 1 ELSE
  IF (Char_Code = Code_Left)  THEN
    Next_Entry:= This_Entry - 1 ELSE
  IF (Char_Code = Code_Up)    THEN
    Next_Entry:= This_Entry - 5 ELSE
  IF (Char_Code = Code_Down)  THEN
    Next_Entry:= This_Entry + 5 ELSE
  IF (Char_Code = Code_Home)  THEN
    Next_Entry:= 2             ELSE
  IF (Char_Code = Code_End)   THEN
    Next_Entry:= Highest_Valid_Entry;

  IF (Next_Entry > Highest_Valid_Entry) OR (Next_Entry < 2) THEN
    Next_Entry:=This_Entry; {we stay where we are in these cases}

  IF Next_Entry <> This_Entry THEN {if we found a new field then}
    New_Field(This_Entry,Next_Entry); {let's go there.}

  IF Char_Code = Code_Escape THEN   {we just want to act in the}
    Char_Code:=Code_F10   {same way as if F10 was pressed}
  ELSE
  IF (Char_Code = Code_Return) THEN
    Char_Code:=Code_Escape  {normally SCL would switch to edit}
  ELSE           {mode now, but we want to save one keystroke.}
    Char_Code:=Code_Noop; {SCL should not act on this character}
END;

PROCEDURE Do_Work;
VAR
  T,
  Newdir,
  Progname:String80;
BEGIN;
  Progname:=G_Cont(This_Entry);          {the highlighted field}
  IF POS('<DIR>',Progname) > 0 THEN      {if it is a directory}
    BEGIN;
      Frontstring(Progname,Newdir,T);
      Chdir(Newdir);
      Update_Mydir;
    END
  ELSE
    BEGIN;
      IF (POS('.BAT',Progname) > 0) THEN          {a batch file}
        Executedos(Mypath+Progname+' '+G_Cont(49)) {then fire it}
      ELSE                                   {up via 'DOS' else}
        EXECUTE(Mypath+Progname+' '+G_Cont(49)); {Execute}
      IF Doserror = 0 THEN       {we are successfully back}
        Notify_User;
      TEXTMODE(Screen_Mode);      {if we were in another mode}
      CLRSCR;                     {blank the screen}
    END;
END;

PROCEDURE Tell_Result;
VAR Wstr:STRING;
BEGIN;
  IF (Doserror > 0) AND (Doserror <> 18) THEN {we had a problem,
                                              18=no more files}
    BEGIN;
      Wstr:=Sys_Msg(Doserror+20); {ErrMsg}
      Beep;                       {wake up user}
    END
  ELSE
    BEGIN;
      CASE Dosexitcode OF
          0 : Wstr:= 'Operation was successful';
          1 : Wstr:= 'Program was terminated by Ctrl_C';
          2 : Wstr:= 'Program was terminated due to a device error';
          3 : Wstr:= 'Program was terminated and kept resident';
      END;
    END;
  W_Cont(50,Wstr);
END;


PROCEDURE Menu;
BEGIN;
  Select_Format('amenu');           {load format into heap}
  Init_Dir_Search;
  This_Entry:=2;
  Display_Files;        {fill fields 2..46 with file names}
  Tell_Result;    {result from our last execute to field 50}
  Display_Format(X_Max DIV 2,Y_Max DIV 2);  {center of screen}
  REPEAT
    Handle_Format;
    IF User_Function THEN    {one of the specified keys pressed}
      Handle_Key;            {handle it.}
  UNTIL Format_Done;
  IF NOT Format_Aborted THEN  {if normal termination}
    Do_Work;
END;

BEGIN; {of main}
  Select_Format_File('Sample4');   {initializes SCL and loads the format
                                   {file 'Sample4'}
  Scl_Defaults;                    {change some SCL defaults}
  Lp_Background_Pointer:=@lp_Background_Task; (*invoke our own background
                                                processing routine*)
  Update_Mydir;

  REPEAT
    Menu                           {main loop}
  UNTIL Format_Aborted;            {'F10' key was pressed }
  Close_Formats;                   {terminate SCL}
END.  {of main}
