{ͻ
                                  MOS GOLF                                  
 ͹
                   To be used with MOS v3.1 Professional GUI                
 ͹
  Coded by Zuul as BouFFtou as Cheveau Frdric.                            
  Source Turbo Pascal v7.00 generated by MRE (MOS Resource Editor) v2.8.    
  Contact us on MOS Home's Page - http://www.multimania.com/mos             
 ͼ}

{$M 65500,0,365520}                     {*Stack And Heap*}

Program GOLF;                           {*Program Name*}

Uses Dos,                               {*Unit BP7 DOS*}
     MOS_VESA,MOS_DEB,                  {*Manage VESA and debug*}
     MOS_STR, MOS_BLK,                  {*Manage Strings and blankers*}
     MOS_CRT, MOS_BAS,                  {*Manage Initialisations and CRT*}
     MOS_ASM, MOS_MSE,                  {*Manage Assembler and Mouse*}
     MOS_IPX, MOS_XMS,                  {*Manage Networks and XMS Memory*}
     MOS_TOO, MOS_GAD,                  {*Manage Tools and Gadgets*}
     MOS_GFX, MOS_BMP,                  {*Manage Graphics and BMP*}
     MOS_WIN, MOS_MEN,                  {*Manage Windows and Menus*}
     MOS_WAV, MOS_VAR,                  {*Manage WAV Sounds*}
     MOS_DIR, MOS_SYS,                  {*Manage Disk and System*}
     MOS_TSK, MOS_LIS,                  {*Manage Tasks and Lists*}
     MOS_EZR, MOS_GPH,                  {*Manage Dialogs and Graph*}
     MOS_KBD, MOS_DSK,                  {*Manage Keyboard and Disk*}
     MOS_REQ, MOS_OCG,
     MOS_FIL, MOS_CAR,
     MOS_LFN, MOS_SWAP;                 {*Manage Requesters and Swap Disk*}

Const
    App_Name='MOS Golf';
    App_Version='v1.1 - 31.12.1998';
    Max_Ths=20;                         {*Maximum High Scores*}

Var C                  :TCards;
    NbGames            :Integer;        {*Nombre de parties joues*}
    NbWin              :Integer;        {*Nombre de parties gagnes*}
    Debut              :Integer;        {*Dbut des colonne*}
    ToggleCard         :Boolean;
    AThs               :Array[0..52] of Integer;{*Tableau des High Scores*}
    Nb_Columns         :Integer;
    Nb_CardsPerCol     :Integer;
    Cheat              :Boolean;        {*Pour tricher...*}

    P_Launch           :String;         {*App Directory*}
    P_Main             :String;

{ͻ
                              PROCEDURE INIT_APP                            
 ͼ}

Procedure INIT_APP;
Var A,Code:Integer;

Begin
SetApplicationTitle('Cathy Golf');
C.Verso:='V00.BMP';
Card_SetMaximum(C,52);                  {*52 Cartes*}
ToggleCard:=TRUE;
NbGames:=0;
NbWin:=0;
Nb_Columns:=7;
Nb_CardsPerCol:=5;
Cheat:=FALSE;

{$I-}
ChDir(Dsk_GetHome);                     {*Return to initial path*}
{$I+}

If Not File_TestExist('GOLF.THS') Then Exit;
For A:=1 to Max_Ths do
   Begin
   Val(Str_Get(File_GetLine('GOLF.THS',A),2,';'), AThs[A-1], Code);
   End;
End;

{ͻ
                              PROCEDURE SAVE_THS                            
 ͼ}

Procedure SAVE_THS;
Var A:Integer;
Begin
If Not Dsk_TestWritableDrive(Copy(Dsk_GetHome,1,1)) Then Exit; {*CD ou Autre*}

If File_TestExist('GOLF.THS') Then File_Erase('GOLF.THS');
For A:=0 to Max_Ths do
   Begin
   File_AppendStr('GOLF.THS', Str_FillZero(A,2)+';'+Str_FillZero(AThs[A],3)+'');
   End;
End;

{ͻ
                             PROCEDURE RESTORE_APP                          
 ͼ}

Procedure RESTORE_APP;
Begin
SAVE_THS;                               {*Save High-Scores*}
{$I-}
ChDir(P_Launch);                        {*Return to initial path*}
{$I+}
End;

{****************************** SAVE PARAMETERS *****************************}

Procedure SAVE_PARAM;
Var Fil1:Text;
    A:Integer;

Begin
If Not Dsk_TestWritableDrive(Copy(Dsk_GetHome,1,1)) Then Exit; {*CD ou Autre*}

Assign(Fil1,'GOLF.CFG');
{$I-}
Rewrite(Fil1);
{$I+}
If IOResult=0 Then Begin
   Writeln(Fil1,'[MOS Golf]');
   Writeln(Fil1);
   Writeln(Fil1,'[Parameters]');
   Writeln(Fil1,'Verso Image (',C.Verso,')');
   Writeln(Fil1,'Toggle Card (',ToggleCard,')');
   Writeln(Fil1,'Games (',NbGames,')');
   Writeln(Fil1,'Win (',NbWin,')');
   Writeln(Fil1,'Quantity of Columns (',Nb_Columns,')');
   Writeln(Fil1,'Quantity of Cards per Column (',Nb_CardsPerCol,')');
   Close(Fil1);
   End;
End;

{****************************** SAVE PARAMETERS *****************************}

Procedure LOAD_PARAM;
Var LineReaded:Integer;
    Fin,Skip:Boolean;
    St,StLower,FName,StVal:String;
    P1,P2,Code:Integer;                 {*Position "(" et ")"*}
    A,N:Integer;

Begin
FName:='GOLF.CFG';
LineReaded:=File_TestString(FName,'[MOS Golf]',0);
If LineReaded=0 Then Exit;              {*File not Found or Incorrect file*}
Fin:=FALSE;

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineReaded);
   If LineReaded>File_CountLines(FName) Then Fin:=TRUE;
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   StLower:=StVal;
   St:=Upper(St);
   StVal:=Upper(StVal);
   Skip:=FALSE;
   If Copy(St,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('VERSO IMAGE', St)>0 Then C.Verso :=StVal;
      If Pos('TOGGLE CARD', St)>0 Then If Pos('TRUE',StVal)>0 Then ToggleCard:=TRUE Else ToggleCard:=FALSE;
      If Pos('GAMES'      , St)>0 Then Val(StVal,NbGames,Code);
      If Pos('WIN'        , St)>0 Then Val(StVal,NbWin,Code);
      If Pos('QUANTITY OF COLUMNS', St)>0 Then Val(StVal,Nb_Columns,Code);
      If Pos('QUANTITY OF CARDS PER COLUMN', St)>0 Then Val(StVal,Nb_CardsPerCol,Code);
      End;
   Inc(LineReaded);                     {*Next Line...*}
   Until Fin;

{$I-}
ChDir(P_Main);                          {*Return to initial path*}
{$I+}
End;

{ͻ
                               PROCEDURE Main                               
 ͼ}

Procedure Main;
Const Bord        =40;
      Max_Columns =10;

Var W1            :TWindow;             {*Window Structure*}
    Even          :Byte;                {*Get Windows Evens*}
    XOk,XCancel   :Boolean;             {*Exit Flags*}
    But1,But2,But3,But4:TButton;
    BPioche       :TButton;
    A,B           :Integer;             {*Loop*}
    CardsLeft     :Longint;             {*Nombre de cartes restantes*}
    Column        :Array[1..Max_Columns] of Integer;{*30 columns Maximum*}
    Qtt_Pioche    :Integer;             {*Nombre de cartes dans la pioche*}
    Qtt_Result    :Integer;             {*Nombre de cartes dans le rsultat*}
    LastCardFree  :Integer;             {*Numro de la dernire carte sur la ligne des rsultats*}
    Click         :Boolean;             {*La souris est clique*}
    HasBeenClicked:Boolean;             {*La souris  t clique*}
    PreselectedCard:Integer;            {*Carte en Toggle*}
    OnCard        :Integer;             {*Sur une carte*}
    MaxX          :Integer;             {*Taille X de la fentre en Extended*}
    Finished      :Boolean;             {*Le jeu est fini*}
    RMBClicked    :Boolean;
    TCO           :Array[1..Max_Columns] of Boolean;

{************************** N'AFFICHE PAS LA PIOCHE *************************}

Procedure DoNotDisplayPioche;
Begin
VESA_SetFillStyle(1,10);
Show_BMP(Column[1],W1.Y2-W1.Y1-100-Bord,Column[1]+70, W1.Y2-W1.Y1-100-Bord+96
         ,0,0,Get_SystemPath(SP_CARDS)+P_Verso+'S01.BMP',$0080);
End;

{ͻ
                          PROCEDURE App_Parameters                          
 ͼ}

Function App_Parameters(Px,Py:Integer):Boolean;
Var W1            :TWindow;             {*Window Structure*}
    Even          :Byte;                {*Get Windows Evens*}
    XOk,XCancel   :Boolean;             {*Exit Flags*}
    But1,But2,But3:TButton;
    Rad1          :TRadioBox;
    Isl1,Isl2     :TInputSlider;
    VCi1,VCi2     :Longint;
    OldVCi1,OldVCi2:Longint;
    Num           :Integer;

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
Button  (LaF*4, HaF*2, LaF*24,-1, 0,7,$0060,But1,'_CARDS BACK');
Button  (LaF*30,HaF*2, LaF*24,-1, 0,7,$0060,But3,'_SCORES');
Button  (LaF*20,W1.Y2-W1.Y1-HaF1-HaF-10, LaF*16,-1, 0,7,$0110,But2,'_OK');
RadioBox(LaF*4, HaF*4,1,$0010,0,0,Rad1.Status,Rad1,'TOGGLE FREE CARDS');
InputSlider(LaF*4, HaF*6, LaF*6,12,11,1,4,9,1,VCi1,$0000,Isl1);
InputSlider(LaF*4, HaF*8, LaF*6,12,11,1,3,8,1,VCi2,$0000,Isl2);

Display(LaF*14, HaF*6+2,-1,0,'QUANTITY OF COLUMNS');
Display(LaF*14, HaF*8+2,-1,0,'QUANTITY OF CARDS PER COLUMN');
Display(LaF*4,  HaF*10+6,-1,0,'NUMBER OF GAMES = '+Str_FillZero(NbGames,4));
Display(LaF*4,  HaF*12+2,-1,0,'NUMBER OF WIN   = '+Str_FillZero(NbWin,4));

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
Win_Init(Px,Py,Px+LaF*59-4,Py+HaF1+HaF*17,$5199,App_Name+' '+App_Version+' Preferences',W1);
Win_Sup(100,50,250,200,79,60,639,479,0,5,$0A10,W1);{*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

VCi1:=Nb_Columns; VCi2:=Nb_CardsPerCol; {*Define Values*}
OldVCi1:=Nb_Columns; OldVCi2:=Nb_CardsPerCol; {*Define Values*}
Rad1.Status:=ToggleCard;
REDRAW_FRAME;                           {*Display Window Content*}
XOk:=No; XCancel:=No;                   {*Init Exit Flags*}

Repeat;
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then
      Begin
      Mse_Hide;
      DoNotDisplayPioche;
      Mse_Show;
      C.Verso:=Card_DefineBack(120,120,C.Verso);
      REDRAW_FRAME;                           {*Display Window Content*}
      End;
   If Button_GetMsg(But2,1) Then XOk:=TRUE;
   If Button_GetMsg(But3,1) Then Req_List(120,120,$0003, App_Name+' SCORES','Cards left ;Quantity ',';','GOLF.THS');
   RadioBox_GetMsg(Rad1,1);
   InputSlider_GetMsg(Isl1,VCi1);
   InputSlider_GetMsg(Isl2,VCi2);
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then XCancel:=Yes;            {*Window Closed   => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XOk) Or (XCancel);               {*Exit Flags*}

Win_Kill(W1);                           {*Close Window if Needs*}

App_Parameters:=FALSE;
If XOk Then Begin                       {*Save Datas*}
   ToggleCard:=Rad1.Status;
   Nb_Columns:=VCi1;
   Nb_CardsPerCol:=VCi2;
   If (VCi1<>OldVCi1) Or (VCi2<>OldVCi2) Then App_Parameters:=TRUE;
   End;
End;


{************ RENVOIS LA COLONNE DANS LAQUELLE SE TROUVE LA CARTE ***********}

Function Get_ColumnCard(Num:Integer):Byte;
Var St1           :String;
    Column,Code   :Integer;
Begin
Get_ColumnCard:=0;                   {*De Base*}
St1:=Card_GetIdent(C,Num);           {*Identificateur de Type + Numro*}
St1:=Str_Get(St1,1,'-');             {*Identificateur de Type*}
If Copy(St1,1,1)<>'C' Then Exit;     {*Ce n'est pas l'une des sept colonnes*}
Val(Copy(St1,2,1),Column,Code);
Get_ColumnCard:=Column;              {*Renvois Valeur*}
End;

{********************* RENVOIS LE NUMERO ID DE LA CARTE *********************}

Function Get_NumberCard(Num:Integer):Integer;
Var St1           :String;
    Number,Code   :Integer;
Begin
St1:=Card_GetIdent(C,Num);           {*Identificateur de Type + Numro*}
St1:=Str_Get(St1,2,'-');             {*Identificateur de Type*}
Val(St1,Number,Code);
Get_NumberCard:=Number;
End;

{*********************** CALCULE POSITION DES COLONNES **********************}

Procedure CALCULE_COLUMNS;
Const Espacement=10;                    {*Espacement entre les colonnes*}
Var A             :Integer;
Begin
For A:=1 to Nb_Columns do Column[A]:=72*(A-1)+(Espacement*(A-1))+Debut;{*Pos Column*}
End;

{************************ CALCULE POSITION DES CARTES ***********************}

Procedure CALCULE_POSITIONS;
Var A             :Integer;             {*Loop*}
    St1           :String;
    Num,Code,GCol :Integer;             {*Position de la Carte (Integer)*}

Begin
For A:=1 to C.Max_Cards do
   Begin
   St1:=Card_GetIdent(C,A);             {*Identificateur de Type + Numro*}
   St1:=Copy(St1,1,1);                  {*Identificateur de Type*}
   Num:=Get_NumberCard(A);
   GCol:=Get_ColumnCard(A);

   If St1='P' Then Card_SetPosition(C,A,Column[1],W1.Y2-W1.Y1-100-Bord);
   If St1='R' Then Card_SetPosition(C,A,Column[2]+5+(Num-1)*10,W1.Y2-W1.Y1-100-Bord);
   If St1='C' Then Card_SetPosition(C,A,Column[GCol],30+(Num-1)*18);
   End;
End;

{************** TESTE SI LA CARTE EST SUR LE HAUT DE LA COLONNE *************}

Function CARD_ISONTOP(N:Integer):Boolean;{*Teste si le carte est en haut*}
Var A,Qtt:Integer;
    Id:String;
Begin
CARD_ISONTOP:=FALSE;                    {*De Base*}

Qtt:=0;
For A:=1 to C.Max_Cards do
   Begin
   Id:='C'+Copy(Card_GetIdent(C,N),2,1);
   If Pos(Id,Card_GetIdent(C,A))>0 Then Inc(Qtt);
   End;

If Get_NumberCard(N)<Qtt Then Exit;
CARD_ISONTOP:=TRUE;                     {*Carte est sur le haut de la colonne*}
End;

{************************* TESTE SI LA CARTE EST BONNE **********************}

Function CARD_ISGOOD(N:Integer):Boolean;{*Teste si le carte est bonne*}
Var A:Integer;
    Id:String;
Begin
CARD_ISGOOD:=FALSE;                     {*De Base*}

If (C.Cards[LastCardFree].Value=13) Then Exit; {*C'est un Roi => Pas bon de base*}
If (C.Cards[N].Value+1=C.Cards[LastCardFree].Value) And (C.Cards[N].Value+1<=13) Then CARD_ISGOOD:=TRUE;
If (C.Cards[N].Value-1=C.Cards[LastCardFree].Value) And (C.Cards[N].Value-1>=1)  Then CARD_ISGOOD:=TRUE;
End;

{***************** TESTE SI IL RESTE DES CARTES DEPLACABLES *****************}

Function Test_CardsLeft:Boolean;
Var A:Integer;
    Res:Boolean;

Begin
For A:=1 to Nb_Columns do TCO[A]:=FALSE;{*Fill Array in Negative*}

For A:=1 to C.Max_Cards do              {*Teste toutes les cartes*}
   Begin
   If (CARD_ISONTOP(A)) And (CARD_ISGOOD(A)) Then
      Begin
      TCO[Get_ColumnCard(A)]:=TRUE;
      End;
   End;
Res:=FALSE;
For A:=1 to Nb_Columns do If TCO[A]=TRUE Then Res:=TRUE;
Test_CardsLeft:=Res;                    {*Renvois le rsultat*}
End;

{************************ AFFICHE LES CARTES EN COLONNE *********************}

Procedure Redraw_CardsOnColumns;        {*Affiche les cartes*}
Var A:Integer;
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
Mse_Hide;

For A:=1 to C.Max_Cards do
   If Pos('C',Card_GetIdent(C,A))>0 Then Card_Display(C,A);
Mse_Show;
End;

{************************* AFFICHE LES CARTES RESULTAT **********************}

Procedure Redraw_CardsOnResult;
Var Id:String;
    A,B:Integer;
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
Mse_Hide;
VESA_SetFillStyle(1,10);
VESA_Bar(Column[2], W1.Y2-W1.Y1-120-Bord, VESA_GetMaxX, W1.Y2-W1.Y1-Bord);

For A:=1 to Qtt_Result do
   For B:=1 to C.Max_Cards do
      Begin
      Id:='R0-'+Str_FillZero(A,2);
      If Card_GetIdent(C,B)=Id Then Begin Card_Display(C,B); End;
      End;
Mse_Show;
End;

{***************************** AFFICHE LA PIOCHE ****************************}

Procedure Redraw_CardsOnPioche;
Var A:Integer;
Begin
Win_Clip(On,W1);                        {*Clipping Window*}

Mse_Hide;
For A:=1 to C.Max_Cards do
   If Pos('P',Card_GetIdent(C,A))>0 Then
      Begin Card_Display(C,A);
      Button(C.Cards[A].Px,C.Cards[A].Py,70,96,0,7,$0114,BPioche,'');
      Break;
      End;
Set_Font('MODN.CHR',4);
Display(Column[1]+52,C.Cards[A].Py+100,-1,15,Str_FillZero(Qtt_Pioche,2));
Set_Font('LITT.CHR',4);

If Qtt_Pioche=0 Then DoNotDisplayPioche;
Mse_Show;
End;

{*********************** REAFFICHE LA CARTE DU DESSOUS **********************}

Procedure Redraw_PreviousCard(N:Integer); {*Affiche la Carte prcdente*}
Var Id:String;
    X1,Y1,X2,Y2:Integer;
    A:Integer;

Begin
Win_Clip(On,W1);                        {*Clipping Window*}
Mse_Hide;
Id:=Copy(Card_GetIdent(C,N),1,3)+Str_FillZero(Get_NumberCard(N)-1,2);
VESA_SetFillStyle(1,10);                {*Efface la carte "N"*}
X1:=C.Cards[N].Px-1; Y1:=C.Cards[N].Py-6; X2:=X1+70; Y2:=Y1+96;
VESA_Bar(X1,Y1,X2,Y2);
Mse_Show;
If Get_NumberCard(N)=1 Then Exit;       {*Dernire carte !*}

For A:=1 to C.Max_Cards do              {*Raffiche la carte prcdente*}
   If Id=Card_GetIdent(C,A) Then
      Begin
      Card_Display(C,A);
      Break;
      End;
End;

{******************************* DISPLAY SCORE ******************************}

Procedure Display_Score;
Begin
BevelBox(W1.X2-W1.X1-140, 6, W1.X2-W1.X1-2, 6+13,1,7,FALSE,TRUE);
Set_Font('MODN.CHR',4);
Display (W1.X2-W1.X1-130, 7,-1,0,'CARDS LEFT = '+Str_FillZero(CardsLeft,2));
Set_Font('LITT.CHR',4);
End;

{********* TRICHE, PIOCHE UNE CARTE ET L'AFFICHE DANS LES RESULTATS *********}

Procedure Move_CardsFromPiocheToResultsCheat;
Var A,OldLastCardFree:Integer;
    Id:String;
    Ok:Integer;                         {*Numro de la carte Ok*}
    FirstCard:Integer;                  {**Premire carte de la pioche}

Procedure Add_TemporaryCardToResult;
Begin
Inc(Qtt_Result);
Dec(Qtt_Pioche);
Dec(CardsLeft);
Id:='R0-'+Str_FillZero(Qtt_Result,2);
Card_SetIdent(C,A,Id);
Card_SetRecto(C,A,TRUE);
Card_SetMovable(C,A,FALSE);
OldLastCardFree:=LastCardFree;
LastCardFree:=A;                        {*Pointe sur la dernire carte libre*}
End;

Procedure Dec_TemporaryCardToResult;
Begin
Dec(Qtt_Result);
Inc(Qtt_Pioche);
Inc(CardsLeft);
Id:='P0-'+Str_FillZero(Qtt_Pioche,2);
Card_SetIdent(C,A,Id);
Card_SetRecto(C,A,FALSE);
Card_SetMovable(C,A,FALSE);
LastCardFree:=OldLastCardFree;          {*Pointe sur la dernire carte libre*}
End;

{=========== Main Code ============}

Begin
Win_Clip(On,W1);                        {*Clipping Window*}
If Qtt_Pioche<1 Then Exit;              {*Pioche vide !*}
Ok:=0; FirstCard:=0;

For A:=1 to C.Max_Cards do              {*Parcours toutes les cartes*}
   If Pos('P',Card_GetIdent(C,A))>0 Then
      Begin
      If FirstCard=0 Then FirstCard:=A;
      Add_TemporaryCardToResult;        {*Transfre temporairement sur les rsultats*}
      If Test_CardsLeft Then Ok:=A      {*Y a t'il des cartes de libre ?*}
         Else Begin
         Dec_TemporaryCardToResult;     {*Non => On remet la carte sur la pioche*}
         End;
      If Ok>0 Then Break;               {*La carte est bonne => On sort*}
      End;

If Ok=0 Then Begin A:=FirstCard; Add_TemporaryCardToResult; Ok:=A; End;
CALCULE_POSITIONS;                      {*Recalcule les coordonnes des Cartes*}
Card_Display(C,Ok);
Redraw_CardsOnPioche;                   {*Raffiche la pioche*}
Display_Score;
End;

{************* PIOCHE UNE CARTE ET L'AFFICHE DANS LES RESULTATS *************}

Procedure Move_CardsFromPiocheToResults;
Var A:Integer;
    Id:String;
Begin
If Cheat Then Begin                     {*Pioche une carte en trichant !*}
   Move_CardsFromPiocheToResultsCheat;
   Exit;
   End;

Win_Clip(On,W1);                        {*Clipping Window*}
If Qtt_Pioche<1 Then Exit;              {*Pioche vide !*}

For A:=1 to C.Max_Cards do
   If Pos('P',Card_GetIdent(C,A))>0 Then
      Begin
      Inc(Qtt_Result);
      Dec(Qtt_Pioche);
      Dec(CardsLeft);
      Id:='R0-'+Str_FillZero(Qtt_Result,2);
      Card_SetIdent(C,A,Id);
      Card_SetRecto(C,A,TRUE);
      Card_SetMovable(C,A,FALSE);
      LastCardFree:=A;                  {*Pointe sur la dernire carte libre*}
      Break;
      End;

CALCULE_POSITIONS;                      {*Recalcule les coordonnes des Cartes*}
Card_Display(C,A);
Redraw_CardsOnPioche;                   {*Raffiche la pioche*}
Display_Score;
End;

{************* DEPLACE UNE CARTE ET L'AFFICHE DANS LES RESULTATS ************}

Procedure Move_CardsFromColumnsToResults(A:Integer);
Var Id:String;
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
If (A<1) Or (A>52) Then Exit;           {*Numro de carte incorrect !*}

Redraw_PreviousCard(A);                 {*Affiche la Carte prcdente*}
Inc(Qtt_Result);
Dec(CardsLeft);
Id:='R0-'+Str_FillZero(Qtt_Result,2);
Card_SetIdent(C,A,Id);
Card_SetRecto(C,A,TRUE);
Card_SetMovable(C,A,FALSE);
LastCardFree:=A;                        {*Pointe sur la dernire carte libre*}

CALCULE_POSITIONS;                      {*Recalcule les coordonnes des Cartes*}
Card_Display(C,A);
Display_Score;
End;

{*************************** DISPLAY WINDOW CONTENT *************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var FName:String;
    A             :Integer;

Begin
Win_Clear(W1);                          {*Efface l'cran*}

Win_Clip(On,W1);                        {*Clipping Window*}
Mse_Hide;
VESA_SetFillStyle(1,8);
VESA_Bar(0,0,VESA_GetMaxX-1,15);
VESA_SetFillStyle(1,7);
Mse_Show;
Display_Score;                          {*Affiche le Score*}

Button(01, 6 ,90,-1,0,7,$0010,But1,'DON_E');
Button(92, 6 ,90,-1,0,7,$0012,But2,'_BACK');
Button(183,6 ,90,-1,0,7,$0010,But3,'_PARAMETERS');
Button(274,6 ,90,-1,0,7,$0010,But4,'_SYSTEM');

CALCULE_COLUMNS;                        {*Build Columns and Cards Positions*}
CALCULE_POSITIONS;                      {*Recalcule les coordonnes des Cartes*}

Redraw_CardsOnColumns;                  {*Affiche les cartes*}
Redraw_CardsOnPioche;
Redraw_CardsOnResult;

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{**************************** INITIALISE LE JEU *****************************}

Procedure INIT_GAME;
Var A,B,Num       :Integer;

Begin
Repeat
   Card_NewGame(C);
   Card_Mix(C);
   Qtt_Pioche:=52-(Nb_Columns*Nb_CardsPerCol)-1;
   Qtt_Result:=1;
   LastCardFree:=52;
   CardsLeft:=52-Qtt_Result;
   PreselectedCard:=0;
   Finished:=FALSE;

   If Gfx_Mode=12 Then Debut:=10 Else Debut:=30;

   Num:=1;
   For A:=1 to Nb_CardsPerCol do
      For B:=1 to Nb_Columns do
         Begin
         Card_SetIdent(C,Num,'C'+Str_FillZero(B,1)+'-'+Str_FillZero(A,2));
         Card_SetRecto(C,Num,TRUE);
         Card_SetMovable(C,Num,TRUE);
         Inc(Num);
         End;

   For A:=1 to Qtt_Pioche do            {*Pioche*}
      Begin
      Card_SetIdent(C,Num,'P0-'+Str_FillZero(A,2));
      Card_SetRecto(C,Num,FALSE);
      Card_SetMovable(C,Num,FALSE);
      Inc(Num);
      End;
                                        {*Le Tas Rsultat*}
   Card_SetIdent  (C,LastCardFree,'R0-'+Str_FillZero(Qtt_Result,2));
   Card_SetRecto  (C,LastCardFree,TRUE);
   Card_SetMovable(C,LastCardFree,FALSE);
   Until Test_CardsLeft=TRUE;           {*Il y a au moins une carte jouable*}
End;

{****************************** !!! GAGNE !!! *******************************}

Function Win_TheGame:Byte;              {*Le jeu est gagn !*}
Var Num:Integer;
Begin
Inc(NbWin);                             {*1 partie de plus gagne*}
Play_WAV(Get_SystemPath(SP_SOUNDS)+'LAUGH.WAV');{*Play a WAV*}
If (Not Cheat) And (Nb_Columns=7) And (Nb_CardsPerCol=5) Then Inc(AThs[0]); {*Dans le THs*}
SAVE_THS;                               {*Save High-Scores*}

Num:=5;
Req_Dialog(App_Name+' '+App_Version,'!!! FELICITATIONS !!!||'+
           'VOUS AVEZ GAGNEZ CETTE PARTIE.|QUE DESIREZ-VOUS FAIRE?',' _REJOUER | _QUITTER ',Num);
Win_TheGame:=Num;
End;

{***************************** ON A PAS GAGNE *******************************}

Procedure End_TheGame;                  {*Termin mais pas gagn*}
Var Num:Integer;
Begin
Finished:=TRUE;
If CardsLeft=0 Then
   Begin
   Case Win_TheGame Of
     1: Begin
        INIT_GAME;                      {*Retire les cartes*}
        Win_Clip(On,W1);
        REDRAW_FRAME;                   {*Display Window Content*}
        Win_Clip(Off,W1);
        End;
     2: XOk:=TRUE;
     End;
   Exit;
   End;
Inc(NbGames);                           {*1 partie de plus*}
Play_WAV(Get_SystemPath(SP_SOUNDS)+'ERROR.WAV');{*Play a WAV*}
If CardsLeft<=20 Then
   If (Not Cheat) And (Nb_Columns=7) And (Nb_CardsPerCol=5) Then Inc(AThs[CardsLeft]); {*Dans le THs*}
SAVE_THS;                               {*Save High-Scores*}
Num:=4;
Req_Dialog(App_Name+' '+App_Version,'GAME OVER - '+Str_FillZero(CardsLeft,2)+' CARDS LEFT.','    _OK    ',Num);
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
Fade_WTitle:=FALSE;                     {*No title shade*}
If Gfx_Mode=12 Then MaxX:=624 Else MaxX:=780;

Win_Init(0,0,VESA_GetMaxX,VESA_GetMaxY,$50DB,App_Name+' '+App_Version,W1);
Win_Sup(0,20,MaxX,440,0,0,0,0,0,10,$00D0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

CALCULE_COLUMNS;                        {*Build Columns and Cards Positions*}
INIT_GAME;                              {*Tire les cartes*}

REDRAW_FRAME;                           {*Display Window Content*}
XOk:=No; XCancel:=No;                   {*Init Exit Flags*}
HasBeenClicked:=FALSE;
RMBClicked:=FALSE;                      {*RMB Not Clicked now*}

Repeat;
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If (Button_GetMsg(But1,1)) Then      {*DONE*}
      Begin
      If Kbd_TestSpecialKey($03,B_OR) Then Cheat:=TRUE Else Cheat:=FALSE;
      INIT_GAME;
      REDRAW_FRAME;
      End;
   If Button_GetMsg(But2,1) Then ;      {*BACK*}
   If Button_GetMsg(But3,1) Then        {*PARAMETERS*}
      Begin
      Mse_Hide;
      DoNotDisplayPioche;
      Mse_Show;
      If App_Parameters(100,100) Then INIT_GAME;
      REDRAW_FRAME;                     {*Display Window Content*}
      End;

   If Button_GetMsg(But4,1) Then Begin  {*Paramtrage du systme*}
      System_Request(120,100,'GOLF.INI');
      Redraw_Frame;
      End;

   If (CardsLeft-Qtt_Pioche=0) And (Qtt_Pioche>0) Then
      Begin                             {*On  gagn, mais il reste des carte sur la pioche*}
      Move_CardsFromPiocheToResults; Delay(100);
      End;

   If (CardsLeft=00) And (Not Finished) Then
      Begin                             {*Jeu Gagn !*}
      Finished:=TRUE;
      Case Win_TheGame Of
        1: Begin
           INIT_GAME;                   {*Retire les cartes*}
           REDRAW_FRAME;                {*Display Window Content*}
           End;
        2: XOk:=TRUE;
        End;
      End;

   If Not Mse_Clicked(3) Then RMBClicked:=FALSE;

   If (Button_GetMsg(BPioche,1)) Or ((Mse_Clicked(3)) And (Not RMBClicked)) Then Begin
      RMBClicked:=TRUE;
      Move_CardsFromPiocheToResults;
      If (Not Test_CardsLeft) And (Not Finished) And (Qtt_Pioche=0) Then End_TheGame;
      End;

   If (Not Mse_Clicked(1)) And (HasBeenClicked) Then HasBeenClicked:=FALSE;

   OnCard:=0;
   For A:=1 to C.Max_Cards do           {*Teste toutes les cartes*}
      Begin
      If (Card_TestMouseOver(C,A)) And (Card_GetRecto(C,A)) And (C.Cards[A].Movable) And
         (CARD_ISONTOP(A)) And (CARD_ISGOOD(A)) And (Not HasBeenClicked) Then
         Begin
         If Mse_Clicked(1) Then         {*Move Card from column...*}
            Begin
            HasBeenClicked:=TRUE;
            Move_CardsFromColumnsToResults(A);
{            If (Not Test_CardsLeft) And (Not Finished) And (Qtt_Pioche=0) Then Begin End_TheGame; DoIt:=FALSE; End;}
            OnCard:=-1;
            Break;                      {*On sort viril de la boucle !*}
            End Else OnCard:=A;
         End;
      End;

   If (ToggleCard) Then                 {*Toggle Cards*}
      Begin
      Win_Clip(On,W1);                  {*Clipping Window*}
      If (OnCard>0) And (PreselectedCard=0) Then Card_Toggle(C,OnCard);
      If (OnCard=0) And (PreselectedCard>0) Then Card_Toggle(C,PreselectedCard);
      If (OnCard>0) And (PreselectedCard>0) And (PreselectedCard<>OnCard) Then
         Begin
         Card_Toggle(C,PreselectedCard);
         Card_Toggle(C,OnCard);
         End;
      PreselectedCard:=OnCard;
      End;

   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then XCancel:=Yes;            {*Window Closed   => Exit*}
If Even=3 Then REDRAW_FRAME;            {*Window Extended => Display Content*}
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XOk) Or (XCancel);               {*Exit Flags*}

Win_Kill(W1);                           {*Close Window if Needs*}
Fade_WTitle:=TRUE;                      {*Set again title shade*}
End;

{****************************************************************************}

Begin
INIT_BASE;                              {*Initialise Hardware*}
INIT_SCREEN;                            {*Initialise Screen*}
INIT_MOUSE;                             {*Initialise Mouse*}

Oldexit:=ExitProc;                      {*Intercept Errors*}
SetJump(MyAddr);
ExitProc:=@ENTRY_INT24;

If Not Test_HigherVersion('v3.10') Then {*System too old !*}
   Begin
   NError:=685;
   Main_Task;
   Close_MOS;
   End;

INIT_APP;                               {*Make Initialisations*}
LOAD_PARAM;                             {*Load Parameters*}

If Gfx_Mode>=10 Then Main;              {*Call Programs Execution*}

RESTORE_APP;                            {*Restore Context*}
SAVE_PARAM;                             {*Save Parameters*}

DONE_MOUSE;                             {*Restore Mouse*}
DONE_SCREEN;                            {*Restore Screen*}
DONE_BASE;                              {*Restore Hardware*}
End.
