{$A-,B-,D-,E+,F-,I-,L-,N-,O-,R-,S-,V-}
{$M 16384,0,655360}

(*
	LiteComm-TP - LiteComm(tm) for Turbo Pascal
				  Copyright(c) 1987, 1988, 1989-Information Technology, Ltd.

	LCTKRNL.PAS - Kernel functions for LiteComm-TP
*)

unit LCTKRNL;

interface

uses
  DOS;

CONST
  PORTMASK = $000F;                  (* used in port validation *)

  DTR = $01;                         (* Data Terminal Ready *)
  RTS = $02;                         (* Request TO Send *)
  XON = $11;                         (* XON/XOFF characters *)
  XOFF = $13;

  OverRun = $02;                     (* Error Status Masks *)
  BadParity = $04;
  BadFrame = $08;
  BreakDet = $10;

  DeltaCTS = $01;                    (* Deltas = 1 IF bit changed *)
  DeltaDSR = $02;
  DeltaRI  = $04;
  DeltaDCD = $08;
  CTS = $10;                         (* Clear TO Send *)
  DSR = $20;                         (* Data Set Ready *)
  RI  = $40;                         (* Ring Indicator *)
  DCD = $80;                         (* Carrier Detect *)

TYPE
  BPtr = ^BYTE;
  CCB = RECORD                     (* Communications Control Block *)
    OldVector : POINTER;           (* save old interrupt vector *)
    BasePort  : WORD;              (* base 8250 port *)
    IntVec    : BYTE;              (* interrupt vector # for port *)
    IrqMask   : BYTE;              (* the IRQ mask for the port *)
    OldIrq    : BYTE;              (* previous mask *)
    MdmStat   : BYTE;              (* last modem status *)
    MdmCtl    : BYTE;              (* current mdm control value *)
    LastErr   : BYTE;              (* last detected error *)
    IntMask   : BYTE;              (* current int reg mask *)
    XState    : BOOLEAN;           (* TRUE IF auto XON/XOFF *)
    InXRecd   : BOOLEAN;           (* TRUE IF XOFF recd *)
    OutXSent  : BOOLEAN;           (* TRUE IF XOFF auto-sent *)
    BrkRecd   : BOOLEAN;           (* TRUE IF BREAK Detected *)
    TxReady   : BOOLEAN;           (* TRUE IF transmitter available *)
    InBuff    : BPtr;
    InBuffLen : INTEGER;           (* input buffer abs size *)
    InBuffCt  : INTEGER;           (* current # chars in input *)
    InBuffMk  : INTEGER;           (* high-water mark for auto XOFF *)
    InHead    : BPtr;
    InTail    : BPtr;
    InBuffEnd : BPtr;
    OutBuff    : BPtr;
    OutBuffLen : INTEGER;
    OutBuffCt  : INTEGER;
    OutHead    : BPtr;
    OutTail    : BPtr;
    OutBuffEnd : BPtr;
    SaveStk    : POINTER;
    NewStk     : POINTER;
  END;                               (* CCB *)

  CCBPTR = ^CCB;

VAR
{$F+}
  CPorts : ARRAY [0..14] of CCBPTR;
{$F-}

function PortChange(CPort:INTEGER; NewBase:WORD; NewIrq,NewVector:BYTE):BOOLEAN;

function CommSetup(CPort:INTEGER; Baud:WORD; Parity:char;
                   DataBits, StopBits:INTEGER):BOOLEAN;

function CommOpen(CPort:INTEGER; Baud:WORD; Parity:char; Databits, Stopbits,
                  InSize, OutSize:INTEGER; RaiseMdmCtl:BOOLEAN) : BOOLEAN;

PROCEDURE CommClose(CPort:INTEGER; DropMdmCtl:BOOLEAN);

PROCEDURE CommTx(Cptr:CCBPTR);

function SetModemSignals(CPort : INTEGER; NewSet : BYTE) : BOOLEAN;

function ClearModemSignals(CPort : INTEGER; NewSet : BYTE) : BOOLEAN;

function FlipModemSignals(CPort : INTEGER; NewSet : BYTE) : BOOLEAN;

function SendBreak(CPort : INTEGER) : BOOLEAN;

function ModemStatus(CPort : INTEGER) : BYTE;

function ErrorStatus(CPort : INTEGER) : BYTE;

function EnableXon(CPort:INTEGER; XonFlag:BOOLEAN) : BOOLEAN;

function XoffRecd(CPort:INTEGER) : BOOLEAN;

function XoffSent(CPort:INTEGER) : BOOLEAN;

function BreakRecd(CPort:INTEGER) : BOOLEAN;
