{ MNUGEN.PAS : Menu-program generator

  Title    : MNUGEN
  Version  : 6.0
  Date     : Nov 09, 1996
  Language : Borland Turbo Pascal v4.0+
  Author   : J.R. Ferguson
  Usage    : Refer procedure Help and file MNUGEN.DOC
}

program MnuGen(Txt, Prg);

uses DefLib, StpLib, ChrLib, ArgLib, CvtLib, ObtLib;

const
  ProgTitle  = 'MNUGEN';
  ProgVersion= '6.0';

  DflCursChr = '@';
  DflOpenChr = '<';
  DflClosChr = '>';
  DflCmndChr = '/';
  CmntCmd    = '*';
  AltrCmd    = 'A';
  CaseCmd    = 'C';
  WaitCmd    = 'W';
  ExitCmd    = 'E';
  LinLenPas  = 62;
  LinLenC    = 60;
  LinLendB3  = 70;
  LinLenA86  = 70;
  TxtExt     = '.TXT';
  PrgExtPas  = '.PAS';
  PrgExtC    = '.C';
  HdrExtC    = '.H';
  PrgExtdB3  = '.PRG';
  PrgExtA86  = '.ASM';
  MinOrd     = 0;
  MaxOrd     = 127;
  DflRow     = 23;
  DflCol     = 1;
  OptPascal  = 'P';
  OptC       = 'C';
  OptdBase3  = 'D';
  OptAsm8086 = 'A';
  OptUpper   = 'U';
  OptSwOn    = '+';
  OptSwOff   = '-';

  MnemTxt    = 'CR LF FF BS TABESCDELRET';
  MnemOrd    = '013010012008009027127013';

type
  CharOrd    = MinOrd..MaxOrd;
  OrdFlags   = array[CharOrd] of boolean;
  LangCode   = (Pascal, C, dBase3, A8086);
  SwitchTyp  = (Undefined, Neutral, Off, On);
  SearchTree = object(T_Obt_SearchTree)
                 Constructor Init;
                 procedure   FreeItem(V_Item: Pointer); virtual;
                 function    CanInsert(const s: StpTyp): boolean; virtual;
               end;

var
  Txt,
  Hdr,
  Prg        : text;
  Name,
  FileName,
  ProcName   : StpTyp;
  AllOk      : boolean;
  TargetLang : LangCode;
  UpperSw    : SwitchTyp;
  LineLen    : integer;
  PrgExt     : StpTyp;
  HdrExt     : StpTyp;
  CursChr    : char;
  OpenChr    : char;
  ClosChr    : char;
  CmndChr    : char;
  LineNum    : integer;
  CaseEntries: SearchTree;


procedure Help;
begin
  writeln('Usage: ',ProgTitle,' [[dn:]FileName] [/option [...]]');
  writeln('Options  P  : Target Language Pascal (default)');
  writeln('         A  : Target Language Intel 8086 Assembler');
  writeln('         C  : Target Language C');
  writeln('         D  : Target Language Dbase III');
  writeln('         U  : routine names unchanged');
  writeln('         U+ : routine names in upper case');
  writeln('         U- : routine names in lower case');
  AllOk:= false;
end;


procedure Warning(stg: StpTyp);
begin writeln('Row ',LineNum:2,': ',stg) end;

function CompareStp(p1,p2: Pointer): integer; far;
begin CompareStp:= StpCmp(StpPtr(p1)^,StpPtr(p2)^) end;

Constructor SearchTree.Init;
begin Inherited Init(CompareStp); end;

procedure SearchTree.FreeItem(V_Item: Pointer);
begin StpFree(StpPtr(V_Item)); end;

function  SearchTree.CanInsert(const s: StpTyp): boolean;
var p: StpPtr; ok: boolean;
begin
  p:= StpAlloc(s);
  ok:= Insert(p);
  if not ok then StpFree(p);
  CanInsert:= ok;
end;

procedure ParseOpt(arg: StpTyp);
begin
  StpDel(arg,1,1);
  StpUpp(arg);
  if      StpCmp(arg,OptPascal ) = 0 then TargetLang:= Pascal
  else if StpCmp(arg,OptC      ) = 0 then TargetLang:= C
  else if StpCmp(arg,OptdBase3 ) = 0 then TargetLang:= dBase3
  else if StpCmp(arg,OptAsm8086) = 0 then TargetLang:= A8086
  else if StpcGet(arg) = OptUpper then case StpcGet(arg) of
    OptSwOff : UpperSw:= Off;
    OptSwOn  : UpperSw:= On;
    else       UpperSw:= Neutral;
  end
  else Help;
end;


procedure ParseArgs;
var i: ArgInd;
begin
  TargetLang := Pascal;
  UpperSw  := Undefined;
  StpCreate(Name);
  i:= 0;
  while AllOk and (i < ArgC) do begin
    inc(i);
    case StpcRet(ArgV[i],1) of
      '/' : ParseOpt(ArgV[i]);
      else  if not StpEmpty(Name) then Help else StpCpy(Name,ArgV[i]);
    end;
  end;
  if UpperSw = Undefined then case TargetLang of
    Pascal    : UpperSw:= Neutral;
    C         : UpperSw:= Neutral;
    dBase3    : UpperSw:= Off;
    A8086     : UpperSw:= Off;
  end;
end;

procedure OpenFiles;
var ok, exist : boolean;
    p1,p2     : StpInd;
    fsp       : StpTyp;

  procedure ProcessName;
  begin
    p1:= StpcPos(Name,':'); p2:= StpcPos(Name,'.');
    if p2=0 then p2:= StpLen(Name) else p2:= p2-1;
    if p2-p1>8 then p2:= p1+8;
    StpNCpy(FileName,Name,p2); StpUpp(FileName);
    StpSub(ProcName,Name,p1+1,p2-p1);
    if UpperSw = On then StpUpp(ProcName) else StpLow(ProcName);
    StpCpy(fsp,FileName); StpCat(fsp,TxtExt);
    Assign(Txt,fsp); {$I-} reset(Txt) {$I+}; exist:= IOresult=0;
    if not exist then writeln(chr(AsciiBEL),'File ',fsp,' bestaat niet');
  end;

  procedure AskName;
  begin
    repeat
      write('Name : '); readln(Name); ok:= not StpEmpty(Name);
      if ok then ProcessName;
    until exist or not ok
  end;

  function OpenOut(var F: text; ext: StpTyp): boolean;
  begin
    StpCpy(fsp,FileName); StpCat(fsp,ext); write(fsp);
    Assign(F,fsp); {$I-} rewrite(F) {$I+};
    if IOresult <> 0 then begin
      writeln;
      writeln(chr(AsciiBEL),'Cannot open file ',fsp);
      OpenOut:= false;
    end
    else OpenOut:= true;
  end;

begin {OpenFiles}
  ok:= true;
  if StpEmpty(Name) then AskName else begin ProcessName; ok:= exist end;
  if ok then begin
    case TargetLang of
      Pascal  : begin PrgExt:= PrgExtPas; LineLen:= LinLenPas; end;
      C       : begin PrgExt:= PrgExtC;   LineLen:= LinLenC  ;
                      HdrExt:= HdrExtC;
                end;
      dBase3  : begin PrgExt:= PrgExtdB3; LineLen:= LinLendB3; end;
      A8086   : begin PrgExt:= PrgExtA86; LineLen:= LinLenA86; end;
    end;
    write(fsp,' --> '); ok:= OpenOut(Prg,PrgExt);
    if ok and (TargetLang = C) then begin
      write(' , '); ok:= OpenOut(Hdr,HdrExt);
    end;
    if ok then writeln;
  end;
  AllOk:= ok;
end;


procedure CloseFiles;
begin close(Txt); close(Prg); if TargetLang=C then close(Hdr); end;


procedure MakeProc;
const
  Tab       = #009;
var
  CurRow, r : integer;
  CurCol    : StpInd;
  Lin       : StpTyp;
  CaseStp   : StpTyp;
  MenuExit,
  TvCases   : boolean;
  State     : (MenuData, CaseData);
  OptFlag   : OrdFlags;
  Options   : StpTyp;
  CaseCnt   : integer;

  procedure WriteHeader;
  begin case TargetLang of
    Pascal :
      begin
        writeln(Prg,'{ ',FileName,PrgExt,' }');
        writeln(Prg,'');
        writeln(Prg,'procedure ',ProcName,';');
        writeln(Prg,'var c     : char;');
        writeln(Prg,'    ok, ex: boolean;');
        writeln(Prg,'begin');
        writeln(Prg,'  ex:= false;');
        writeln(Prg,'  repeat');
        writeln(Prg,'    ClrScr;')
      end;
    C :
      begin
        writeln(Hdr,'/* ',FileName,HdrExt,' */');
        writeln(Hdr,'void ',ProcName,'(void);');
        writeln(Prg,'/* ',FileName,PrgExt,' */');
        writeln(Prg,'#include <conio.h>');
        writeln(Prg,'#include <ctype.h>');
        writeln(Prg,'#ifdef _Windows');
        writeln(Prg,'  #include <stdio.h>');
        writeln(Prg,'  #define cprintf printf');
        writeln(Prg,'  #define nl()    printf("\n")');
        writeln(Prg,'  #define wcr()   {printf(" CR:");while(getch()!=''\r'');}');
        writeln(Prg,'#else');
        writeln(Prg,'  #define nl()    cprintf("\r\n")');
        writeln(Prg,'  #define wcr()   {cprintf(" CR:");while(getch()!=''\r'');}');
        writeln(Prg,'#endif');
        writeln(Prg,'#include "',FileName,HdrExt,'"');
        writeln(Prg,'');
        writeln(Prg,'void ',ProcName,'(void)');
        writeln(Prg,'{ int c;');
        writeln(Prg,'  int ok;');
        writeln(Prg,'  int ex = 0;');
        writeln(Prg,'');
        writeln(Prg,'  do {');
        writeln(Prg,'    clrscr();')
      end;
    dBase3 :
      begin
        writeln(Prg,'* ',FileName,PrgExt);
        writeln(Prg,'private all');
        writeln(Prg,'');
        writeln(Prg,'store .F. to ex');
        writeln(Prg,'do while .not. ex');
        writeln(Prg,'  clear')
      end;
    A8086 :
      begin
        writeln(Prg,'; ',FileName,PrgExt);
        writeln(Prg,'');
        writeln(Prg,'        ideal');
	writeln(Prg,'        model   small');
        writeln(Prg,'');
        writeln(Prg,'_bs     equ     08h     ;backspace');
        writeln(Prg,'_cr     equ     0dh     ;carriage return');
        writeln(Prg,'');
        writeln(Prg,'        dataseg');
        writeln(Prg,'');
        writeln(Prg,'        %trunc');
        writeln(Prg,'label _mnutxt byte');
      end;
    end;
  end;

  procedure WriteFullLine(stg: StpTyp);
  begin case TargetLang of
    Pascal : writeln(Prg,'    writeln(''',stg,''');');
    C      : if StpEmpty(stg) then
               writeln(Prg,'    nl();')
             else
               writeln(Prg,'    cprintf("',stg,'"); nl();');
    dBase3 : writeln(Prg,'  ? "',stg,'"');
    A8086  : begin
               write  (Prg,'db ');
               if not StpEmpty(stg) then
                 write(Prg,'''',stg,''',');
               writeln(Prg,'_cr');
             end;
  end end;

  procedure WriteLineStart(stg: StpTyp);
  begin case TargetLang of
    Pascal : writeln(Prg,'    write(''',stg,''');');
    C      : writeln(Prg,'    cprintf("',stg,'");');
    dBase3 : writeln(Prg,'  ? "',stg,'"');
    A8086  : if not StpEmpty(stg) then
               writeln(Prg,'db ''',stg,'''');
  end end;

  procedure WriteLineContinuation(stg: StpTyp);
  begin case TargetLang of
    Pascal : writeln(Prg,'    write(''',stg,''');');
    C      : writeln(Prg,'    cprintf("',stg,'");');
    dBase3 : writeln(Prg,'  ?? "',stg,'"');
    A8086  : if not StpEmpty(stg) then
               writeln(Prg,'db ''',stg,'''');
  end end;

  procedure WriteLineEnd(stg: StpTyp);
  begin case TargetLang of
    Pascal : writeln(Prg,'    writeln(''',stg,''');');
    C      : if StpEmpty(stg) then
               writeln(Prg,'    nl();')
             else
               writeln(Prg,'    cprintf("',stg,'"); nl();');
    dBase3 : writeln(Prg,'  ?? "',stg,'"');
    A8086  : begin
               write  (Prg,'db ');
               if not StpEmpty(stg) then
                 write(Prg,'''',stg,''',');
               writeln(Prg,'_cr');
             end;
  end end;

  procedure WriteTransition;
  begin
    case TargetLang of
    Pascal :
      begin
        writeln(Prg,'    SetCur(',CurRow,',',CurCol,');');
        writeln(Prg,'    repeat');
        writeln(Prg,'      ok:= true;');
        writeln(Prg,'      c:= UppKey;');
        writeln(Prg,'      if IsPrint(c) then begin; write(c); ' +
                           'SetCur(',CurRow,',',CurCol,') end;');
        writeln(Prg,'      case ord(c) of');
      end;
    C :
      begin
        writeln(Prg,'    gotoxy(',CurCol,',',CurRow,');');
        writeln(Prg,'    do {');
        writeln(Prg,'      ok = 1;');
        writeln(Prg,'      c = toupper(getch());');
        writeln(Prg,'      if (isprint(c)) { putch(c); ' +
                           'gotoxy(',CurCol,',',CurRow,'); }');
        writeln(Prg,'      switch (c) {');
      end;
    dBase3 :
      begin
        writeln(Prg,'  store .F. to ok');
        writeln(Prg,'  do while .not. ok');
        writeln(Prg,'    store " " to c');
        writeln(Prg,'    @ ',CurRow,',',CurCol-1,' get c picture "!"');
        writeln(Prg,'    read');
        writeln(Prg,'    store .T. to ok');
        writeln(Prg,'    do case');
      end;
    A8086 :
      begin
        writeln(Prg,'db 0');
        writeln(Prg,'        %notrunc');
        writeln(Prg,'');
        writeln(Prg,'_row    equ     ',CurRow);
        writeln(Prg,'_col    equ     ',CurCol);
        writeln(Prg,'');
        writeln(Prg,'        codeseg');
	writeln(Prg,'');
	writeln(Prg,'        extrn   Mnu_ClrScr      :proc');
	writeln(Prg,'        extrn   Mnu_SetCur      :proc');
	writeln(Prg,'        extrn   Mnu_PutChr      :proc');
	writeln(Prg,'        extrn   Mnu_PutTxt      :proc');
	writeln(Prg,'        extrn   Mnu_GetChr      :proc');
	writeln(Prg,'        extrn   Mnu_GetChrEch   :proc');
	writeln(Prg,'        extrn   Mnu_WaitCR      :proc');
        writeln(Prg,'');
        writeln(Prg,'public  ',ProcName);
        writeln(Prg,'proc    ',ProcName);
        writeln(Prg,'');
        writeln(Prg,'        jmp     short _menu');
	writeln(Prg,'_wait:  call    Mnu_WaitCR      ;wait for CR');
	writeln(Prg,'_menu:  call    Mnu_ClrScr      ;clear screen');
        writeln(Prg,'        mov     si,offset _mnutxt');
	writeln(Prg,'        call    Mnu_PutTxt      ;display menu');
        writeln(Prg,'        mov     dh,_row-1       ;set cursor');
        writeln(Prg,'        mov     dl,_col-1');
        writeln(Prg,'        call    Mnu_SetCur');
	writeln(Prg,'_rdkey: call    Mnu_GetChrEch   ;read key & echo');
	writeln(Prg,'');
      end;
    end;
  end;

  procedure WriteTail;
  begin
    case TargetLang of
    Pascal :
      begin
        writeln(Prg,'        else begin');
        writeln(Prg,'               write('' '',chr(8)); ok:= false;');
        writeln(Prg,'             end;');
        writeln(Prg,'      end');
        writeln(Prg,'    until ok;');
        writeln(Prg,'  until ex;');
        writeln(Prg,'end;')
      end;
    C :
      begin
        writeln(Prg,'        default : putch('' ''); ' +
                    'gotoxy(',CurCol,',',CurRow,'); '  +
                    'ok = 0; break;');
        writeln(Prg,'      }');
        writeln(Prg,'    } while (ok == 0);');
        writeln(Prg,'  } while (ex == 0);');
        writeln(Prg,'}')
      end;
    dBase3 :
      begin
        writeln(Prg,'      otherwise');
        writeln(Prg,'        store .F. to ok');
        writeln(Prg,'    endcase');
        writeln(Prg,'  enddo');
        writeln(Prg,'enddo');
        writeln(Prg,'');
        writeln(Prg,'return');
      end;
    A8086 :
      begin
        writeln(Prg,'_case',CaseCnt,':');
	writeln(Prg,'        mov     al,'' ''          ;undefined key');
	writeln(Prg,'        call    Mnu_PutChr      ;clear choice');
        writeln(Prg,'        mov     al,_bs');
        writeln(Prg,'        call    Mnu_PutChr');
        writeln(Prg,'        jmp     _rdkey          ;get new key');
        writeln(Prg,'_exit:  ret');
        writeln(Prg,'');
        writeln(Prg,'endp');
        writeln(Prg,'');
        writeln(Prg,'        end');
      end;
    end;
  end;

  procedure WriteCaseHeader(n: CharOrd);
  begin case TargetLang of
    Pascal : write  (Prg,'        ',n:3,': ');
    C      : write  (Prg,'        case ',n:3,': ');
    dBase3 : writeln(Prg,'      case asc(c)=',n:3);
    A8086  : begin
               writeln(Prg,'_case',CaseCnt,':');
               Inc(CaseCnt);
               writeln(Prg,'        cmp     al,',n);
               writeln(Prg,'        jne     _case',CaseCnt);
             end;
  end end;

  procedure WriteCaseEntry(stg: StpTyp);
  begin
    case UpperSw of
      Undefined,
      Neutral   : { no change };
      Off       : StpLow(stg);
      On        : StpUpp(stg);
    end;
    case TargetLang of
      Pascal : writeln(Prg,stg,';');
      C      : begin
                 if CaseEntries.CanInsert(stg) then
                   writeln(Hdr,'void ',stg,'(void);');
                 writeln(Prg,stg,'(); break;');
               end;
      dBase3 : writeln(Prg,'        do ',stg);
      A8086  : begin
                 writeln(Prg,'        extrn   ',stg,':proc');
                 writeln(Prg,'        call    ',stg);
                 writeln(Prg,'        jmp     _menu');
               end;
    end;
  end;

  procedure WriteCaseEntryWait(stg: StpTyp);
  begin
    case UpperSw of
      Undefined,
      Neutral   : { no change };
      Off       : StpLow(stg);
      On        : StpUpp(stg);
    end;
    case TargetLang of
      Pascal : writeln(Prg,'begin ',stg,'; WaitCR end;');
      C      : begin
                 if CaseEntries.CanInsert(stg) then
                   writeln(Hdr,'void ',stg,'(void);');
                 writeln(Prg,stg,'(); wcr(); break;');
               end;
      dBase3 : begin
                 writeln(Prg,'        do ',stg);
                 writeln(Prg,'        accept " CR:" to dummy');
               end;
      A8086  : begin
                 writeln(Prg,'        extrn   ',stg,':proc');
                 writeln(Prg,'        call    ',stg);
                 writeln(Prg,'        jmp     _wait');
               end;
    end;
  end;

  procedure WriteCaseExit;
  begin case TargetLang of
    Pascal : writeln(Prg,'ex:= true;');
    C      : writeln(Prg,'ex = 1; break;');
    dBase3 : writeln(Prg,'        store .T. to ex');
    A8086  : writeln(Prg,'        jmp     _exit');
  end end;

  procedure AddChr(c: char);
  var charstr: StpTyp;
  begin
    if OptFlag[ord(c)] then begin
      if IsPrint(c) then
        charstr:= ''''+c+''''
      else begin
        ItoABL(ord(c),charstr,16,2); charstr:= charstr + 'h';
      end;
      Warning('Duplicate option ' + charstr);
    end;
    OptFlag[ord(c)]:= true;
    StpcCat(Options,c)
  end;

  procedure AddMnem(mnem: StpTyp);
  var i : StpInd;
      w : StpTyp;
  begin
    i:= StpPos(mnemTxt,mnem);
    if i>0 then begin StpSub(w,mnemord,i,3); AddChr(chr(AtoIB(w,10))) end
  end;

  procedure ReadCursor;
  var i,j: StpInd;
  begin
    i:= StpcPos(Lin,CursChr); j:= StpPos(Lin,OpenChr+CursChr+ClosChr);
    if (i>0) and not ((j>0) and (j=i-1)) then begin
      CurCol:= i; CurRow:= r; Lin[i]:= ' '
    end
  end;

  procedure ReadOption;
  var   Tmp,Option : StpTyp;
        i          : StpInd;
  begin
    StpCpy(Tmp,Lin);
    i:= StpcPos(Lin,OpenChr);
    while i>0 do begin
      StpDel(Tmp,1,i);
      i:= StpcPos(Tmp,ClosChr);
      if i>0 then begin
        i:= i-1; StpNCpy(Option,Tmp,i); StpDel(Tmp,1,i+1);
        if i<=3 then case i of
          0   : {nothing};
          1   : AddChr(StpcRet(Option,1));
          2,3 : AddMnem(Option)
        end
      end;
      i:= StpcPos(Tmp,OpenChr);
    end
  end;

  procedure ReadCase;
    var wrd: StpTyp; i: StpInd;
    begin
      if StpEmpty(Options) then begin
        Warning('Too many cases');
        TvCases:= true
      end
      else begin
        i:= StpcPos(Lin,',');
        if i=0 then begin StpCpy(CaseStp,Lin); StpDel(Lin,1,MaxStp) end
               else begin StpSub(CaseStp,Lin,1,i-1); StpDel(Lin,1,i) end;
        StpRLS(CaseStp); StpRTS(CaseStp);
        WriteCaseHeader(ord(StpcRet(Options,1)));
        StpDel(Options,1,1);
        if StpUppNCmp(CaseStp,CmndChr+ExitCmd,2) = 0 then begin
          WriteCaseExit; MenuExit:= true
        end
        else begin
          StpRight(wrd,CaseStp,2);
          if StpUppCmp(wrd,CmndChr+WaitCmd) = 0 then begin
            StpDel(CaseStp,StpLen(CaseStp)-1,2); StpRTS(CaseStp);
            WriteCaseEntryWait(CaseStp);
          end
          else WriteCaseEntry(CaseStp);
        end
      end
    end;

  function Alter(c1,c2: char): boolean;
  var ok: boolean;
  begin
    ok:= true;
    if not IsGraph(c2) then ok:= false
    else begin
      if      c1 = CursChr then CursChr:= c2
      else if c1 = OpenChr then OpenChr:= c2
      else if c1 = ClosChr then ClosChr:= c2
      else if c1 = CmndChr then CmndChr:= c2
      else ok:= false;
    end;
    Alter:= ok;
  end;

  function GlobalCommand: boolean;
  var ok: boolean;
  begin
    ok:= false;
    if StpcRet(Lin,1) = CmndChr then begin
      if      ToUpper(StpcRet(Lin,2)) = CmntCmd then ok:= true
      else if ToUpper(StpcRet(Lin,2)) = AltrCmd then begin
        if Alter(StpcRet(Lin,3),StpcRet(Lin,4)) then ok:= true
	else Warning('Error in Alter command');
      end
      else if ToUpper(StpcRet(Lin,2)) = CaseCmd then begin
        State:= CaseData;
        if StpEmpty(Options) then Warning('No options');
        WriteTransition;
        ok:= true;
      end
    end;
    GlobalCommand:= ok;
  end;

  procedure ProcessLine(Lin: StpTyp);
  var Tmp: StpTyp;
  begin
    StpRTS(Lin);
    if StpLen(Lin) <= LineLen then WriteFullLine(Lin)
    else begin
      StpNCpy(Tmp,Lin,LineLen); StpDel(Lin,1,LineLen);
      WriteLineStart(Tmp);
      while StpLen(Lin) > LineLen do begin
        StpNCpy(Tmp,Lin,LineLen); StpDel(Lin,1,LineLen);
        WriteLineContinuation(Tmp);
      end;
      WriteLineEnd(Lin);
    end;
  end;

  procedure MakeProcInit;
  var n: CharOrd;
  begin
    CaseEntries.Init;
    StpCreate(Options);
    for n:= MinOrd to MaxOrd do OptFlag[n]:= false;
    State := MenuData;
    TvCases  := false;
    MenuExit := false;
    CurRow   := DflRow;
    CurCol   := DflCol;
    r        := 0;
    CaseCnt  := 1;
    LineNum  := 0;
  end;

  procedure MakeProcTerm;
  begin
    WriteTail;
    CaseEntries.Done;
  end;

  begin { MakeProc }
    MakeProcInit;
    WriteHeader;
    while not eof(Txt) do begin
      readln (Txt,Lin); StpDetab(Lin,Lin,8); LineNum:= LineNum+1;
      if not GlobalCommand then begin
        r:= r+1;
        case State of
          MenuData : begin ReadCursor; ReadOption; ProcessLine(Lin) end;
          CaseData : while not (StpEmpty(Lin) or TvCases) do ReadCase;
        end
      end
    end;
    if not MenuExit then Warning('Geen EXIT');
    if not StpEmpty(Options) then begin
      Warning('Not enough cases');
      while not StpEmpty(Options) do begin
        WriteCaseHeader(ord(StpcRet(Options,1))); WriteCaseEntry('');
        StpDel(Options,1,1);
      end;
    end;
    MakeProcTerm;
  end;


procedure MainInit;
begin
  writeln;
  writeln(ProgTitle,' v',ProgVersion,' -- Menu-program generator');
  AllOk  := true;
  CursChr:= DflCursChr;
  OpenChr:= DflOpenChr;
  ClosChr:= DflClosChr;
  CmndChr:= DflCmndChr;
  GetArgs; ParseArgs;
  if AllOk then OpenFiles;
end;


procedure MainTerm;
begin
  if AllOk then CloseFiles;
end;


begin { program }
  MainInit;
  if AllOk then MakeProc;
  MainTerm;
end.
