{ RRGTST.PAS : Test RRGLIB unit

  Title   : RRGTST
  Version : 4.1
  Date    : Nov 26, 1996
  Author  : J R Ferguson
  Language: Borland Turbo Pascal 4.0 through 7.0 (all targets)
  Usage   : Test Program
}

PROGRAM RRGTST;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  RrgLib, ConLib, ChrLib;

var
  r1, r2  : RrgTyp;
  lb,hb,i : real;
  li,hi   : boolean;

procedure WrLn2; begin writeln; writeln end;

procedure DisplayRange(r: RrgTyp);
begin
  if r<>nil then with r^ do begin
    if li then write('[ ') else write('< ');
    write(lb,' , ',hb);
    if hi then write(' ]') else write(' >');
    if nxt<>nil then begin
      writeln; write('  U  ');
      DisplayRange(nxt);
    end;
  end;
end;

procedure DisplayRange1;
begin
  write('r1 : '); DisplayRange(r1); writeln;
end;

procedure DisplayRange2;
begin
  write('r2 : '); DisplayRange(r2); writeln;
end;

procedure DisplayRanges;
begin
  DisplayRange1;
  DisplayRange2;
end;

procedure ReadLH;
var c: char;
begin
 write('lb (real) ='); readln(lb);
 write('li (0/1)  ='); readln(c); li:= c='1';
 write('hb (real) ='); readln(hb);
 write('hi (0/1)  ='); readln(c); hi:= c='1';
end;

procedure ReadI;
begin
  write('i='); readln(i);
end;


{--- Main line ---}

procedure xInside;
begin
  WrLn2;
  DisplayRange1;
  ReadI;
  writeln('RrgInside=',RrgInside(r1,i));
  WrLn2;
end;

procedure xInsert;
begin
  WrLn2;
  DisplayRange1;
  ReadLH;
  RrgInsert(r1,lb,li,hb,hi);
  DisplayRange1;
end;

procedure xDelete;
begin
  WrLn2;
  DisplayRange1;
  ReadLH;
  RrgDelete(r1,lb,li,hb,hi);
  DisplayRange1;
end;

procedure xMerge;
begin
  WrLn2;
  DisplayRanges;
  RrgMerge(r1,r2);
  DisplayRanges;
end;

procedure xRemove;
begin
  WrLn2;
  DisplayRanges;
  RrgRemove(r1,r2);
  DisplayRanges;
end;

procedure xClear;
begin
  WrLn2;
  DisplayRange1;
  RrgClear(r1);
  DisplayRange1;
end;

procedure xEmpty;
begin
  WrLn2;
  DisplayRange1;
  writeln('RrgEmpty = ',RrgEmpty(r1));
end;

procedure xCopy;
begin
  WrLn2;
  DisplayRanges;
  RrgDispose(r2);
  RrgCopy(r2,r1);
  DisplayRanges;
end;

procedure xInvert;
begin
  WrLn2;
  DisplayRange1;
  RrgInvert(r1);
  DisplayRange1;
end;

procedure xIntersect;
var t: RrgTyp;
begin
  WrLn2;
  DisplayRanges;
  RrgIntersect(t,r1,r2);
  write('===> '); DisplayRange(t);
end;

procedure xUnite;
var t: RrgTyp;
begin
  WrLn2;
  DisplayRanges;
  RrgUnite(t,r1,r2);
  write('===> '); DisplayRange(t);
end;

procedure xDisplay;
begin
  WrLn2;
  DisplayRanges;
  writeln;
end;


procedure xSwap;
var r: RrgTyp;
begin
  WrLn2;
  DisplayRanges;
  r:= r1; r1:= r2; r2:= r;
  DisplayRanges;
end;


{$I RRGTSTM.PAS}


procedure MainInit;
begin
  RrgCreate(r1);
  RrgCreate(r2);
end;


procedure MainExit;
begin
  RrgDispose(r1);
  RrgDispose(r2);
end;


begin { Main program }
  MainInit;
  rrgtstm;
  MainExit;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit'); writeln
{$ENDIF}
end.
