{ OBTTST.PAS - Test ObtLib Unit

  Title    : OBTTST
  Version  : 2.2
  Date     : Nov 11,1996
  Author   : J R Ferguson
  Language : Borland Pascal v7.0 (all targets)
  Usage    : Test program
}

PROGRAM ObtTst;

Uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  ObjLib, ObtLib, DefLib, ConLib, ChrLib;

const
  MaxItem      = 10;

type
  P_TestItem   = ^T_TestItem;
  P_Tree       = ^T_Tree;
  P_SearchTree = ^T_SearchTree;

  T_TestItem   = record data: char; end;

  T_Tree       = Object(T_OBT_Tree)
    procedure  FreeItem(V_Item: Pointer); virtual;
  end;

  T_SearchTree = Object(T_OBT_SearchTree)
    procedure  FreeItem(V_Item: Pointer); virtual;
  end;

var
  TestArray  : array[1..MaxItem] of T_TestItem;
  TestItem   : T_TestItem;
  Tree       : P_Tree;
  SearchTree : P_SearchTree;

procedure T_Tree.FreeItem(V_Item: Pointer);
begin if V_Item <> nil then dispose(P_TestItem(V_Item)); end;

procedure T_SearchTree.FreeItem(V_Item: Pointer);
begin if V_Item <> nil then dispose(P_TestItem(V_Item)); end;

function Compare(p1,p2: Pointer): integer; far;
begin Compare:= ord(P_TestItem(p1)^.data) - ord(P_TestItem(p2)^.data); end;

procedure wrln; begin writeln; end;
procedure wrl2; begin writeln; writeln; end;

procedure Display(p: Pointer); far;
begin with P_TestItem(p)^ do write(data:2); end;

procedure WrItem(p: P_TestItem);
begin
  if p=nil then writeln('not found') else begin
    write('Item ='); Display(p); writeln('  OK');
  end;
end;

procedure RdItem;
begin write('Item : '); readln(TestItem.data); end;

procedure DisplayTree(V_Tree: P_OBT_Tree); far;
type T_Parent = (none,left,right);
  procedure DisplaySubTree(p:P_Obt_Node; parent:T_Parent; level:integer);
  begin if p <> nil then begin
    DisplaySubTree(p^.Next,right,succ(level));
    write('':2* level);
    case parent of
      none : write('-');
      left : write('\');
      right: write('/');
    end;
    Display(p^.Item); wrln;
    DisplaySubTree(p^.Prev,left,succ(level));
  end end;
begin DisplaySubTree(V_Tree^.Root,none,0); end;

procedure NewData;
var i: 1..MaxItem;
begin
  Randomize;
  for i:= 1 to MaxItem do with TestArray[i] do begin
    data:= chr(ord('a') + Random(26));
  end;
end;

procedure DisplayData;
var i: 1..MaxItem;
begin wrl2; for i:= 1 to MaxItem do Display(@TestArray[i]); wrln; end;

procedure TreeGeneral(V_Tree: P_OBT_Tree);
var i: 1..MaxItem;
begin
  wrl2; DisplayTree(V_Tree);
  wrln; write('PreOrder :'); V_Tree^.PreOrder(Display);
  wrln; write('InOrder  :'); V_Tree^.InOrder(Display);
  wrln; write('PostOrder:'); V_Tree^.PostOrder(Display);
  wrln;
end;

procedure WrEmpty(V_Tree: P_OBT_Tree);
begin writeln('Empty = ',V_Tree^.Empty); end;

procedure FillTree(V_Tree: P_OBT_Tree);
var i: 1..MaxItem; item: P_TestItem;
begin
  V_Tree^.DeleteAll;
  for i:= 1 to MaxItem do begin
    new(item); item^:= TestArray[i];
    V_Tree^.Insert(item);
  end;
end;

procedure TestTree(V_Tree: P_OBT_Tree);
var i: 1..MaxItem;
begin
  wrl2; write('Insert   :');
  for i:= 1 to MaxItem do Display(@TestArray[i]);
  FillTree(V_Tree);
  TreeGeneral(V_Tree);
end;

procedure xNewData;
begin NewData; DisplayData; end;

procedure xTree;
begin
  New(Tree,Init(Compare));
  TestTree(Tree);
  Dispose(Tree,Done);
end;

procedure xSTGeneral;
begin
  New(SearchTree,Init(Compare));
  TestTree(SearchTree);
  Dispose(SearchTree,Done);
end;

procedure xSTNewTree;
begin
  Dispose(SearchTree,Done);
  New(SearchTree,Init(Compare));
  wrl2; WrEmpty(SearchTree);
end;

procedure xSTNewData;
begin
  NewData;
  Dispose(SearchTree,Done);
  New(SearchTree,Init(Compare));
  TestTree(SearchTree);
end;

procedure xSTSearch;
var p: P_TestItem;
begin
  wrl2; DisplayTree(SearchTree);
  wrln; RdItem;
  p:= SearchTree^.Search(@TestItem);
  WrItem(p);
end;

procedure xSTInsert;
var item: P_TestItem;
begin
  wrl2; DisplayTree(SearchTree);
  wrln; RdItem; new(item); item^:= TestItem;
  if SearchTree^.Insert(item)
    then begin DisplayTree(SearchTree); WrEmpty(SearchTree); end
    else begin writeln('already exists'); dispose(item); end;
end;

procedure xSTDisplay;
begin
  TreeGeneral(SearchTree);
  WrEmpty(SearchTree);
end;

procedure xSTDelete;
begin
  wrl2; DisplayTree(SearchTree);
  wrln; RdItem;
  if SearchTree^.Delete(@TestItem)
    then begin DisplayTree(SearchTree); WrEmpty(SearchTree); end
    else writeln('not found');
end;

{$I OBTTSTM1.PAS}

procedure xSTOther;
begin
  New(SearchTree,Init(Compare));
  FillTree(SearchTree);
  obttstm1;
  Dispose(SearchTree,Done);
end;

{$I OBTTSTM.PAS}

BEGIN
  NewData;
  obttstm;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit'); writeln;
{$ENDIF}
END.
