{ MATTST.PAS : Test on MatLib and MatIo

  title   : MATTST
  version : 4.0
  date    : May 15,1994
  author  : J R Ferguson
  language: Turbo Pascal v4.0 through v7.0 (all Targets)
  usage   : program
}


program MatTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  MatLib, MatIo, ConLib;

var A,B,C,D : MatTyp;

procedure AskDimension(var n,m: MatInd);
begin
  MatReadIndex('number of rows    = ',n);
  MatReadIndex('number of columns = ',m);
end;

procedure Lees2Mat(var A,B: MatTyp);
begin
  writeln('First matrix:'); MatRead(A);
  writeln('Second matrix:'); MatRead(B);
end;

procedure WriteResult(var result: MatTyp);
begin writeln('Result:'); MatWrite(result); end;

procedure xSetElmWidth;
var w: integer;
begin
  write('Matrix element display width : '); readln(w);
  MatSetElmWidth(w);
  write('Matrix element display format: '); MatWriteElm(-1.0);
  writeln;
end;

procedure xZero;
var n,m: MatInd;
begin
  writeln('MatZero');
  AskDimension(n,m); MatDim(A,n,m); MatZero(A); MatWrite(A);
end;

procedure xUnify;
var n,m: MatInd;
begin
  writeln('MatUnify');
  AskDimension(n,m); MatDim(A,n,m); MatUnify(A); MatWrite(A);
end;

procedure xSum;
begin
  writeln('MatAdd');
  Lees2Mat(A,B); MatAdd(A,B,C); WriteResult(C);
end;

procedure xSubtract;
begin
  writeln('MatSubtract');
  Lees2Mat(A,B); MatSubtract(A,B,C); WriteResult(C);
end;

procedure xScalarProd;
var fact: MatElmTyp;
begin
  writeln('MatScalarProd');
  writeln('Matrix:'); MatRead(A);
  write  ('Factor: '); readln(fact);
  MatScalarProd(fact,A,B); WriteResult(B);
end;

procedure xMatrixProd;
begin
  writeln('MatMatrixProd');
  Lees2Mat(A,B); MatMatrixProd(A,B,C); WriteResult(C);
end;

procedure xTranspose;
begin
  writeln('MatTranspose');
  writeln('Matrix:'); MatRead(A);
  MatTranspose(A,B); WriteResult(B);
end;

procedure xPower;
var exp: integer;
begin
  writeln('MatPower');
  writeln('Matrix:'); MatRead(A);
  write  ('Exponent: '); readln(exp);
  MatPower(A,exp,B); WriteResult(B);
end;

procedure xSsq;
var result: MatElmTyp;
begin
  writeln('Sum of squares');
  MatRead(A);
  MatSsq(A,result);
  writeln('Result : ',result)
end;

procedure xInvert;
var singular: boolean;
begin
  writeln('MatInvert');
  writeln('Matrix:'); MatRead(A);
  MatInvert(A,B,singular);
  if singular then writeln('singular') else WriteResult(B);
end;

procedure xDet;
var d: MatElmTyp;
begin
  writeln('MatDet');
  writeln('Matrix:'); MatRead(A);
  MatDet(A,d);
  writeln('Determinant: ',d);
end;

procedure xSolve;
var n: integer; singular: boolean;
begin
  writeln('Set of lineair equations Ax=b'); writeln;
  writeln('Coefficient matrix A :'); MatRead(A);
  writeln('Constants vector b :'); MatRead(B);
  MatSolve(A,B,C,singular);
  if singular then writeln('no solution')
  else begin writeln('Solution vector X:'); MatWrite(C) end
end;

procedure Menu(var choice: char);
const CTRLC = 3;
begin
  clrscr;
  writeln('Test on MatLib and MatIo');
  writeln('Max row/column : ',MatMAX);
  writeln;
  writeln('A = SetElmWidth');
  writeln('B = Zero');
  writeln('C = Unify');
  writeln('D = Add');
  writeln('E = Subtract');
  writeln('F = ScalarProd');
  writeln('G = MatrixProd');
  writeln('H = Transpose');
  writeln('I = Power');
  writeln('J = Ssq');
  writeln('K = Invert');
  writeln('L = Determinant');
  writeln('M = Solve');
  writeln('X = exit');
  writeln;
  write('Your choice : ');
  repeat choice:= UppKey
  until (choice=chr(CTRLC)) or (choice in ['A'..'M','X']);
  if choice=chr(CTRLC) then exit;
  ClrScr;
end;

procedure DoTest;
var choice: char;
begin
  repeat
    ClrScr;
    Menu(choice);
    ClrScr;
    case choice of
      'A': xSetElmWidth;
      'B': xZero;
      'C': xUnify;
      'D': xSum;
      'E': xSubtract;
      'F': xScalarProd;
      'G': xMatrixProd;
      'H': xTranspose;
      'I': xPower;
      'J': xSsq;
      'K': xInvert;
      'L': xDet;
      'M': xSolve;
      'X': ; { nothing }
    end;
    if choice <> 'X' then begin
      writeln('Error message: "',MatErrMsg[MatError],'"');
      WaitCr;
    end;
  until choice = 'X';
end;

begin
  DoTest;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit'); writeln;
{$ENDIF}
end.
