
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

Unit GVLight;

{$A+,B-,F+,G+,I-,O+,P-,Q-,R-,S-,T-,V+,X+}

Interface

Uses Drivers, GVViews;

type

  PLightShow = ^TLightShow;
  TLightShow = object(TGView)
                 constructor Init;
                 destructor Done; virtual;
                 procedure Draw; virtual;
                 procedure HandleEvent(var Event: TEvent); virtual;
               private
                 Old, KeyState: Byte;
               end;

Implementation

Uses CRT, Objects, MyMouse;

var
  ShiftState: Byte absolute $40:$17;

procedure SetShiftState(AState: Byte; Enable: Boolean); assembler;
asm
	MOV	ES,Seg0040
        MOV	AL, AState
	MOV	BL, Enable
        OR	BL, BL
        JZ	@@1
        OR	ES:ShiftState, AL
        JMP	@@2
@@1:    NOT	AL
        AND     ES:ShiftState, AL
@@2:	MOV	AH, 1
	INT	16H
end;

(****************************** TLightShow object *************************)

constructor TLightShow.Init;
var R: TRect;
Begin
  R.Assign(0,0,0,0);
  inherited Init(R);
  EventMask := EventMask or evTimer;
  Old := GetShiftState and $70;
  SetShiftState($70, false);
  KeyState := kbScrollState;
  SetShiftState(KeyState, true);
End;

destructor TLightShow.Done;
Begin
  SetShiftState($70, false);
  SetShiftState(Old, true);
  inherited Done;
End;

procedure TLightShow.Draw;
Begin End;

procedure TLightShow.HandleEvent(var Event: TEvent);
Begin
  If (Event.What = evTimer) and (Event.InfoWord mod 8 = 0) then Begin
    SetShiftState(KeyState, false);
    Case KeyState Of
      kbScrollState, kbNumState: KeyState := KeyState shl 1;
      kbCapsState: KeyState := kbScrollState;
    End;
    SetShiftState(KeyState, true)
  End
End;

End.