unit Gr;

{ Unit Gr, Version 1.30.001,
  Copyright 1993,1996 by Matthias Kppe.

  gr.inf gr.txt gr.doc
}

{$A+,B-,F-,G+,O-,R-,S-,X+}

interface

uses Objects;

{ Logical graphic modes
}
const
  grVgaLoStd      = 0;            { * 640 x 200, 2 pages, standard  }
  grVgaLoPak      = 1;            {   640 x 200, 2 pages, packed    }
  grVgaMedStd     = 2;            { * 640 x 350, 2 pages, standard  }
  grVgaMedOne     = 3;            { * 640 x 350, 1 page             }
  grVgaMedPak     = 4;            {   640 x 350, 2 pages, packed    }
  grVgaHiStd      = 5;            { * 640 x 480, 1 page             }
  grSvgaStd       = 6;            {   800 x 600, 1 page             }
  grVga256Std     = 7;            {   320 x 200, 1 page, 256 colors }
  grVgaWdMedStd   = 8;            {   720 x 350, 2 pages, standard  }
  grVgaWdMedOne   = 9;            {   720 x 350, 1 page             }
  grVgaWdMedPak   = 10;           {   720 x 350, 2 pages, packed    }
  grVgaWdHiStd    = 11;           {   720 x 480, 1 page             }
  gr640x480x256   = 12;
  gr800x600x256   = 13;
  gr1024x768x16   = 14;
  gr1024x768x256  = 15;
  gr1280x1024x16  = 16;
  gr1280x1024x256 = 17;
  gr640x400x256   = 18;

{ Alias identifiers, with much clearer names
}
const
  gr640x200x16  = grVgaLoPak;
  gr640x350x16  = grVgaMedOne;
  gr640x480x16  = grVgaHiStd;
  gr800x600x16  = grSvgaStd;
  gr320x200x256 = grVga256Std;
  gr720x350x16  = grVgaWdMedOne;
  gr720x480x16  = grVgaWdHiStd;

{ Set logical graphic mode
}
procedure SetGrMode(Mode: Word);

var
  GrMode: Word;

{ Logical parameters
}
var
  SizeX, SizeY: Word;
  Page0Seg, Free0Seg, Page1Seg, Free1Seg, EndSeg: Word;
  GrFlags: Word;
  ScreenF: Word;
  Granularity: Byte;
  MapFlags: Byte;
  RealBytesPerLine32: LongInt;
  RealBytesPerLine: Word			absolute RealBytesPerLine32;

{ Current parameters
}
var
  ActivePage: Word;
  ActiveSeg: Word;
  ActivePSeg: Word;
  ActivePOfs: Word;
  ActiveLinear32: LongInt;
  BytesPerLine32: LongInt;
  BytesPerLine: Word 				absolute BytesPerLine32;
  ActiveWindow: Word;

{ Mapping support (fast-access values)
}
var
  WindowSize32: LongInt;
  WindowSize: Word				absolute WindowSize32;
  OffsetMask32: LongInt;
  OffsetMask: Word				absolute OffsetMask32;
  MapGranMask32: LongInt;
  MapGranMask: Word				absolute MapGranMask32;
  GransPerWindow: Word;
  MapGranRight, MapGranLeft, MapGran32: Byte;
  WindowNum: Word;
  WindowAddr: pointer;

{ Physical screen size in units of 1/1000 inch.
  Note: Screens are treated as devices with resolutions higher than actual.
  The given sizes let resolution 640 x 480 appear to be at 96 dpi, as usual.
}
const
  PhysicalX: Word = 6667;
  PhysicalY: Word = 5000;

{ High-level graphics init and close
}
function InitGraphics: Boolean;
procedure CloseGraphics;

const
  GrActive: Boolean = false;

{ Screen pages
}
procedure SetActivePage(Page: Word);
procedure SetVisualPage(Page: Word);

{ Get dimension parameters
}
function GetMaxX: Integer;
function GetMaxY: Integer;
function GetMaxColor: LongInt;
function GetResX: Integer;
function GetResY: Integer;
function GetAspect: Real;

{ Draw origin and clipping rectangle
}
procedure SetDrawOrigin(x, y: Integer);
procedure SetDrawOriginP(var P: TPoint);
procedure SetClipRect(x1, y1, x2, y2: Integer);
procedure SetClipRectR(var R: TRect);

var
  DrawOrigin: TPoint;
  ClipRect: TRect;

{ Background color and mode
}
procedure SetBkColor(Color: Word);
procedure SetBkMode(Mode: Integer);

const
  Transparent = 1;
  Opaque = 2;

const
  BkColor: Word = 0;
  BkMode: Integer = Transparent;

{ Page, Address, and Mapping support
}
function PageSeg(Page: Word): Word;
function PageLinear(Page: Word): LongInt;
function PageAddr(Page: Word): pointer;
function SegLinear(Seg: Word): LongInt;
function SegAddr(Seg: Word): pointer;
function LinearToAddress(Linear: LongInt): pointer;
procedure MapToNextWindow;
procedure MapToPrevWindow;
procedure SetActiveWindow;

{ Memory management
}
function ReserveSegs(Size: Integer): LongInt;
procedure SetFreeSegsBack(Segs: LongInt);
function GetFreeSegs: LongInt;

{ Physical video mode handling
}
procedure SetBiosMode(Mode: Byte);
procedure SaveTextMode;
procedure RestoreTextMode;
procedure Extend;

var
  SavedTextMode: Byte;

{ Gr Temporary Memory
}
procedure GetTempMem(var Handle: Integer; Size: Word);

const
  TempCount = 32;
  TempUsed: Word = 0;
  TempMem: pointer = nil;

var
  TempHandles: array[1..TempCount] of Word;
  TempMemSize: Word;

{ User pointer handling
}
const
  UserCount = 16;

procedure UserParams(Count: Word);
inline($58 {pop ax});

procedure UserDummy;
procedure FillUserXX;

{ User pointers
}
var
  User00: pointer;
  User01: pointer;
  User02: pointer;
  User03: pointer;
  User04: pointer;
  User05: pointer;
  User06: pointer;
  User07: pointer;
  User08: pointer;
  User09: pointer;
  User0A: pointer;
  User0B: pointer;
  User0C: pointer;
  User0D: pointer;
  User0E: pointer;
  User0F: pointer;

{ Quality indicating bytes
}
const
  Quality00: Byte = 0;
  Quality01: Byte = 0;
  Quality02: Byte = 0;
  Quality03: Byte = 0;
  Quality04: Byte = 0;
  Quality05: Byte = 0;
  Quality06: Byte = 0;
  Quality07: Byte = 0;
  Quality08: Byte = 0;
  Quality09: Byte = 0;
  Quality0A: Byte = 0;
  Quality0B: Byte = 0;
  Quality0C: Byte = 0;
  Quality0D: Byte = 0;
  Quality0E: Byte = 0;
  Quality0F: Byte = 0;

{ MetaGraph support
}
const
  ms_Draw       = 1;
  ms_Record     = 2;
  ms_BGI        = 4;
  ms_Execute    = 8;
  ms_Clear	= 16;
  ms_Play	= 32;

const
  MetaState: Word = ms_Draw or ms_BGI;

var
  MetaClipRect: TRect;
  MetaOrigin: TPoint;

var
   ExtSave: pointer                     absolute User00;
  qExtSave: Byte                        absolute Quality00;

{ Exported line routine
}
type
  TLineProc = procedure(x1, y1, x2, y2: Integer);
var
   LineProc: TLineProc                  absolute User01;
  qLineProc: Byte                       absolute Quality01;

{ Gr Clipping Notification
}
const
  gcnUpdAll    = 1;
  gcnUpdOrigin = 2;

  gcnStopUpd   = 10;
  gcnContUpd   = 11;
  gcnHaltUpd   = 12;
  gcnStartUpd  = 13;
  gcnUpdOnReq  = 14;

type
  TClipNotifyProc = procedure(Msg: Word);
var
   ClipNotifyProc: TClipNotifyProc      absolute User02;
  qClipNotifyProc: Byte                 absolute Quality02;

{ Init Graphics proc
}
type
  TInitGraphProc = function: Boolean;
var
   InitGraphProc: TInitGraphProc        absolute User03;
  qInitGraphProc: Byte                  absolute Quality03;

const
  qInitBiosGraph = 10;

function InitBiosGraph: Boolean;

{ Close Graphics proc
}
var
   CloseGraphProc: procedure            absolute User04;
  qCloseGraphProc: Byte                 absolute Quality04;

const
  qCloseBiosGraph = 10;

procedure CloseBiosGraph;

{ Set Active Page proc
}
var
   ActivePageProc: procedure            absolute User05;
  qActivePageProc: Byte                 absolute Quality05;

{ Change Params proc
}
const
  gcpColor     = 1;
  gcpLineStyle = 2;
  gcpSolidThLn = 3;
  gcpGetSize   = $000;
  gcpGetParams = $100;
  gcpSetParams = $200;

type
  TChParamsProc = function(Cmd: Word; var Buf): Word;

var
   ChParamsProc: TChParamsProc          absolute User06;
  qChParamsProc: Byte                   absolute Quality06;

{ Generic notification proc handling
}
const
  npInstall    = 0;
  npUninstall  = 1;
  npGetQuality = 2;
  npSetNext    = 3;

type
  TNotifyProc = function(Notice: Word; Info: LongInt): LongInt;

procedure InstallNotifyProc(var Chain: TNotifyProc;
  Proc: TNotifyProc);
procedure UninstallNotifyProc(var Chain: TNotifyProc;
  Proc: TNotifyProc);
function DefaultNotify(Notice: Word; Info: LongInt; ThisProc: TNotifyProc;
  var NextProc: TNotifyProc; Quality: Byte): LongInt;

{ Graphics notification proc
}
const
  gnpInitGraphics  = 100;
  gnpCloseGraphics = 101;
  gnpBkMode        = 102;
  gnpPalette       = 103;

var
   GrNotifyProc: TNotifyProc            absolute User07;
  qGrNotifyProc: Byte                   absolute Quality07;

{ Address mapping function.

  Specification:

  In:   BH = 00h ("set")			BH = 01h ("get")
	DX = Address in granularity units
  Out:  AL = 4Fh if function supported		AL = 4Fh if function supported
	AH = 00h if successful			DX = Address in gran units
	Registers destroyed			Registers destroyed
}
var
   MapAddrProc: procedure               absolute User08;
  qMapAddrProc: Byte                    absolute Quality08;

const
  qVgaMapAddr = 10;

procedure VgaMapAddr;

{ Set display start procedure
}
type
  TSetDispStartProc = procedure(Linear: LongInt);

var
   SetDispStartProc: TSetDispStartProc  absolute User09;
  qSetDispStartProc: Byte               absolute Quality09;

const
  qSetVgaDispStart = 10;

procedure SetVgaDispStart(Linear: LongInt);

{ saving and restoring VGA regs
}
procedure SaveRegs;
procedure RestoreRegs;

var
  UserRegArea: array[0..6] of Byte;

{ Protected mode support
}
function SelOfs(ParOfs: pointer): pointer;
function SelOfsZero(ParOfs: pointer): pointer;

{ version 6.0 support
}
{$IFDEF VER60}
const
  Seg0040: Word = $0040;
  SegA000: Word = $A000;
  SegB000: Word = $B000;
  SegB800: Word = $B800;

function GetShiftState: Byte;
procedure NewCache(var P: Pointer; Size: Word);
procedure DisposeCache(P: Pointer);
{$ENDIF}

{ Gr mode flags
}
const
  gf16  = $00;
  gf256 = $01;
  gfMap = $02;

implementation

{$IFDEF VER60}
uses Memory;
{$ENDIF}

{ 
}
procedure GrModeTable; near; assembler;
Asm   { x    y    Page0   Free0   Page1   Free1   End     Fl ScrF   Mf/Gr }
  DW    640, 200, 0A000H, 0A400H, 0A400H, 0A800H, 0B000H, 0, 4576,  0104H
  DW    640, 200, 0A000H, 0A3E8H, 0A3E8H, 0A7D0H, 0B000H, 0, 4576,  0104H
  DW    640, 350, 0A000H, 0A6D6H, 0A800H, 0AED6H, 0B000H, 0, 7821,  0104H
  DW    640, 350, 0A000H, 0A000H, 0A000H, 0A6D6H, 0B000H, 0, 7821,  0104H
  DW    640, 350, 0A000H, 0A6D6H, 0A6D6H, 0ADACH, 0B000H, 0, 7821,  0104H
  DW    640, 480, 0A000H, 0A000H, 0A000H, 0A960H, 0B000H, 0, 10000, 0104H
  DW    800, 600, 0A000H, 0A000H, 0A000H, 0AEA6H, 0B000H, 0, 10000, 0104H
  DW    320, 200, 0A000H, 0A000H, 0A000H, 0AFA0H, 0B000H, 1, 9152,  0104H
  DW    720, 350, 0A000H, 0A7B1H, 0A800H, 0AFB1H, 0B000H, 0, 6952,  0104H
  DW    720, 350, 0A000H, 0A000H, 0A000H, 0A7B1H, 0B000H, 0, 6952,  0104H
  DW    720, 350, 0A000H, 0A7B1H, 0A7B1H, 0AF62H, 0B000H, 0, 6952,  0104H
  DW    720, 480, 0A000H, 0A000H, 0A000H, 0AA8CH, 0B000H, 0, 8889,  0104H
  DW    640, 480,      0,      0,      0,      0,      0, 3, 10000, 0008H
  DW    800, 600,      0,      0,      0,      0,      0, 3, 10000, 0008H
  DW    1024,768,      0,      0,      0,      0,      0, 2, 10000, 0008H
  DW    1024,768,      0,      0,      0,      0,      0, 3, 10000, 0008H
  DW    1280,1024,     0,      0,      0,      0,      0, 2, 10000, 0008H
  DW    1280,1024,     0,      0,      0,      0,      0, 3, 10000, 0008H
  DW    640, 400,      0,      0,      0,      0,      0, 3, 8333,  0008H
End;

{ 
}
procedure SetGrMode(Mode: Word); external;
function PageSeg(Page: Word): Word; external;
function PageLinear(Page: Word): LongInt; external;
function PageAddr(Page: Word): pointer; external;
function SegLinear(Seg: Word): LongInt; external;
function SegAddr(Seg: Word): pointer; external;
function ReserveSegs(Size: Integer): LongInt; external;
procedure SetActivePage(Page: Word); external;
procedure SetVisualPage(Page: Word); external;
procedure SetFreeSegsBack(Segs: LongInt); external;
function GetFreeSegs: LongInt; external;
procedure SetVgaDispStart(Linear: LongInt); external;

{ Physical mode handling ****************************************************
}
procedure SaveTextMode; assembler;
asm
	CMP     SavedTextMode, 0
	JNZ     @@1
	MOV     AH, 0FH
	INT     10H
	MOV     SavedTextMode, AL
@@1:
end;

procedure RestoreTextMode; assembler;
Asm
	MOV     AX, 0
	XCHG    AL, SavedTextMode
	INT     10H
End;

procedure SetBiosMode(Mode: Byte); assembler;
Asm
	call    SaveTextMode
	MOV     AL, Mode
	XOR     AH, AH
	INT     10H
End;

function InitBiosGraph; assembler;
Asm
	MOV     SI, GrMode
	MOV     AL, 0
	CMP     SI, grSvgaStd
	JE      @@2
	CMP     SI, grVgaWdHiStd
	JA      @@2
	CALL    @@1
	DB      0EH, 0EH, 10H, 10H, 10H, 12H, 00H, 13H, 90H, 90H, 90H, 92H
@@1:    POP     BX
	MOV     AL, CS:[SI][BX]
	PUSH    AX
	AND     AX, 7FH
	PUSH    AX
	PUSH    CS
	CALL    NEAR PTR SetBiosMode
	POP     AX
	TEST    AL, 80H
	JZ      @@3
	CALL    Extend
@@3:    MOV     AL, 1
@@2:    mov     GrActive, AL            { for compatibility only }
End;

procedure CloseBiosGraph; assembler;
Asm
	JMP     RestoreTextmode
End;

procedure Extend; assembler;
const
  Data: array[0..5] of Byte =
    ($6D, $59, $5A, $90, $60, $89);
asm
	CLI
	MOV     DX, 03C4H               { Sequencer }
	MOV     AX, 0100H               { Reset }
	OUT     DX, AX
	MOV     DX, 03CCH               { Misc Out [Read] }
	IN      AL, DX
	OR      AL, 4                   { 28 MHz }
	MOV     DX, 03C2H               { Misc Out [Write] }
	OUT     DX, AL
	MOV     DX, 03C5H               { Sequencer Data }
	MOV     AL, 3                   { End of Reset }
	OUT     DX, AL
	STI
	MOV     DX, 03D4H               { CRTC }
	MOV     AL, 11H                 { Vertical Retrace End }
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	AND     AL, 7FH                 { clear Protect bit }
	OUT     DX, AL
	DEC     DX
	MOV     CX, 6
	MOV     SI, OFFSET Data
	MOV     AL, 0
@@1:    MOV     AH, [SI]
	OUT     DX, AX
	INC     SI
	INC     AL
	LOOP    @@1
	MOV     AL, 11H
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	OR      AL, 80H                 { set Protect bit }
	OUT     DX, AL
	DEC     DX
	MOV     AX, 2D13H               { Offset: 90/2 }
	OUT     DX, AX
end;

{ High-level graphics init/close ********************************************
}
function InitGraphics;
Begin
  UserParams(0);
  GrActive := InitGraphProc;
  InitGraphics := GrActive;
  If GrActive then Begin
    SetActivePage(0);                   { get right mapping values }
    UserParams(3);
    GrNotifyProc(gnpInitGraphics, 0)
  End;
End;

procedure CloseGraphics;
Begin
  If GrActive then Begin
    UserParams(3);
    GrNotifyProc(gnpCloseGraphics, 0);
    UserParams(0);
    CloseGraphProc;
  End;
  GrActive := false
End;

{ ClipRect and DrawOrigin ***************************************************
}
procedure SetDrawOrigin; assembler;
Asm
	MOV     AX, x
	MOV     DrawOrigin.x, AX
	MOV     AX, y
	MOV     DrawOrigin.y, AX
	MOV     AX, 1
	PUSH    gcnUpdOrigin
	CALL    ClipNotifyProc
End;

procedure SetDrawOriginP; assembler;
Asm
	PUSH    DS
	POP     ES
	MOV     DI, OFFSET DrawOrigin
	LDS     SI, P
	CLD
	MOVSW
	MOVSW
	PUSH    ES
	POP     DS
	MOV     AX, 1
	PUSH    gcnUpdOrigin
	CALL    ClipNotifyProc
End;

procedure SetClipRect; assembler;
Asm
	TEST    MetaState, ms_Record
	JZ      @@NR
	PUSH    0
	PUSH    8
	PUSH    0
	MOV     AX, 3
	CALL    [ExtSave]
	TEST    MetaState, ms_Record
	JNZ     @@NR
	PUSH    DS
	POP     ES
	MOV     DI, OFFSET ClipRect
	CLD
	MOV     AX, x1
	CMP     AX, MetaClipRect.A.x
	JG      @@1
	MOV     AX, MetaClipRect.A.x
@@1:    STOSW
	MOV     AX, y1
	CMP     AX, MetaClipRect.A.y
	JG      @@2
	MOV     AX, MetaClipRect.A.y
@@2:    STOSW
	MOV     AX, x2
	CMP     AX, MetaClipRect.B.x
	JL      @@3
	MOV     AX, MetaClipRect.B.x
@@3:    CMP     AX, ClipRect.A.x
	JL      @@7
	STOSW
	MOV     AX, y2
	CMP     AX, MetaClipRect.B.y
	JL      @@5
	MOV     AX, MetaClipRect.B.y
@@5:    CMP     AX, ClipRect.A.y
	JG      @@6
@@7:    MOV     AX, 0                   { negative -> zero ClipRect }
	MOV     DI, OFFSET ClipRect
	STOSW
	STOSW
	STOSW
@@6:    STOSW
	JMP     @@END

@@NR:   PUSH    DS
	POP     ES
	MOV     DI, OFFSET ClipRect
	CLD
	MOV     AX, x1
	STOSW
	MOV     AX, y1
	STOSW
	MOV     AX, x2
	STOSW
	MOV     AX, y2
	STOSW
	MOV     AX, 1
	PUSH    gcnUpdAll
	CALL    ClipNotifyProc
@@END:
End;

procedure SetClipRectR; assembler;
Asm
	TEST    MetaState, ms_Record
	JZ      @@1
	LES     SI, R
	PUSH    ES:[SI].TRect.A.x
	PUSH    ES:[SI].TRect.A.y
	PUSH    ES:[SI].TRect.B.x
	PUSH    ES:[SI].TRect.B.y
	CALL    SetClipRect
	JMP     @@2
@@1:    PUSH    DS
	POP     ES
	MOV     DI, OFFSET ClipRect
	LDS     SI, R
	MOV     CX, 4
	CLD
	REP     MOVSW
	PUSH    ES
	POP     DS
	MOV     AX, 1
	PUSH    gcnUpdAll
	CALL    ClipNotifyProc
@@2:
End;

{ Dimensions
}

function GetMaxX: Integer;
begin
  GetMaxX := SizeX - 1
end;

function GetMaxY: Integer;
begin
  GetMaxY := SizeY - 1
end;

function GetMaxColor: LongInt;
begin
  If GrFlags and gf256 = 0
  then GetMaxColor := 15
  else GetMaxColor := 255
end;

function GetResX: Integer;
begin
  GetResX := Round(SizeX / PhysicalX * 1000)
end;

function GetResY: Integer;
begin
  GetResY := Round(SizeY / PhysicalY * 1000)
end;

function GetAspect: Real;
begin
  GetAspect := LongMul(PhysicalX, SizeY) / LongMul(PhysicalY, SizeX)
end;

{ Background color and mode
}
procedure SetBkColor(Color: Word); assembler;
asm
	TEST    MetaState, ms_Record
	JZ      @@NR
	PUSH    0
	PUSH    2
	PUSH    0
	MOV     AX, 3
	CALL    [ExtSave]
@@NR:
	MOV	AX, Color
	MOV	BkColor, AX
end;

procedure SetBkMode(Mode: Integer); assembler;
asm
	TEST    MetaState, ms_Record
	mov     ax, Mode
	JZ      @@NR
	PUSH    0
	PUSH    2
	PUSH    0
	MOV     AX, 3
	CALL    [ExtSave]

	TEST	MetaState, ms_Record
	mov	ax, Mode
	JZ	@@1
@@NR:
	cmp     ax, BkMode
	je      @@0
@@1:
	mov     BkMode, ax
	mov     ax, 3
	push    gnpBkMode
	sub     sp, 4
	call    GrNotifyProc
@@0:
end;

{ VGA register handling *****************************************************
}
procedure SaveRegs; assembler;
Asm
	PUSHF
	CLD
	MOV     DI, OFFSET UserRegArea
	MOV     AX, DS
	MOV     ES, AX
	MOV     DX, 03CEH               { GC }
	MOV     AL, 3                   { Data Rotate }
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	DEC     DX
	STOSB
	MOV     AL, 1                   { Enable Set/Reset }
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	DEC     DX
	STOSB
	MOV     AL, 8                   { Bit Mask }
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	DEC     DX
	STOSB
	MOV     AL, 5                   { Graphics Mode }
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	STOSB
	MOV     DX, 03C4H               { SC }
	MOV     AL, 2                   { Map Mask }
	OUT     DX, AL
	INC     DX
	IN      AL, DX
	STOSB
	POPF
End;

procedure RestoreRegs; assembler;
Asm
	PUSHF
	CLD
	MOV     SI, OFFSET UserRegArea
	MOV     DX, 03CEH               { GC }
	MOV     AH, 3                   { Data Rotate }
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	MOV     AH, 1                   { Enable Set/Reset }
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	MOV     AH, 8                   { Bit Mask }
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	INC     SI
	MOV     DX, 03C4H               { SC }
	MOV     AH, 2                   { Map Mask }
	LODSB
	XCHG    AH, AL
	OUT     DX, AX
	POPF
End;

{ Address mapping ***********************************************************
}
{$IFDEF DPMI}

{$L grdpmi.obj     (grdpmi.asm)         Gr, DPMI support }

function SelOfs(ParOfs: pointer): pointer; external;
function SelOfsZero(ParOfs: pointer): pointer; external;
procedure FillSegTbl; near; external;

{$ELSE}

function SelOfs(ParOfs: pointer): pointer; assembler;
asm
	MOV     DX, WORD PTR ParOfs + 2
	MOV     AX, WORD PTR ParOfs
end;

function SelOfsZero(ParOfs: pointer): pointer; assembler;
asm
	MOV     DX, WORD PTR ParOfs + 2
	MOV     AX, WORD PTR ParOfs
end;

{$ENDIF}

procedure ValidPSeg; near; assembler;
asm
	mov     ActiveSeg, 0A000h
	mov     dx, SegA000
	mov     ActivePSeg, dx
	mov     ActivePOfs, 0
	mov     WORD PTR WindowAddr[2], dx
	mov     WORD PTR WindowAddr[0], 0
end;

procedure VgaMapAddr; assembler;
asm
	mov     ax, 004Fh               { supported, successful }
	mov	dx, 0000h		{ window 0 }
end;

function LinearToAddress(Linear: LongInt): pointer; external;
procedure MapToNextWindow; external;
procedure MapToPrevWindow; external;
procedure SetActiveWindow; external;

{$L gr.obj         (gr.asm)             Gr routines }

{ Turbo Pascal 6.0 support **************************************************
}
{$IFDEF VER60}

var
  ShiftState: Byte absolute $40:$17;

function GetShiftState: Byte; assembler;
asm
	MOV     ES,Seg0040
	MOV     AL,ES:ShiftState
end;

procedure NewCache;
Begin
  GetBufMem(P, Size)
End;

procedure DisposeCache;
Begin
  FreeBufMem(P)
End;

{$ENDIF}

{ User proc handling ********************************************************
}
var
  DummyJumpback: pointer;

procedure UserDummy; assembler;
Asm
	POP     WORD PTR DummyJumpBack
	POP     WORD PTR DummyJumpBack+2
	SHL     AX, 1
	ADD     SP, AX
	XOR     AX, AX                  { Funktionsergebnis }
	MOV     DX, AX
	JMP     DummyJumpback
End;

procedure FillUserXX; assembler;
Asm
	MOV     DI, OFFSET User00
	MOV     SI, OFFSET Quality00
	MOV     CX, UserCount
	MOV     DX, CS
	MOV     BX, OFFSET UserDummy
@@2:    CMP     BYTE PTR [SI], 0
	JNZ     @@1
	MOV     [DI], BX
	MOV     [DI+2], DX
@@1:    INC     SI
	ADD     DI, 4
	LOOP    @@2
End;

{ Notification procedure handling *******************************************
}
procedure InstallNotifyProc;
var
  Res: LongInt;
Begin
  If @Chain = nil then @Chain := @UserDummy;
  UserParams(3);
  Res := Chain(npInstall, LongInt(@Proc));
  If Res = 0 then Begin
    Res := LongInt(@Chain);
    Chain := Proc
  End else
  If Res = LongInt(@Chain)
  then Chain := Proc;
  UserParams(3);
  Proc(npSetNext, Res)
End;

procedure UninstallNotifyProc;
var
  Res: LongInt;
Begin
  UserParams(3);
  Res := Chain(npUninstall, LongInt(@Proc));
  If Res <> 0 then
  Chain := TNotifyProc(Res)
End;

function DefaultNotify;
var
  Res: LongInt;
Begin
  case Notice of
    npInstall:
      If TNotifyProc(Info)(npGetQuality, 0) >= Quality
      then DefaultNotify := LongInt(@ThisProc)
      else Begin
	UserParams(3);
	Res := NextProc(npInstall, Info);
	If Res = 0 then Res := LongInt(@NextProc);
	DefaultNotify := Res;
	If (Res = LongInt(@NextProc)) or (Res = 0) then
	  LongInt(@NextProc) := Info
      End;
    npUninstall:
      If LongInt(@ThisProc) = Info
      then DefaultNotify := LongInt(@NextProc)
      else Begin
	UserParams(3);
	Res := NextProc(npUninstall, Info);
	DefaultNotify := LongInt(@ThisProc);
	If Res <> 0 then
	LongInt(@NextProc) := Res
      End;
    npGetQuality:
      DefaultNotify := Quality;
    npSetNext:
      NextProc := TNotifyProc(Info);
  else
    Begin
      UserParams(3);
      NextProc(Notice, Info)
    End;
  end;
End;

{ Gr Temporary Memory *******************************************************
}

procedure GetTempMem(var Handle: Integer; Size: Word);
var
  i: Integer;
Begin
  If Handle = 0
  then Begin
    If TempUsed >= TempCount then Exit;
    Inc(TempUsed);
    Handle := TempUsed
  End;
  TempHandles[Handle] := Size;
  For i := 1 to TempUsed do
    If TempHandles[Handle] > Size
    then Size := TempHandles[Handle];
  If Size <> TempMemSize
  then Begin
    If TempMem <> nil
    then FreeMem(TempMem, TempMemSize);
    GetMem(TempMem, Size);
    TempMemSize := Size
  End
End;

{ MAIN **********************************************************************
}

Begin
  FillUserXX;
  If qInitBiosGraph > qInitGraphProc then Begin
    qInitGraphProc := qInitBiosGraph;
     InitGraphProc :=  InitBiosGraph
  End;
  If qCloseBiosGraph > qCloseGraphProc then Begin
    qCloseGraphProc := qCloseBiosGraph;
     CloseGraphProc :=  CloseBiosGraph
  End;
  If qVgaMapAddr > qMapAddrProc then Begin
    qMapAddrProc := qVgaMapAddr;
     MapAddrProc :=  VgaMapAddr
  End;
  If qSetVgaDispStart > qSetDispStartProc then Begin
    qSetDispStartProc := qSetVgaDispStart;
     SetDispStartProc :=  SetVgaDispStart
  End;
{$IFDEF DPMI}
  FillSegTbl;
{$ENDIF}
  ValidPSeg;
End.
