{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Math/Simpson.pas                 [x] Protected mode

  Simpson's formula for integrale calculus. This is a fast and
  accurate numerical method that calculates integrales by approximating
  areas below the function graphs.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFMATH;


var Solver : tSolver;

function ExternalF (X : tBaseReal) : tBaseReal; far;
begin
     ExternalF := Exp (X) / X; { e^x/x }
end;

begin
     with Solver do begin

          { Initialize the solver }
          Initialize ( 1.0, { Start with x = 0 }
                       1e-10, { Stop when five decimals accuracy is reached }
                       10000, { Stop after 100 iterations (if not earlier) }
                       @ExternalF, { Use an external function f(x) }
                       NIL, NIL
                     );

          Simpson (1, 2);
          WriteLn ('f(x) = 1/[x^0.5] ==> F(9) - F(4) = ', Result:0:10);
          WriteLn ('Verification: the exact value is F(9) - F(4) = 3.059116539645..');

          Intercept;

     end;
end.