{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Location/Matrix5.pas             [x] Protected mode

  Matrix algebra demonstration: inverting matrixes and advanced
  Gauss elimination procedures.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFMATH;


{ Builds a coefficient matrix. }
procedure Generate1 (var Matrix : tMatrix);
begin
      with Matrix do begin
          Initialize (3, 3);

          SetElement (1, 1, 2);  SetElement (1, 2, 2);  SetElement (1, 3, 1);
          SetElement (2, 1, -2); SetElement (2, 2, 1);  SetElement (2, 3, -3);
          SetElement (3, 1, 3);  SetElement (3, 2, 0);  SetElement (3, 3, 2);
      end;
end;

{ Builds a result matrix that corresponds to the solution (1/3, 2/3, 1)
  when combined with the coefficient matrix above. }
procedure Generate2 (var Matrix : tMatrix);
begin
     with Matrix do begin
          Initialize (3, 1);

          SetElement (1, 1,  3);
          SetElement (2, 1, -3);
          SetElement (3, 1,  3);
     end;
end;


var Matrix1, Matrix2 : tMatrix;

begin
     Generate1 ( Matrix1 );
     Generate2 ( Matrix2 );

     WriteLn ('The equation system was solved: ');

     if Matrix1.Gauss (@Matrix2)
        then Matrix2.StreamWrite (StdIO);

     Matrix1.Intercept; Matrix2.Intercept;
end.