/***************************************************************************\
*
* PVCS Software Configuration Management Control Information
*
* TIFF421.C
*
* $Revision:   1.0  $
*
* $Date:   20 Mar 1988 18:14:28  $
*
* $Author:   tomh  $
*
* $Logfile:   F:/public/gads/product/src/tiff421.c_v  $
*
* $Log:   F:/public/gads/product/src/tiff421.c_v  $
*    
*       Rev 1.0   20 Mar 1988 18:14:28   tomh
*    Initial revision.
*
\***************************************************************************/

/*
	tiff421.c the tiff file open and read routines for the 421
	prototype.

	written by B. G. Madsen

	June 15, 1987
	Modified July 13, 1987

	includes -
*/

/* #include "windows.h" */
/* #include "gawb.h" */
#include "wintypes.h"
#include "tiffint.h"

#define FULL_RES	1
#define PLANE_1 	1
#define BITSPERBYTE	8

/* externals from the tiff library */
extern short read_tag();
extern int read_image();
extern void close_image();
extern void close_read();
extern void close();

/* library exports */
short TLGetTiff();
long  TLReadLine();
void  TLCloseImg();

/* global variables */
/* note, if defined elsewhere, these definetions should be proceeded with */
/* a extern */

static int RowsStrip;   /* how many rows/strip in image file */
static int Bytes_Per_Line;	/*the number of bytes needed to read in one scan line */
static unsigned int Width;		/*the width of the image in pixels */
static unsigned int Length;		/* the length of the image in pixels */
static int Bits_per_Pixel;	/* the number of bits per pixel */
static int Black_Level; 	/* a variable describing if 0 or 1 is black */
static int scan_direction;	/* a variable describing how the image was scanned */
				/* see the tiff specification for more information */
				/* for our application, this value will always be 1*/
static RATIO	Xresolution;	/* horizontal resolution */
static RATIO	Yresolution;	/* vertical resolution */


/************************************************************************
 *									*
 * open_tiff - open tiff will open a tiff file and read the following	*
 *	parameters from the file:					*
 *		width,height,samples per pixel, bits per sample,	*
 *		black level, scan_direction				*
 *		These paramters are passed back through global values	*
 *									*
 *	parameters needed for the call: 				*
 *		HWND hWnd;    a handle to the current window		*
 *		LPSTR *fname;  a character pointer to the name of the	*
 *				the file				*
 *									*
 *									*
 *	the function will return -1 for failure, the file handle if	*
 *	the function was successful					*
 *									*
 ***********************************************************************/

short TLGetTiff(hDataFile, Tiffdata)
HANDLE		hDataFile;	/* handle to the tiff file */
TIFF_DATA	*Tiffdata;	/* tiff data structure */
{
	int samples_per_pixel;
	int bits_per_sample;

	/* now read the tiff file's tag list */

	if(!read_tag(hDataFile,FULL_RES,TAG_SAMPIX,(LPSTR)&samples_per_pixel,
		(short)sizeof(samples_per_pixel))){
		      samples_per_pixel = 1;
	}

	if(!read_tag(hDataFile,FULL_RES,TAG_BITSPIX,(LPSTR)&bits_per_sample,
		(short)sizeof(bits_per_sample))){
		      bits_per_sample = 1;
	}

	if(!read_tag(hDataFile,FULL_RES,TAG_IMWIDTH,(LPSTR)&Width,
		(short)sizeof(Width))){
		      return(-1);
	}

	if(!read_tag(hDataFile,FULL_RES,TAG_IMLENGTH,(LPSTR)&Length,
		(short)sizeof(Length))){
		      return(-1);
	}

	if(!read_tag(hDataFile,FULL_RES,TAG_PHOTOINTERP,(LPSTR)&Black_Level,
		(short)sizeof(Black_Level))){
		      return(-1);
	}

/*	if(!read_tag(hDataFile,FULL_RES,TAG_ORIENT,(LPSTR)&scan_direction,
		(short)sizeof(scan_direction))){
		      return(-1);
	} */

	if(!read_tag(hDataFile,FULL_RES,TAG_XRES,(LPSTR)&Xresolution,
		(short)sizeof(RATIO))){
		      return(-1);
	}

	if(!read_tag(hDataFile,FULL_RES,TAG_YRES,(LPSTR)&Yresolution,
		(short)sizeof(RATIO))){
		      return(-1);
	}

	if(!read_tag(hDataFile,FULL_RES,TAG_ROW_STRIP,(LPSTR)&RowsStrip,
		(short)sizeof(RATIO))){
		      return(-1);
	}

	Bytes_Per_Line= ((Width * bits_per_sample * samples_per_pixel) + 7) / 8;

	Bits_per_Pixel = bits_per_sample * samples_per_pixel;

	/* move data to the tiff_open structure */
	Tiffdata->BytesPerLine = Bytes_Per_Line;
	Tiffdata->TiffWidth = Width;
	Tiffdata->TiffLength = Length;
	Tiffdata->BitsPerPixel = Bits_per_Pixel;
	Tiffdata->BlackLevel = Black_Level;
	Tiffdata->ScanDirection = scan_direction;
	Tiffdata->RowsPerStrip = RowsStrip;
	Tiffdata->Tiffxresolution = (short)Xresolution.upper;
	Tiffdata->Tiffyresolution = (short)Yresolution.upper;

	return(0);
}


/************************************************************************
 *									*
 * function ReadLine(Window_handle, Filehandle,buffer,lineno,		*
 *						number_of_lines)	*
 *	ReadLine reads number of lines of image data into a buffer	*
 *	starting at the line number specified.				*
 *		paramters are:						*
 *			Window_handle - a handle to the current 	*
 *			window. 					*
 *			Filehandle - a handle to a file opened for	*
 *			reading.					*
 *			buffer - a long pointer to a character buffer	*
 *			to hold the returned data.			*
 *			lineno - a long indictating where to start	*
 *			reading.					*
 *			number_of_lines - a long specifying how many	*
 *			lines to read.					*
 *	NOTE: the space available to the buffer must be greater than	*
 *		or equal to the number_of_lines * bytes_per_line.	*
 *		The function will fail if this requirment is not met.	*
 *									*
 *	The function returns the linenumber where scanning would begin	*
 *	if a sequental read was to be done.				*
 *									*
 ************************************************************************/

LONG TLReadLine(hDataFile,buffer,lineno,number_of_lines)
/* HWND hWnd; */
HANDLE	hDataFile;	/* ms-dos file descriptor */
LPSTR	buffer;
unsigned long	lineno;
unsigned long	number_of_lines;
{

	int retval;
	char buf[200];

	if((retval = read_image (hDataFile,FULL_RES,
				PLANE_1,lineno,number_of_lines,
				buffer,
				Bytes_Per_Line*number_of_lines)) == NULL){

	/*	MessageBox(hWnd,"Cannot read image from TIFF file",
			"",MB_OK); */
		return(-1);
	}
	return(lineno+=number_of_lines);
}


/* close_img(hDatafile) - close a tiff file read */
/* needs to be passed the handle to the open file. */

void TLCloseImg(hDataFile)
HANDLE hDataFile;
{

	close_read(hDataFile);
/*	close(hDataFile); */
}
