{ procedures SCALENODES, SHIFTNODES, and ROTATENODES }

procedure SCALENODES (Firstnode, Lastnode: integer; Scale: vector);
{ Scale all nodes in this solid by the factors specified }

var Axis:       integer;  { axis to scale on }
    Node:       integer;  { node # }

begin
{$ifdef BIGMEM}
with ptra^ do
begin
{$endif}
  for Axis := 1 to 3 do
    if (Scale[Axis] <> 0.0) and (Scale[Axis] <> 1.0) then
      for Node := Firstnode to Lastnode do
        World[Node][Axis] := World[Node][Axis] * Scale[Axis];
      { for Node }
    { if Scale... }
  { for Axis }
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure SCALENODES }

procedure SHIFTNODES (Firstnode, Lastnode: integer; Shift: vector);
{ Shift all nodes in this solid by the vector specified }

var Axis:       integer;  { axis to scale on }
    Node:       integer;  { node # }

begin
{$ifdef BIGMEM}
with ptra^ do
begin
{$endif}
  for Axis := 1 to 3 do
    if (Shift[Axis] <> 0.0) then
      for Node := Firstnode to Lastnode do
        World[Node][Axis] := World[Node][Axis] + Shift[Axis];
      { for Node }
    { if Scale... }
  { for Axis }
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure SHIFTNODES }

function ATAN2 (Y, X: real): real;
{ returns the arc-tangent, in radians, of Y/X, in the range of -PI to PI. }

const PI = 3.141592654;
begin
  if (Y = 0.0) then begin
    if (X >= 0.0) then
      ATAN2 := 0.0
    else
      ATAN2 := PI;
  end else if (Y > 0) then begin
    if (X = 0.0) then
      ATAN2 := PI / 2.0
    else if (X > 0.0) then
      ATAN2 := arctan (Y / X)
    else
      ATAN2 := PI - arctan (Y / -X);
  end else begin
    if (X = 0.0) then
      ATAN2 := -PI / 2.0
    else if (X > 0.0) then
      ATAN2 := arctan (Y / X)
    else
      ATAN2 := -PI + arctan (Y/ X);
  end; { if Y }
end; { procedure ATAN2 }

procedure ROTATENODES (Firstnode, Lastnode: integer; Rotate: vector);
{ Rotate all nodes in this solid by the rotation vector specified }

var Anglerad:   real;     { angle in radians }
    Node:       integer;  { node # }
    Axis:       integer;  { axis to rotate about }
    A1, A2:     integer;  { other two axes }
    Dist:       real;     { distance to X,Y coord }
    Theta2:     real;     { new angle, after rotating }

begin
{$ifdef BIGMEM}
with ptra^ do
begin
{$endif}
  for Axis := 1 to 3 do begin
    if (Rotate[Axis] <> 0.0) then begin
      { Convert degrees to radians }
      Anglerad := 3.141592654 * Rotate[Axis] / 180.0;
      for Node := Firstnode to Lastnode do begin
        case Axis of
        1: begin
             A1 := 2;
             A2 := 3;
           end;
        2: begin
             A1 := 3;
             A2 := 1;
           end;
        3: begin
             A1 := 1;
             A2 := 2;
           end;
        end; { case Axis of }
        Dist := sqrt (sqr(World[Node][A1]) + sqr(World[Node][A2]));
        Theta2 := atan2 (World[Node][A2], World[Node][A1]) + Anglerad;
        World[Node][A1] := Dist * cos(Theta2);
        World[Node][A2] := Dist * sin(Theta2);
      end; { for Node }
    end; { if Rotate[Axis] }
  end; { for Axis }
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure ROTATENODES }
