{ The following variables are shared between Setorigin and Perspective }
var D:             real;     { distance from eye to point viewed }
    Cal, Cbe, Cgaa: real;    { cosines of the angles }
    R:             real;
    Zyflag:        boolean;  { true if the view is closely oriented to the
                               X-Y plane }

procedure SETORIGIN;
{ Set the origin of the plot for the 3-D to 2-D transformation, and
  pre-compute some angles
  Setorigin, and the accompanying Perspective procedure, are derived
  from algorithm 475, Communications of the ACM (Volume 17 No. 3, March 74)
  and EPIC-3.
}
var Al, Be, Ga:    real;      { viewing angles }
    Sga, Sbe:      real;      { sines of the viewing angles }

begin
  if (Viewtype = 0) then begin
    D := sqrt (sqr(Xfocal-Xeye) + sqr(Yfocal-Yeye) + sqr(Zfocal-Zeye));
    Cal := (Xfocal-Xeye) / D;
    Cbe := (Yfocal-Yeye) / D;
    Cgaa := (Zfocal-Zeye) / D;
    Al := arccos (Cal);
    Be := arccos (Cbe);
    Ga := arccos (Cgaa);
    Sga := sin (Ga);
    if (Sga >= 0.0001) then begin
      R := 1 / Sga;
      Zyflag := TRUE;
    end else begin
      Sbe := sin(Be);
      R := 1 / Sbe;
      Zyflag := FALSE;
    end;
  end; { if Viewtype }
end;  { procedure SETORIGIN }

procedure PERSPECT (X, Y, Z: real; var Xt, Yt, Zt: real);
{ Do the 3-D to 2-D perspective transformation for a given node }

var Dnm:     real;       { denominator of the general fraction }

begin
  if (Viewtype = 0) then begin
    Dnm := (X - Xeye)*Cal + (Y - Yeye)*Cbe + (Z - Zeye)*Cgaa;
    if (Dnm = 0.0) then
      Dnm := 0.0001;
    Zt := D / Dnm;
    if (Zyflag) then begin
      Xt := ((Xeye + Zt*(X-Xeye) - Xfocal)*Cbe - (Yeye + Zt*(Y-Yeye) - Yfocal)
            *Cal) * R;
      Yt := (Zeye + Zt*(Z-Zeye) - Zfocal) * R;
    end else begin
      Xt := ((Zeye + Zt*(Z-Zeye) - Zfocal)*Cal - (Xeye + Zt*(X-Xeye) - Xfocal)
            *Cgaa) * R;
      Yt := (Yeye + Zt*(Y-Yeye) - Yfocal) * R;
    end;
  end else if (Viewtype = 1) then begin
    Xt := X;
    Yt := Y;
    Zt := -Z;
  end else if (Viewtype = 2) then begin
    Xt := X;
    Yt := Z;
    Zt := Y;
  end else begin
    Xt := Y;
    Yt := Z;
    Zt := -X;
  end; { if Viewtype }
end;  { procedure PERSPECT }
