10 FG=0:KEY OFF
20 GOTO 2700
25 '
30 '  ******
40 '
50 '  This module computes the look Azimuth and Elevation from a specified
51 '  position on the earth to a Synchronous Satellite.
60 '
70 '  ******
80 '
90 '  Azimuth is in Y
100 '  Elevation is in EL
110 '
120 '  First compute the proper Longitude Difference
130 '
140 T = M2 - M1
150 TA = ABS(T)
160 IF TA <= 180 THEN GOTO 190
170 TS = SGN(T)
180 T = -1 * ((TS * 360) - T)
190 EP = T
200 '
210 '  Now convert Angles into Radians
220 '
230 T = T / RD:L1 = L1 / RD:EP = EP / RD
240 '
250 '  Now compute MODIFIED receiver latitude
251 '
260 X = SQR (1 - .5 * (COS(L1) + COS(EP)))
270 ML = 2 * FN ARCSYN(X)
280 '
290 '  Now compute elevation look angle
300 '
310 EL = (PI / 2) - (ML + ATH(R * SIN(ML) / (R * (1 - COS(ML) * H))))
320 '
330 '  Now compute look azimuth
340 '
350 IF EP = 0 THEN YA = PI: GOTO 420
360 ZA = 1 / TAN(EP / 2)
370 ZB = TAN(L1 / 2)
380 YA = ATN(ZA * ZB) + ATN (ZA * (1 / ZB))
390 '
400 '  Now convert angles back to degrees
410 '
420 YA = YA * RD:EL = INT(EL * RD):L1 = L1 * RD
430 '
440 '  Correct look Azimuth for North/South Hemisphere
450 '
460 ZF = 360
470 IF L1 < 0 THEN GOTO 510
480 YA = 360 + YA
490 Y = FN MUD(YA)
500 RETURN
510 Y = INT(180 + YA)
520 RETURN
521 '
530 '  ******
540 '
550 '  Module to get city Name,Latitude and Longitude.
560 '
570 '  ******
571 '
580 SCREEN 0,0:CLS:LOCATE 3,1
590 INPUT "What is the name of the city ? ",NC$
600 LOCATE 7,1
610 INPUT "Enter the CITY Latitude using SPACES to seperate DEGREES, MINUTES,  and N(orth) or S(outh). ",DL$
620 '
630 '  Now decompose DL$ into degrees,minutes and N or S
640 '  Do degrees first
650 '
660 LE = LEN(DL$)
670 I = 1
680 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 800
690 IF (I = LE) THEN GOTO 750
700 I = I + 1:GOTO 680
710 '
720 '  Data is not in proper format
730 '  Send error message and do again
740 '
750 LOCATE 20,1:PRINT "When you enter the Latitude, be sure to use spaces to seperate the entries. ":LOCATE 24,27:INPUT"Press any key to continue!",KB$
760 LOCATE 7,1:CLS:GOTO 610
770 '
780 '  Get degrees
790 '
800 J = I - 1
810 DG = VAL(MID$(DL$,1,J))
820 '
830 '  Now look for minutes
840 '
850 MN = 0:KK = 0
860 I = I + 1
870 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 930
880 IF (I = LE) THEN GOTO 750
890 I = I + 1:KK = 1:GOTO 870
900 '
910 '  Get minutes
920 '
930 JK = I - 1
940 IF KK <> 0 THEN MN = VAL(MID$(DL$,J + 1,JK))
950 '
960 '  Degrees between 0-90 and minutes between 0-60?
970 '
980 IF NOT (DG > 90 OR DG < 0 OR MN > 60 OR MN < 0) THEN GOTO 1070
990 '
1000 '  Deg,min between correct limits
1010 '
1020 LOCATE 20,1:PRINT "Degrees are between 0 and 90 and Minutes are between 0 and 60.":INPUT "Any key to continue ";K$
1030 CLS:LOCATE 7,1:GOTO 610
1040 '
1050 '  Convert to decimal
1060 '
1070 L1 = DG + (MN / 60)
1080 '
1090 '  N or S?
1100 '
1110 I = I + 1
1120 NS$ = MID$(DL$,I,1)
1130 IF NS$ = "N" OR NS$ = "n" OR NS$ = "S" OR NS$ = "s" THEN GOTO 1220
1140 '
1150 '  Must be North or South
1160 '
1170 LOCATE 20,1:INPUT "Enter either N for North or S for South. Any key to continue. ";K$
1180 CLS:LOCATE 7,1:GOTO 610
1190 '
1200 '  Put in correct sigh for latitude
1210 '
1220 IF NS$ = "S" OR NS$ = "s" THEN L1 = -L1
1240 '
1250 '  Now get city longitude
1270 '
1280 LOCATE 11,1
1290 INPUT "Enter the city longitude  using SPACES to seperate DEGREES, MINUTES, and E(ast) or W(est). ",DL$
1300 '
1310 '  Now decompose Dl$ into degrees, minutes and E or W
1320 '  Do degrees first
1330 '
1340 LE = LEN(DL$)
1350 I = 1
1360 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 1480
1370 IF (I = LE) THEN GOTO 1430
1380 I = I + 1:GOTO 1360
1390 '
1400 '  Data is not in proper format
1410 '  Send error message and do again
1420 '
1430 LOCATE 20,1:PRINT"When you enter the longitude, be sure to use spaces to seperate the entries. ":LOCATE 24,27:INPUT"Press any key to continue!",KB$
1440 CLS;LOCATE 11,1:GOTO 1280
1450 '
1460 '  Get degrees
1470 '
1480 J = I - 1
1490 DG = VAL(MID$(DL$,1,J))
1500 '
1510 '  Now look for minutes
1520 '
1530 MN = 0:KK = 0
1540 I = I + 1
1550 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 1610
1560 IF (I = LE) THEN GOTO 1430
1570 I = I + 1:KK = 1:GOTO 1550
1580 '
1590 '  Get minutes
1600 '
1610 JK = I - 1
1620 IF KK <> 0 THEN MN = VAL(MID$(DL$,J + 1,JK))
1630 '
1640 '  Degrees between 0-180 and minutes between 0-60?
1650 '
1660 IF NOT (DG > 180 OR DG < 0 OR MN > 60 OR MN < 0) THEN GOTO 1750
1670 '
1680 '  Deg,min between correct limits
1690 '
1700 LOCATE 20,1:PRINT"Degrees are between 0 and 180 and Minutes are between 0 and 60.";:INPUT K$
1710 CLS:LOCATE 11,1:GOTO 1280
1720 '
1730 '  Convert to decimal
1740 '
1750 M1 = DG + (MN / 60)
1760 '
1770 '  E or W
1780 '
1790 I = I + 1
1800 EW$ = MID$(DL$,I,1)
1810 IF EW$ = "E" OR EW$ = "e" OR EW$ = "W" OR EW$ = "w" THEN GOTO 1900
1820 '
1830 '  Must be East or West
1840 '
1850 LOCATE 20,1:PRINT"Enter either E(ast) or W(est). ":INPUT"Any key to continue ";K$
1860 CLS:LOCATE 11,1:GOTO 1280
1870 '
1880 '  Put in correct sign for longitude
1890 '
1900 IF EW$ = "W" OR EW$ = "w" THEN M1 = -M1
1910 RETURN
1911 '
1920 '  ******
1930 '
1940 '  Module to get satellite name and longitude.
1950 '
1960 '  ******
1961 '
1970 CLS:LOCATE 3,1
1980 INPUT"What is the name of the satellite ? ",NS$
1990 LOCATE 5,1
2000 INPUT "Enter the Satellite longitude using SPACES to seperate DEGREES, MINUTES, and    E(ast) or W(est). ",SL$
2010 '
2020 '  Now decompose SL$ into degrees, minutes and E or W
2030 '  Do degrees first
2040 '
2050 LE = LEN(SL$)
2060 I = 1
2070 IF MID$(SL$,I,1) = CHR$(32) THEN GOTO 2190
2080 IF (I = LE) THEN GOTO 2140
2090 I = I + 1:GOTO 2070
2100 '
2110 '  Data is not in proper format
2120 '  Give error message and do again
2130 '
2140 LOCATE 20,1:PRINT"When you enter the longitude, be sure to use SPACES to seperate the entries. ":LOCATE 24,27:INPUT"Press Any key to continue!",KB$
2150 CLS:LOCATE 11,1:GOTO 1280
2160 '
2170 '  Get degrees
2180 '
2190 J = I - 1
2200 DG = VAL(MID$(SL$,1,J))
2210 '
2220 '  Now look for minutes
2230 '
2240 MN = 0:KK = 0
2250 I = I + 1
2260 IF MID$(SL$,I,1) = CHR$(32) THEN GOTO 2320
2270 IF (I = LE) THEN GOTO 2010
2280 I = I + 1:KK = 1:GOTO 2260
2290 '
2300 '  Get minutes
2310 '
2320 JK = I - 1
2330 IF KK <> 0 THEN MN = VAL(MID$(SL$,J + 1,JK))
2340 '
2350 '  Degrees between 0-180 and minutes between 0-60?
2360 '
2370 IF NOT (DG > 180 OR DG < 0 OR MN > 60 OR MN < 0) THEN GOTO 2460
2380 '
2390 '  Deg,min between correct limits
2400 '
2410 LOCATE 20,1:PRINT "Degrees are between 0 and 180 and minutes are between 0 and 60. ":INPUT "any key to continue ";K$
2420 CLS:LOCATE 5,1:GOTO 2000
2430 '
2440 '  Convert to decimal
2450 '
2460 M2 = DG + (MN / 60)
2470 '
2480 '  E or W
2490 '
2500 I = I + 1
2510 EW$ = MID$(SL$,I,1)
2520 IF EW$ = "E" OR EW$ = "e" OR EW$ = "W" OR EW$ = "w" THEN GOTO 2610
2530 '
2540 '  Must be east or west
2550 '
2560 LOCATE 20,1:PRINT "Enter either E(ast) or W(est). ":INPUT "Any key to continue ";K$
2570 CLS:LOCATE 11,1:GOTO 1280
2580 '
2590 '  Put in correct sign for longitude
2600 '
2610 IF EW$ = "W" OR EW$ = "w" THEN M2 = -M2
2620 RETURN
2621 '
2630 '  ******
2640 '
2650 '  Header module
2660 '
2670 '  ******
2671 '
2680 '  This module does the header and gives instructions as needed
2690 '
2700 COLOR 0,1:CLS
2710 LOCATE 10,20:COLOR 8,1 :PRINT"Geosynchronous Communications Satellite" :COLOR 0,1
2720 LOCATE 13,27:PRINT "Look Angle Calculator"
2730 FOR I = 1 TO 2000:NEXT I
2740 CLS:LOCATE 1,32:COLOR 8,1 :PRINT"G E O S A T" :COLOR 0,1
2750 LOCATE 8,1
2760 PRINT "This program will allow you to determine where you must  point your antenna to"
2770 PRINT "permit reception of signals transmitted from a Geosynchronous satellite."
2780 PRINT
2790 PRINT "If you need instructions on the operation of this program, press the <ESC> key,"
2800 PRINT "otherwise press the <RTN> key to start the program."
2840 LOCATE 23,4:PRINT"Press <ESC> to display the Instructions, or <RTN> to start the Program!";
2850 '
2860 '  What was entered?
2870 '
2880 KB$=INKEY$:IF KB$="" THEN 2880
2890 IF KB$=CHR$(27) THEN 2930 ELSE 6080
2900 '
2910 '  Give instructions
2920 '
2930 CLS:LOCATE 1,1:COLOR 8:PRINT TAB(34)"INSTRUCTIONS":COLOR 0:PRINT
2940 PRINT "    Whenever  there  are  parentheses around words or groups of letters in the "
2950 PRINT "instructions, this  means  that  the items inside the parentheses are optional."
2960 PRINT "Items inside the symbols < > are required operations or entries."
2970 PRINT
2980 PRINT TAB(28)"<SP>  is the space key."
2990 PRINT TAB(28)"<RTN> is the return key."
3000 PRINT TAB(28)"<ESC> is the escape key."
3010 PRINT : PRINT "    As a part of this program, there are 2 data sets.  One consists of a number"
3020 PRINT "of satellites and their longitudes.   The other is a number of cities and their"
3030 PRINT "latitudes and longitudes. For each data set, you will be asked whether you wish"
3040 PRINT "to use the information already in the program or wish to enter new information."
3050 PRINT "If you  choose to use the information  already in the program, simply enter the"
3060 PRINT "number that corresponds to the city or satellite you desire and press the <RTN>"
3070 PRINT "key."
3080 PRINT
3090 PRINT "   If you wish to enter your own city or satellite, press any key that does not"
3100 PRINT "correspond to a city or satellite and press <RTN>.  You will then be asked sev-"
3110 PRINT "eral questiones.  For NAMES OF SATELITES,  enter whatever you wish.  Use spaces"
3120 PRINT "and not commas as seperators if needed."
3130 PRINT:PRINT TAB(28)"Press <RTN> to continue!";
3140 KB$=INKEY$:IF KB$="" THEN 3140
3150 CLS:LOCATE 1,1:COLOR 8:PRINT TAB(34)"INSTRUCTIONS":COLOR 0:PRINT
3160 PRINT "    When LATITUDE information is requested, enter the data in the format:"
3170 PRINT :PRINT TAB(22)"DEGREES <SP> MINUTES <SP> N or S <RTN>"
3180 PRINT:PRINT "N(orth) or S(outh) must be enter,  but if you wish to skip the DEGREE or MINUTE"
3190 PRINT "entry just enter a space instead of the number.  Complete the entry by pressing"
3200 PRINT "<RTN>.  The same format is used for LONGITUDE data.  Just replace  N or S  with"
3210 PRINT "E(ast) or W(est)."
3211 PRINT:PRINT"   If the Elevation prints as `***', the satellite is below the horizon and is"
3212 PRINT "not in the `line of sight' of your installation."
3220 LOCATE 23,5:PRINT"Press <ESC> to re-display the Instructions, <RTN> to start the Program!";
3230 KB$=INKEY$:IF KB$="" THEN 3230
3240 IF KB$ <> CHR$(27) THEN 6000 ELSE 2930
3241 '
6000 '  ******
6010 '
6020 '  Initialization module
6030 '
6040 '  ******
6050 '
6060 '  Some constants
6070 '
6080 CLS:LOCATE 1,1:R=6378:H=35500!:PI=3.14159
6090 RD=360/(2*PI)
6100 '
6110 '  Arcsin defination
6120 '
6130 DEF FN ARCSYN(X)=ATN(X/SQR(-X*X+1))
6140 '
6150 '  Modulus definition
6160 '
6170 DEF FN MUD(Z)=INT((Z/ZF-INT(Z/ZF))*ZF+.05)*SGN(Z/ZF)
6180 '
6190 '  Read in the satellite parameters
6200 '
6210 RESTORE
6220 '
6230 '  N is the number or satellites in the lins
6240 '
6250 READ N
6260 '
6270 '  SN$( is name array and SN( is longitude array
6280 '
6290 IF FG=1 THEN GOTO 6340
6300 DIM SN$(N),SN(N),DS$(N),DS(N),P$(24),S%(2)
6310 '
6320 '  P$( is printer buffer
6330 '
6340 FOR I=1 TO N
6350 READ SN$(I)
6360 READ SN(I)
6370 NEXT I
6380 SN(0)=N
6390 '
6400 '  A( is look azimuth array and E( is look elevation array
6410 '
6420 IF FG=1 THEN GOTO 6470
6430 DIM A(N),E(N)
6440 '
6450 '  Read in city parameters, m is number of cities
6460 '
6470 READ M
6480 '
6490 '  Cn$( is city name array, CL( is city latitude array
6500 '  CM( is city longitude array
6510 '
6530 IF FG=1 THEN GOTO 6550
6540 DIM CN$(M),CL(M),CM(M)
6550 FOR I=1 TO M
6560 READ CN$(I)
6570 READ CL(I)
6580 READ CM(I)
6590 NEXT I
6600 CL(0)=M
6601 '
7000 '  ******
7010 '
7020 '  This module gives the city list along with the option of choosing one
7021 '  of the stored cities or entering a new one
7030 '
7040 '  ******
7041 '
7050 CLS:LOCATE 1,1
7060 PRINT "These cities are available:":LOCATE 5,1
7070 '
7080 '  Get number of cities. If >30 then truncate.
7090 '
7100 M=CL(0)
7110 IF M>30 THEN M=30
7120 '
7130 '  Determine number of rows of dual column printing needed
7140 '
7150 M1=M/2:M2=INT(M1):MP=M1-M2
7160 '
7170 '  Default tab offset positions
7180 '
7190 HL=11:HR=51
7200 FOR I=1 TO M2
7210 J=I+M2
7220 '
7230 '  If MP=0 there will be 2 columns on each row.  Otherwise there will be
7231 '  an extra row.
7240 '
7250 IF MP<>0 THEN J=J+1
7260 '
7270 '  Gosub determines the number of digits in I,J
7280 '
7290 GOSUB 30000
7300 PRINT TAB(HL-H1);I;TAB(HL+2);CN$(I);TAB(HR-H2);J;TAB(HR+2);CN$(J)
7310 NEXT I
7320 IF MP<>0 THEN GOSUB 30000:PRINT TAB(HL-H1);I;TAB(HL+2);CN$(I)
7330 '
7340 '  Get choice of city.  only one at a time!!!
7350 '
7360 LOCATE 21,1:PRINT "Enter your choice by indicating:":PRINT
7370 PRINT "      A number between 1 and";M;:INPUT ", or press any other key for a new city! ",KB$
7400 '
7410 '  What is KB$
7420 '
7430 CK=VAL(KB$)
7440 IF CK<1 OR CK>M THEN GOSUB 580:CK=M+1
7450 '
7460 '  Now do satellite
7470 '
8000 '  ******
8010 '
8020 '  This module gives the satellite list along with the option of using
8021 '  all the stored names or entering a new one
8030 '
8040 '  ******
8041 '
8050 CLS:LOCATE 2,1:PRINT "These satellites are available:":LOCATE 5,1
8070 '
8080 '  Get number of satellites.  If >30 then truncate
8090 '
8100 N=SN(0)
8110 IF N>30 THEN N=30
8120 '
8130 '  Determine number of dual column printings needed
8140 '
8150 N1=N/2:N2=INT(N1):NP=N1-N2
8160 '
8170 '  Default tab offset positions
8180 '
8190 HL=11:HR=51
8200 FOR I=1 TO N2
8210 J=I+N2
8220 '
8230 '  If NP=0 then there will be 2 columns for each row.  Otherwise, an
8231 '  extra row is needed
8240 '
8250 IF NP<> 0 THEN J=J+1
8260 '
8270 '  Gosub determines the number of digits in I,J
8280 '
8290 GOSUB 30000
8300 PRINT TAB(HL-H1);I;TAB(HL+2);SN$(I);TAB(HR-H2);J;TAB(HR+2);SN$(J)
8310 NEXT I
8320 IF NP<>0 THEN GOSUB 30000:PRINT (HL-H1);I;TAB(HL+2);SN$(I)
8330 '
8340 '  Now get choice of which satellite(s) to use
8350 '
8360 LOCATE 20,1:PRINT "Enter your choice by indicating:":PRINT
8370 PRINT "A number between 1 and";N;:INPUT ", Zero(0) for all, or any other key to enter the name of a new Satellite! ",KB$
8390 '
8400 '  What is KB$
8410 '
8420 SQ=ASC(KB$)
8430 SK=VAL(KB$)
8440 '
8450 '  Go get a new satellite?
8460 '
8470 IF SK=0 AND (SQ<48 OR SQ>57) THEN GOSUB 1970:SK=N+1
8471 '
9000 '  ******
9010 '
9020 '  Setup City, Satellite parameters prior to AZ,EL Calculation
9030 '
9040 '  ******
9050 '
9060 '  Do city first
9070 '
9080 IF CK>M THEN DC$=NC$
9090 IF CK<=M THEN DC$=CN$(CK):L1=CL(CK):M1=CM(CK)
9100 '
9110 '  Do satellite.  First setup default name array
9120 '
9130 N=SN(0)
9140 FOR I=0 TO N
9150 DS$(I)=SN$(I)
9160 DS(I)=SN(I)
9170 NEXT I
9180 '
9190 '  If sk=0 use all
9200 '
9210 IF SK=0 THEN GOTO 9350
9220 '
9230 '  Distinguish between sk=1,n and sk>n
9240 '
9250 DS(0)=1
9260 IF SK>N THEN GOTO 9300
9270 DS$(1)=DS$(SK)
9280 DS(1)=DS(SK)
9290 GOTO 9350
9300 DS$(1)=NS$
9310 DS(1)=M2
9320 '
9330 '  Now do AZ,EL Calculation
9340 '
9350 MX=DS(0)
9360 FOR I=1 TO MX
9370 M2=DS(I)
9380 GOSUB 140
9390 A(I)=Y:E(I)=EL
9400 NEXT I
9401 '
10000 '  ******
10010 '
10020 '  This module does the screen display of the calculations results
10030 '
10040 '  ******
10090 '
10140 '  Some defaults:  lines/page;start line;stop line;AZ,EL tabs
10150 '
10160 LP=15:ST=1:SP=LP:HL=50:HR=60
10170 '
10180 '  Determine number of display pages
10190 '
10200 Z1=INT(N/15)
10210 ZP=Z1+1
10220 '
10230 '  Display page loop
10240 '
10250 FOR ZQ=1 TO ZP
10260 GOSUB 11050
10270 LOCATE 8,1
10280 IF DS(0)<SP THEN SP=DS(0)
10290 FOR ZR=ST TO SP
10300 I=A(ZR):J=E(ZR)
10310 GOSUB 30000
10320 PRINT TAB(22);DS$(ZR);TAB(HL-H1);I;:IF J >-0 THEN PRINT TAB(HR-H2);J:GOTO 10330
10325 PRINT TAB(HR-2)"***"
10330 NEXT ZR
10340 LOCATE 24,19:INPUT"Enter <P> to print, or Press <RTN> to continue! ",KB$
10350 '
10360 '  If KB$= "P" then goto print routine
10370 '
10380 IF LEFT$(KB$,1) = "P" OR LEFT$(KB$,1) = "p" THEN GOSUB 50000
10390 ST=SP+1:SP=SP+LP:CLS
10400 NEXT ZQ
10410 '
10420 '  Do another set?
10430 '
10440 LOCATE 24,8
10460 PRINT "Press <RTN> to run the program again, or <ESC> to exit to Basic.";
10470 KB$ = INKEY$:IF KB$ = "" THEN 10470
10480 IF KB$=CHR$(13) THEN FG=1:GOTO 6080
10490 IF KB$=CHR$(27) THEN GOTO 10520
10500 GOTO 10440
10520 CLS:LOCATE 1,1:RUN"SDIR.BAS"
10530 END
10540 '
11000 '  ******
11010 '
11020 '  Header subroutine
11040 '
11041 '  ******
11042 '
11050 CLS:LOCATE 1,23:COLOR 8,1:PRINT "G E O - S A T E L L I T E   `Look  Angle'":COLOR 0,1
11060 LOCATE 3,10:PRINT "From: ";DC$
11070 LOCATE 5,51:PRINT "Antenna"
11080 PRINT TAB(24);"To";TAB(46);"Azimuth";TAB(55);"Elevation"
11090 RETURN
20000 '
20001 '  ******
20002 '
20010 '  Data statements
20020 '
20021 '  ******
20022 '
20030 DATA 12
20040 DATA Comstar 3,-87
20050 DATA Westar 3,-91
20060 DATA Comstar 2,-95
20070 DATA Westar 1,-99
20080 DATA Anik 1,-104
20090 DATA Anik 2,-109
20100 DATA Anik 3,-114
20110 DATA Satcom 2,-119
20120 DATA Westar 2,-123.5
20130 DATA Comstar 1,-128
20140 DATA Satcom 3,-132
20150 DATA Satcom 1,-135
20160 DATA 17
20170 DATA Washington D.C.,39,-77
20180 DATA Los Angeles Cal.,34,-118
20190 DATA New York NY.,40.75,-74
20200 DATA Atlanta Ga.,33.5,-84.5
20210 DATA Miami Fl.,25.75,-80.25
20220 DATA Jacksonville Fl.,30.5,-81.5
20230 DATA Tampa Fl.,28,-82.75
20240 DATA Anchorage Al.,60.8,-147
20250 DATA Nome Al.,65,-165
20260 DATA Phoenix Arz.,33.5,-112
20270 DATA Little Rock Ark.,34.75,-92.25
20280 DATA Portland Ore,45.5,-122.75
20290 DATA Seattle Wash.,47.5,-122.5
20300 DATA San Francisco Cal.,37.75,-122.5
20310 DATA Chicago Ill.,41.75,-87.75
20320 DATA Milwaukee Wisc.,43,-87.9
20330 DATA San Diego Cal.,32.65,-117.3
29970 '
29971 '  ******
29972 '
29980 '  Tab positioning Routine
29981 '
29982 '  ******
29990 '
30000 H1=3:H2=3
30010 IF I<100 THEN H1=2
30020 IF I<10 THEN H1=1
30030 IF J<100 THEN H2=2
30040 IF J<10 THEN H2=1
30050 RETURN
49950 '
49951 '  ******
49952 '
49960 '  Printer routine
49970 '
49971 '  ******
49972 '
49980 '  Follows screen format shown on page 30 of IBM Internal newsletter #2
49990 '
50000 S%(1) = &H5CD   'CD 05     INT 5
50010 S%(2) = &HCB     'RET
50020 SUBRT% = VARPTR(S%(1))
50030 CALL SUBRT%
50040 FOR L = 1 TO 7:LPRINT:NEXT L
50050 RETURN
