Quarterdeck Technical Note

Subject:  Patching Optimize 2.0 to resolve problems where, under some
circumstances, Optimize will forget during its final phase that it required
the Squeeze feature.

Background: Many TSRs and device drivers take up more memory when they
initialize than they require when they are resident. Optimize's Squeeze
feature allows such programs, when they do not use EMS, to load partially
into the page frame provided that they shrink down to a size that won't leave
part of the program in the page frame.  Under QEMM-386, the Squeeze feature
can also make temporary use of ROM areas for loading high, provided that
the ROM is not used while the program is initializing.

Under some circumstances when Optimize 2.0 reaches the "ideal" result - that
is, nothing in conventional memory and nothing in the largest high RAM region
- and it required Squeeze to reach this result, Optimize will forget during
its final phase that it required Squeeze.  There is no workaround other than
running Optimize with the /NOSQF and /NOSQT parameters to disable Squeeze. 
The problem should, however, not occur very often.  The symptom of this
problem is that a program that is supposed to be loaded into high memory
evokes the LOADHI message "Not enough room to load <program> high.  Loading
low:" on the final phase of OPTIMIZE.

This patch, which resolves the above problem, only works on Optimize version
2.00, which has a date of 8/23/91 or 8/28/91 and comes with either QEMM-386
V6.00 or DESQview-386 V2.40.  Earlier and later versions of Optimize do not
exhibit this problem and do not require this patch.

***************************************************
1)    Change to your QEMM directory.

2)    Copy the original OPTIMIZE.COM file so that if you make a
mistake you will be able to restore from a good copy.  Type

                  COPY OPTIMIZE.COM OPTIMIZE.OLD

at the DOS prompt.

3)  In order for DEBUG to process Optimize correctly, you need to
rename it.  At the DOS prompt, type

                        REN OPTIMIZE.COM X

4)  Now, load the file called X into DEBUG by typing

                             DEBUG X

at the DOS prompt.  Make sure that DEBUG is in your path or that
you precede DEBUG with the path where DOS can find it.  If all
works out, you should see a hyphen (-) for a prompt.  This is the DEBUG
prompt.

5)  Now make sure that the registers in the microprocessor are in
the correct state by typing R at the DEBUG prompt.  You should
get something like this:

AX=0000  BX=0001  CX=15C5  DX=0000  SP=FFEE  BP=0000  SI=0000 DI=0000
DS=xxxx  ES=xxxx  SS=xxxx  CS=xxxx  IP=0100   NV UP EI PL NZ NA PO NC
xxxx:0100 4D            DEC     BP

Make sure that BX is equal to 0001 and that CX is equal to 15C5.
If BX and CX are not equal to these values, then you should not
continue with the patch.  Type

                                Q

at the DEBUG prompt to quit out of DEBUG if BX is not 0001 and CX is not
15C5.


6)  If the BX and CX values are correct, type

                   S CS:100 FFFF e8 e9 e3 72 05

at the DEBUG prompt.  This will return a number with the form of xxxx:5C45. 
If the number that returns does not have a 5C45 after the colon, DO
NOT APPLY THIS PATCH.  If the wrong number returns, type

                   Q

at the DEBUG prompt to quit out of DEBUG.



7)  If the number that returns is xxxx:5C45, type

                              E 5C48

DEBUG should respond with

                          xxxx:5C48 72.

8)  Now type

                                EB

at the DEBUG prompt and hit the Enter key.  This will make the only change
that you need to make in the file.

9)  Now save your work by typing

                                W

at the DEBUG prompt.    It should say

                       Writing 115C5 bytes
                                or
                        Writing 15C5 bytes

depending on the version of DOS you are using.

10) Now you can quit DEBUG by typing

                                Q

at the DEBUG prompt.  This will drop you back to the DOS prompt.

11) Rename X back to OPTIMIZE.COM by typing

                        REN X OPTIMIZE.COM

at the DOS prompt.

You should be able to run Optimize successfully now.

--------------------------------------------------

If Optimize fails after you perform this patch, you can recover
your backup of Optimize by typing

                  COPY OPTIMIZE.OLD OPTIMIZE.COM

at the DOS prompt.

You may then wish to try the above procedure again, in case a mistake was
made.


             * * *   E N D   O F   F I L E    * * *

