	PAGE	60, 80
TITLE	LPTCOM	15-APR-88	XON/XOFF Printer Interface on COM

;-----------------------------------------------------------------------|
;									|
;	XON/XOFF Printer Interface					|
;		Installed as "terminate and stay resident" program	|
;									|
;-----------------------------------------------------------------------|
;	REVISION HISTORY						|
;									|
; Number    DD-MMM-YY             WHO                     WHY		|
;-------|---------------|-----------------------|-----------------------|
; 0.1   |   01-Apr-88   | Frank Waldner         | Initial release       |
;-----------------------------------------------------------------------|

COM1    EQU     03F8H                   ; Base address COM1
COM2    EQU     02F8H                   ; Base address COM2
COMport EQU     COM1                    ; Use COM1

RBRport	EQU	COMport			; Receiver Buffer Register      xx8
IERport	EQU	COMport+1		; Interrupt Enable Register     xx9
IIRport	EQU	COMport+2		; Interrupt ID Register         xxA
MCRport	EQU	COMport+4		; Modem Control Register        xxC
LSRport	EQU	COMport+5		; Line Status Register          xxD
MSRport	EQU	COMport+6		; Modem Status Register         xxE
THRport EQU	RBRport			; Transmit Holding Register     xx8

RBF     EQU     1                       ; Receive Buffer Full
THRE	EQU	20H			; Transmit Holding Register Empty

XOFF	EQU	'S' - 40H
XON	EQU	'Q' - 40H

CR      EQU     0DH
LF      EQU     0AH

;-----------------------------------------------------------------------|
;	The Usual Stuff							|
;-----------------------------------------------------------------------|

cGroup	Group	Code

Code	Segment Public 'Code'

	Assume	CS:Code, DS:Code, ES:Code, SS:Code

	Org	100H

LPTCOM:
	
JMP	Install 			; install traps

	PAGE
;-----------------------------------------------------------------------|
;	Printer interrupt handler					|
;									|
;	ENTRY :	as for printer interrupt (INT 17H)			|
;                                                                       |
;       (AH)=0  Print character in AL on Err AH = 1                     | 
;       (AH)=1  Init printer port            AH = Printer Status        | 
;       (AH)=2  Read printer status          AH = Printer Status        | 
;                                                                       | 
;       (DX) = Printer number (0,1,2,etc.)                              | 
;									| 
;	EXIT :	ditto							|
;									|
;-----------------------------------------------------------------------|

Handler	Proc	Far

	STI
	TEST	AH,AH			; output request ??
	JNZ	Hand3			; if NZ: return status

Hand1:
	PUSH	BX			; (+1) save
	PUSH	DX			; (+2)
	MOV	BL,AL			; save char
Hand1a:
	MOV	DX,LSRport

Hand2:
	IN	AL,DX			; get line status
        TEST    AL,RBF                  ; receive buffer full ?
        JZ      Hand2a                  ; if z, no

        MOV     DX,RBRport              ; else point to RB port
        IN      AL,DX                   ; get char
	AND	AL,7FH                  ; filter to 7 bits

	CMP	AL,XOFF                 ; was XOFF received ?
        JNE     Hand1a                  ; if ne, no reason to stop
Xpause:
        MOV     DX,LSRport              ; point to LS port
Xwait:
        IN      AL,DX                   ; get line status
        TEST    AL,RBF                  ; receive buffer full ?
        JZ      Xwait                   ; if z, no, wait some more

        MOV     DX,RBRport              ; point to RB port
        IN      AL,DX                   ; get char
        AND     AL,7FH                  ; filter to 7 bits
	CMP	AL,XON                  ; was XON received ?
        JNE     Xpause                  ; if ne, something else
        JMP     Hand1a                  ; try again
Hand2a:
	TEST	AL,THRE			; transmit holding register empty ??
	JZ	Hand2			; if Z: uart not ready yet, loop

	MOV	AL,BL
	MOV	DX,THRport		; transmit port
	OUT	DX,AL			; transmit

	POP	DX			; (+1) restore
	POP	BX			; (+0)

Hand3:
	MOV	AH,90H
	IRET

Handler	EndP

	PAGE
;-----------------------------------------------------------------------|
;	XON/XOFF Printer Interface					|
;									|
;	ENTRY :	normal COM program entry				|
;									|
;	EXIT :	Terminate / Stay Resident				|
;									|
;-----------------------------------------------------------------------|

Install	Proc	Near

	MOV	DX,Offset Handler	; first take over INT 17 vector
	MOV	AX,2517H
	INT	21H

        CLI

	MOV	DX,MCRport		; get status of MCR
	IN	AL,DX
	OR	AL,0FH			; set DTR, RTS, OUT1, OUT2
	OUT	DX,AL			; init MCR

	MOV	DX,LSRport		; clear pending status
	IN	AL,DX
	MOV	DX,RBRport
	IN	AL,DX
	MOV	DX,IIRport
	IN	AL,DX
	MOV	DX,MSRport
	IN	AL,DX

	STI

        MOV     AH,09                   ; DOS9 = Print string
        MOV     DX,Offset Insmsg        ; DS:DX -> message
        INT     21H                     ; DOSint

	MOV	DX,Offset Install	; DS:DX -> end of "keep" area
	INT	27H			; terminate / stay resident

Install	EndP

Insmsg  DB      CR,LF,'LPT: redirected to COM'
        DB      '2'-((COMport-COM2)/100H)
        DB      ':',CR,LF,'$'

Code	EndS

	END	LPTCOM			; of LPTCOM
