/*--------------------------------------------------------------------------
 * File : proto.h
 *
 * $Id: proto.h,v 1.2 2000/01/17 21:04:07 mike Exp $
 *------------------------------------------------------------------------*/

#ifndef _PROTO_H_DEFINED
#define _PROTO_H_DEFINED

/*************/
/*  fpcmd.c  */
/*************/

extern	void	plot_raw_file(void);
extern	void	plot_command_file(void);
extern	void	parse_reset_command(int);
extern	int	get_data_from_command_file(void);
extern	void	generate_plot(int, int);
extern	void	invalid_set_command(int, int);
extern	int	auto_parse_field_defs(char *);
extern	void	auto_scale_axis(void);
extern	int	parse_line_into_fields(char *);
extern	int	reset_field_count(int);

/*************/
/*  fplib.c  */
/*************/

extern	long    convert_string_to_ps(char*, char *);
extern	void	format_double(double, char *);
extern	void	scale_values(int, double *, double *, int *);
extern	void	rescale_divisions(int, int, double *, double *);
extern	void	adjust_min_max(double *, double *);
extern	void    *memory_allocate(unsigned int);
extern	void	memory_free(void *);
extern	int	get_malloc_free_counter(void);
extern	void	get_tmp_file(char *);
extern	void	get_tmp_2(char *);

#ifdef  MSDOS
extern	void	fill_tmpvar_2(char *);
#endif

extern	void	error_tmp_file(void);
extern	char	*replace_crlf(char *);
extern	void	delete_file(char *);
extern	char    *filter_input_string(char *);
extern	char    *lowercase(char *);
extern	int     strposition(char *, char *);

/*************/
/*  fplot.c  */
/*************/

extern	void	init_ctrl_c_handler(void);
extern	void	show_usage(void);
extern	void	init_globals(void);
extern	void    exit_program(int);

/*************/
/*  fpout.c  */
/*************/

extern	void	output_epson_lq_plot(void);
extern	void	output_epson_fx_plot(void);
extern	void	output_hpgl2_plot(void);
extern	void	output_postscript_plot(void);
extern	void	ps_print_header(void);
extern	void	ps_print_dict(void);
extern	void	ps_print_plot(void);
extern	void	ps_print_box_labels_data(void);
extern	void	ps_print_trailer(void);
extern	void    get_xy_coord_labels(int, char *, double, double, double, 
				    char *, long *, long *);

/*************/
/*  fpset.c  */
/*************/

extern	void	parse_set_command(int);

#endif  /* _PROTO_H_DEFINED */
/*------------------------------------------------------------------------*/
