/*--------------------------------------------------------------------------
 * File : fplot.h
 *
 * $Id: fplot.h,v 1.13 2000/01/10 05:15:55 mike Exp $
 *------------------------------------------------------------------------*/

#ifndef _FPLOT_H_DEFINED
#define _FPLOT_H_DEFINED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <memory.h>
#include <ctype.h>
#include <signal.h>

#ifdef MSDOS
#include <process.h>
#else
#include <unistd.h>
#endif

#ifdef FALSE
#undef FALSE
#endif

#ifdef TRUE
#undef TRUE
#endif

#define FALSE 0
#define TRUE  1

#define NF 80                 /* num fields       (in g_fields) */
#define CPF 256               /* char's per field (in g_fields) */

#define MAX_LABELS            128
#define MAX_LABELS_PLUS_1     (1+MAX_LABELS)

#define MAX_LINE_LENGTH       8100

#define BIG_BUF_SIZE          16384

#define SPECIAL_BREAK_VALUE   -7.6E+300
#define SPECIAL_BREAK_FLAG    -7.5E+300

#define FORMAT_POSTSCRIPT     1001     /* only postscript supported now */
#define FORMAT_HPGL2          1101
#define FORMAT_EPSON_LQ       1201
#define FORMAT_EPSON_FX       1202

#define X_AXIS_SCALE_LINEAR   3001     /* only linear & log supported now */
#define X_AXIS_SCALE_LOG      3002
#define X_AXIS_SCALE_DATE     3003

#define GRID_LINES_ON         7001
#define GRID_LINES_OFF        7002
#define GRID_LINES_TICK       7003

#define GRAPH_TYPE_LINES             8001
#define GRAPH_TYPE_POINTS            8002
#define GRAPH_TYPE_LINES_AND_POINTS  8003
#define GRAPH_TYPE_BAR               8004    /* BAR not supported yet */

#define RAW_FILE     101
#define COMMAND_FILE 102

#endif  /* _FPLOT_H_DEFINED */
/*------------------------------------------------------------------------*/
