;
; portfolio-specific code
;
; this will be called by the packet driver if the symbol PORTFOLIO is
; defined in PPP.ASM, otherwise a standard PC is assumed and don't link this
; in
;
	public UninstallPortfolioInterrupt
	public InstallPortfolioInterrupt
	public CheckForPortfolio
CGROUP group TSR,CONFIG
	assume cs:cgroup,ds:cgroup
TSR segment word public 'CODE'
portbase	dw	0		; PORT base we will load from $40:0
;
; this is the resident portion of these routines, used to turn off the
; interrupt when we uninstall the TSR
;
UnInstallPortfolioInterrupt PROC
	mov 	ah,1ch
	mov 	al,0
	mov 	bh,5
	mov 	bl,48h
	mov 	dx,0
	int 	61h
	mov	al,48h
	mov	dx,[portbase]
	add	dl,0fh
	out	dx,al
	ret
UnInstallPortfolioInterrupt ENDP
TSR	ENDS
;
; non-resident portion of these routines
;
CONFIG	segment word public 'CODE'
;
; the ROM code to check if this is actually a portfolio
;
cdip db	"(C) DIP"
CDL EQU $ - cdip
;
; messages related to this feature
;
errmsg	db "This version of PPP must run on a Portfolio$"
nosermsg db "No serial ports are installed$"
;
; install the selected intterupt, AL = interrupt number coming in
;
InstallPortfolioInterrupt PROC
	push	ax
	sub	ax,ax
	int 	61h
	mov	ax,1c00h
	pop	bx	; bl has int #
	mov 	bh,5
	mov 	dx,[portbase]
	add	dl,0fh
	int 	61h
	ret
InstallPortfolioInterrupt ENDP
;
; check if we actually are running on a portfolio
; and if a serial port is installed
;
CheckForPortfolio PROC
	mov	si,offset cgroup:cdip
	mov	ax,0f000h
	mov	es,ax
	mov	di,0FFE6H
	mov	cx,CDL
	repe	cmpsb
	jnz	cperr
	int	011h
	and	ah,0eh
	jz	noserport	
	mov	ax,40h
	mov	es,ax
	mov	ax,es:[0]
	mov	[portbase],ax
	ret
noserport:
	mov	dx,offset cgroup:nosermsg
	jmp	exit
cperr:
	mov	dx,offset cgroup:errmsg
exit:
	mov	ah,9
	int	21h
	mov	ax,4c01h
	int	21h
CheckForPortfolio ENDP
CONFIG	ENDS
	end