 REM file: Sic.inc v6.9a r1.0 - Symbolic Instruction Code; include module.
 REM The public domain DOS programming interpreter.

 REM $DYNAMIC
 DEFINT A-Z

 ' get include files
 REM $INCLUDE: 'bpb.bi'
 REM $INCLUDE: 'dta.bi'
 REM $INCLUDE: 'qbx.bi'
 REM $INCLUDE: 'fat32.bi'

 ' boolean constants
 CONST Dfalse=0#
 CONST Dtrue=-1#
 CONST False=0
 CONST True=-1

 ' color constants
 CONST Black=0
 CONST Plain=7
 CONST Green=10
 CONST Cyan=11
 CONST Red=12
 CONST Magenta=13
 CONST Yellow=14
 CONST White=15

 ' constant declarations
 CONST ErrorList="sic69a.dat"
 CONST Max.Arrays=128 ' can be changed
 CONST Max.Functions=26 ' can be changed
 CONST Max.Lines=2048 ' can be changed
 CONST Max.Recurse=8 ' can be changed
 CONST MaxCommands=18 ' cannot be changed
 CONST MaxStatements=138 ' cannot be changed
 CONST Nul=""
 CONST PublishDate="10/29/2001"
 CONST Release="1.0"
 CONST Version="6.9a"

 ' global variables
 COMMON SHARED Allow.Alpha AS INTEGER
 COMMON SHARED Allow.Extra AS INTEGER
 COMMON SHARED Array.Size AS INTEGER
 COMMON SHARED Assign AS INTEGER
 COMMON SHARED ASCIZ AS STRING * 260
 COMMON SHARED CaseStrng AS STRING
 COMMON SHARED CaseValue AS DOUBLE
 COMMON SHARED CaseValue1 AS DOUBLE
 COMMON SHARED CaseValue2 AS DOUBLE
 COMMON SHARED CaseValueS1 AS STRING
 COMMON SHARED CaseValueS2 AS STRING
 COMMON SHARED CommandLine AS STRING
 COMMON SHARED ControlBreak AS INTEGER
 COMMON SHARED CurrentDirectory AS STRING
 COMMON SHARED DataLine AS INTEGER
 COMMON SHARED DataNumber AS INTEGER
 COMMON SHARED DataValue AS DOUBLE
 COMMON SHARED DEFSEGvalue AS DOUBLE
 COMMON SHARED ErrorLine AS INTEGER
 COMMON SHARED ErrorType AS INTEGER
 COMMON SHARED ErrorValue AS INTEGER
 COMMON SHARED ExceptStep AS DOUBLE
 COMMON SHARED ExceptStepIs AS INTEGER
 COMMON SHARED FieldVariable AS INTEGER
 COMMON SHARED Filename AS STRING
 COMMON SHARED FileNumber AS INTEGER
 COMMON SHARED FinishFor AS DOUBLE
 COMMON SHARED Recurse AS INTEGER
 COMMON SHARED RecurseNest AS INTEGER
 COMMON SHARED InDEFSEG AS INTEGER
 COMMON SHARED InDEFSEG2 AS INTEGER
 COMMON SHARED LastCursor1 AS INTEGER
 COMMON SHARED LastCursor2 AS INTEGER
 COMMON SHARED LastCursor3 AS INTEGER
 COMMON SHARED LastColor1 AS INTEGER
 COMMON SHARED LastColor2 AS INTEGER
 COMMON SHARED LastScreen1 AS INTEGER
 COMMON SHARED LastScreen2 AS INTEGER
 COMMON SHARED LastScreen3 AS INTEGER
 COMMON SHARED LastScreen4 AS INTEGER
 COMMON SHARED LastWidth1 AS INTEGER
 COMMON SHARED LastWidth2 AS INTEGER
 COMMON SHARED Last.Line AS INTEGER
 COMMON SHARED Last.Search.Case AS INTEGER
 COMMON SHARED Last.Search.Line AS INTEGER
 COMMON SHARED Last.Search.Keyword AS STRING
 COMMON SHARED Last.Token AS INTEGER
 COMMON SHARED LineFeed AS INTEGER
 COMMON SHARED Max.Errors AS INTEGER
 COMMON SHARED Max.Gosubs AS INTEGER
 COMMON SHARED Nested.Gosub AS INTEGER
 COMMON SHARED OperatingSystem AS STRING
 COMMON SHARED Out2 AS STRING
 COMMON SHARED Out3 AS STRING
 COMMON SHARED Out4 AS STRING
 COMMON SHARED PageLength AS INTEGER
 COMMON SHARED Printing AS INTEGER
 COMMON SHARED PrinterLF AS INTEGER
 COMMON SHARED Prepare.Filename AS STRING
 COMMON SHARED Program.Line AS INTEGER
 COMMON SHARED Program.Name AS STRING
 COMMON SHARED Program.Resume AS INTEGER
 COMMON SHARED Quotes AS INTEGER
 COMMON SHARED Run.Line AS INTEGER
 COMMON SHARED Run.Type AS INTEGER
 COMMON SHARED StepTo AS DOUBLE
 COMMON SHARED SaveOnExit AS INTEGER
 COMMON SHARED ScreenHeight AS INTEGER
 COMMON SHARED ScreenMode AS INTEGER
 COMMON SHARED ScreenWidth AS INTEGER
 COMMON SHARED StdinInput1 AS INTEGER
 COMMON SHARED StdinInput2 AS STRING
 COMMON SHARED StdinPrompt AS INTEGER
 COMMON SHARED Supported.Call AS INTEGER
 COMMON SHARED Strng AS STRING
 COMMON SHARED Token AS INTEGER
 COMMON SHARED Token.Index AS INTEGER
 COMMON SHARED Token.List AS STRING
 COMMON SHARED Unless.Branch AS INTEGER
 COMMON SHARED Unless.Value AS DOUBLE
 COMMON SHARED ValueIs AS DOUBLE
 COMMON SHARED Visible AS INTEGER
 COMMON SHARED Var.Seg1 AS STRING
 COMMON SHARED Var.Seg2 AS DOUBLE
 COMMON SHARED White.Space AS STRING
 COMMON SHARED Windows.Detected AS INTEGER

 ' common interrupt registers
 COMMON SHARED AX AS DOUBLE
 COMMON SHARED BX AS DOUBLE
 COMMON SHARED CX AS DOUBLE
 COMMON SHARED DX AS DOUBLE
 COMMON SHARED BP AS DOUBLE
 COMMON SHARED SI AS DOUBLE
 COMMON SHARED DI AS DOUBLE
 COMMON SHARED FL AS DOUBLE
 COMMON SHARED DS AS DOUBLE
 COMMON SHARED ES AS DOUBLE

 ' program areas
 COMMON SHARED Commands() AS STRING ' stores all .sic menu commands
 COMMON SHARED Statements() AS STRING ' stores all .sic program commands
 COMMON SHARED LineBreak() AS INTEGER ' stores line break flags
 COMMON SHARED VariableBreak() AS INTEGER ' stores variable break flags
 COMMON SHARED VariableValue() AS DOUBLE ' stores variable values for break
 COMMON SHARED VariableBreak2() AS INTEGER ' stores variable break flags
 COMMON SHARED VariableValue2() AS STRING ' stores variable values for break
 COMMON SHARED VariableBreak3() AS INTEGER ' stores variable break flags
 COMMON SHARED VariableValue3() AS DOUBLE ' stores variable values for break

 ' code areas
 COMMON SHARED GosubReturn() AS INTEGER ' stack space for gosubs
 COMMON SHARED Program() AS STRING ' storage space for .sic program

 ' data areas
 COMMON SHARED Arrays() AS DOUBLE ' variable arrays A() to Z()
 COMMON SHARED Strngs() AS STRING ' string variables A$ to Z$
 COMMON SHARED Variables() AS DOUBLE ' variables A to Z
 COMMON SHARED Definitions() AS STRING ' DEF FN functions
 COMMON SHARED Errors() AS STRING * 64 ' error messages

 ' subroutine area
 COMMON SHARED Renumber.List() AS INTEGER ' space for renumber subroutine

 ' file areas
 COMMON SHARED Field.Array() AS STRING
 COMMON SHARED File.Fields() AS STRING

 ' graphics areas
 COMMON SHARED Graphics.Screen() AS INTEGER
 COMMON SHARED Var.Seg3() AS INTEGER

 ' declare registers from qbx.lib/vbdos.lib
 COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX

 ' declare program dta
 COMMON SHARED BASIC.DTA.SEG AS INTEGER, BASIC.DTA.OFF AS INTEGER

 ' declare structures
 COMMON SHARED BPBfile AS BPBtype
 COMMON SHARED FAT32struc AS FAT32Type
 COMMON SHARED ParseDTA AS DTAtype

 ' subroutine declarations
 DECLARE SUB Analyze.Program()
 DECLARE SUB Arith(V$, V1#, V2#)
 DECLARE SUB Assign.End()
 DECLARE SUB Assignment1(V$, V%)
 DECLARE SUB Assignment2(V$, V1%, V2%)
 DECLARE SUB Assignment3(V$, V1$)
 DECLARE SUB Assignment4(V$, V1$)
 DECLARE SUB Count.Lines(V%)
 DECLARE SUB Decrease.PSP()
 DECLARE SUB Display.Error()
 DECLARE SUB Debug.Command()
 DECLARE SUB End.Program()
 DECLARE SUB Enter.Equate()
 DECLARE SUB Enter.Program.Line()
 DECLARE SUB Equate(V#)
 DECLARE SUB Execute.Command(V$)
 DECLARE SUB Get.Token()
 DECLARE SUB Get.Token2(V%)
 DECLARE SUB Get.Token3()
 DECLARE SUB Get.Token4()
 DECLARE SUB Indent.Program(V%)
 DECLARE SUB Key.Prompt()
 DECLARE SUB Kill.Program(V$)
 DECLARE SUB List.Files(V$)
 DECLARE SUB List.Help()
 DECLARE SUB List.Help.File()
 DECLARE SUB List.Program(V1%, V2%, V3%)
 DECLARE SUB Load.Program(V$)
 DECLARE SUB More.Prompt(V1$, V2$, V$)
 DECLARE SUB New.Program()
 DECLARE SUB OS()
 DECLARE SUB Parse.Alphabetic1(V#)
 DECLARE SUB Parse.Alphabetic2(V#)
 DECLARE SUB Parse.Alphabetic3(V#)
 DECLARE SUB Parse.Numeric (V#)
 DECLARE SUB Parse.Quoted()
 DECLARE SUB Parse1(V#)
 DECLARE SUB Parse2(V#)
 DECLARE SUB Parse3(V#)
 DECLARE SUB Parse4(V#)
 DECLARE SUB Parse5(V#)
 DECLARE SUB Parse6(V#)
 DECLARE SUB Parse7(V#)
 DECLARE SUB Parse8(V#)
 DECLARE SUB Parse9(V#)
 DECLARE SUB Prepare.Program()
 DECLARE SUB Quit.Program()
 DECLARE SUB Read.Config()
 DECLARE SUB Read.Data.Element(V%)
 DECLARE SUB Read.Program()
 DECLARE SUB Read.Stdin()
 DECLARE SUB Release.Time(V%)
 DECLARE SUB Renumber.Program(V1%, V2%)
 DECLARE SUB Run.Program(V%)
 DECLARE SUB Save.Current()
 DECLARE SUB Save.Program(V$)
 DECLARE SUB Search.Program()
 DECLARE SUB Stop.Program()
 DECLARE SUB Store.Program()
 DECLARE SUB Whatis.Command(V$)

 ' function declarations
 DECLARE FUNCTION BreakIS()
 DECLARE FUNCTION ClearBreak()
 DECLARE FUNCTION ClearBuffer()
 DECLARE FUNCTION FreeFileNumber()
 DECLARE FUNCTION KeyboardChar$()
 DECLARE FUNCTION KeyboardLine$()
 DECLARE FUNCTION KeyIS()
 DECLARE FUNCTION STRIM$(V$)
 DECLARE FUNCTION TempName$()
 DECLARE FUNCTION TTRIM$(V$, V%)

 ' -end include file-
