/************************************************************************/
/*									*/
/*   TX_PROC.C : A demonstration of IPC usage for a Sending process.	*/
/*									*/
/*   Copyrighted (c) 1989 Donnelly Software Engineering.		*/
/*									*/
/*  This program should be compiled using the Large data model		*/
/*  (compact, large, or huge). If your compiler does not support the	*/
/*  Large data model, you need to devise a method of creating far	*/
/*  pointers for both 'p_block_ptr' and 'data_ptr' for this (or any	*/
/*  other IPC-based) program to work correctly. Below are examples of	*/
/*  creating TX_PROC.EXE using Borland International's TurboC (ver 1.5).*/
/*									*/
/*	Compile and Link in one command:				*/
/*  TCC -ml -IC:\TURBOC\INCLUDE -LC:\TURBOC\LIB TX_PROC.C IPCLIB.LIB	*/
/*	Compile TX_PROC.C using the large memory model. The include	*/
/*	directory is c:\turboc\include. The library directory is	*/
/*	c:\turboc\lib. Link using the library IPCLIB.LIB.		*/
/*									*/
/*	Compile only :							*/
/*  TCC -ml -c -IC:\TURBOC\INCLUDE TX_PROC.C				*/
/*	Compile TX_PROC.C using the large memory model. Compile to	*/
/*	object only. The include directory is c:\turboc\include.	*/
/*									*/
/*	Link only :							*/
/*  TLINK C:\TURBOC\LIB\C0L.OBJ TX_PROC.OBJ, TX_PROC.EXE, TX_PROC.MAP,	*/
/*   IPCLIB.LIB C:\TURBOC\LIB\CL.LIB					*/
/*	Link the large-model startup module C0L.OBJ, TX_PROC.OBJ,	*/
/*	IPCLIB.LIB, and the large-model run-time library CL.LIB to	*/
/*	produce TX_PROC.EXE and TX_PROC.MAP.				*/
/*									*/
/*	Run :								*/
/*  TX_PROC [some data]							*/
/*	Run TX_PROC.EXE. If any data is specified on the command line,	*/
/*	it will be sent to IPC. Otherwise, default data is sent.	*/
/*									*/
/************************************************************************/

#include <stdio.h>		/* standard i/o routines */
#include "pc-ipc.h"		/* contains PC-IPC defines and structure */

main(argc, argv)		/* start of main program */
    int argc;
    char *argv[];
{
				/*  DATA DECLARATIONS */

    int i;				/* loop counter */
    char my_data[128];			/* a 128-byte data buffer */
    IPC_PARAM_BLOCK far *p_block_ptr;	/* an IPC_PARAM_BLOCK far pointer */
    unsigned int proc_1_id = 0;		/* storage for process ids */
    unsigned int proc_2_id;
    int dv_running;			/* TRUE if RX_PROC started first */


/* determine if IPC is installed at the default vector */
	if ( ! pc_ipc_installed(IPC_VECTOR) )
	    {
	    printf("IPC not installed at vector %02X.\n", IPC_VECTOR);
	    exit();
	   }

/* allocate some memory for an IPC_PARAMETER_BLOCK */
	p_block_ptr = (IPC_PARAM_BLOCK far *)(malloc(sizeof(IPC_PARAM_BLOCK)));

/* if there is a message for process 0, RX_PROC is already waiting */
	init_param_block(p_block_ptr, proc_1_id, 0, IPC_CMND_INQUIRE, 0, 0L);
	pc_ipc(IPC_VECTOR, p_block_ptr);

	if (( !(p_block_ptr->error)) && (p_block_ptr->status & IPC_STAT_AVDATA))
	    {
	    init_param_block(p_block_ptr, proc_1_id, 0, IPC_CMND_RDATA,	0,
						(void far *)(&proc_2_id));
	    pc_ipc(IPC_VECTOR, p_block_ptr);

	    if (p_block_ptr->status && IPC_STAT_ERROR)
		ipc_error(p_block_ptr->error);

	    dv_running = IPC_TRUE;
	    }

/* No, get a second process id and send it to process 0 for RX_PROC to find */
	else
	    {
	    init_param_block(p_block_ptr, 0, 0, IPC_CMND_REQID, 0, 0L);
	    pc_ipc(IPC_VECTOR, p_block_ptr);

	    if (p_block_ptr->error)
		ipc_error(p_block_ptr->error);

	    proc_2_id = p_block_ptr->my_id;

	    init_param_block(p_block_ptr, proc_2_id, proc_1_id, IPC_CMND_SDATA,
				sizeof(unsigned int), (void far *)(&proc_2_id));
	    pc_ipc(IPC_VECTOR, p_block_ptr);

	    dv_running = IPC_FALSE;
	    }

/* If any parameters are on the command line, send them as data */
	if (argc > 1)
	    {
	    for (i = 1; i < argc; i++)
		{
		if (i == 1)
		    strcpy(my_data, argv[i]);
		else
		    strcat(my_data, argv[i]);
		if (i < argc - 1)
		    strcat(my_data, " ");
		}
	    }
	else
	    strcpy(my_data, "Howdy Doody and Buffalo Bob");

/* Send the data */
	init_param_block(p_block_ptr, proc_1_id, proc_2_id, IPC_CMND_SDATA,
			strlen(my_data) + 1, (void far *)(my_data));
	pc_ipc(IPC_VECTOR, p_block_ptr);

	if (p_block_ptr->status & IPC_STAT_ERROR)
	    ipc_error(p_block_ptr->error);

	else
	    printf("Successfully sent \"%s\" from process-%d to process-%d.\n",
			my_data, proc_1_id, proc_2_id);

/* relinquish the process id if one was allocated */
	if ( !dv_running )
	    {
	    init_param_block(p_block_ptr, proc_2_id, 0, IPC_CMND_DELID, 0, 0L);
	    pc_ipc(IPC_VECTOR, p_block_ptr);
	    }

/* free the allocated far-memory for the IPC_PARAM_BLOCK */
	free(p_block_ptr);

}	/* end of procedure main */
