
#include <stdio.h>

#include "luthor.h"

#include "basicdef.h"
#include "basictab.h"

char *string = "For Something = 1 to 100 step 4\n\tPrint \"This is \";\
				Something\nNext Something\n";
                

int main()
{
	int lextable;
	int lexstream,t;
	int old;

    LexInit(0);		/* initialize the lex processor */

    lextable=LexSetObject(&BASICObject);
    lexstream=LexInputString(lextable,string);
    if(lexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    LexSubmitString(lexstream,"END PROGRAM\n",SSO_ATEND);
    while((t=ThisToken(lexstream)) != EOF){
    	if(!t){
        	printf("token error!\n");
            exit(1);
		}
        printf("%d",t);
    	if(t==TK_EOL){
        	printf("->\\n\n");
		} else {
        	printf("->%s\n",ThisTokenText(lexstream));
		}
        if(!AdvanceToken(lexstream)){
        	printf("token error!\n");
            exit(1);
		}
	}
    printf("EOF\n");
    exit(0);
}


