
#include <stdio.h>

#include "luthor.h"
#include "test2def.h"
#include "test2tab.h"

int main(int argc,char **argv)
{
	int lextable,lexstream,t;

	if(argv[1]==NULL){
    	fprintf(stderr,"No input file name supplied\n");
        exit(1);
	}
    
    LexInit(0);		/* initialize the lex processor */
    lextable=LexSetObject(&test2Object);
	if(lextable==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
	
    lexstream=LexInputFile(lextable,argv[1]);
    if(lexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    while((t=ThisToken(lexstream)) != EOF){
    	printf("%d\t ",t);
    	if(t==TK_EOL){
        	printf("\\n\n");
		} else {
        	printf("%s\n",ThisTokenText(lexstream));
		}
        if(!AdvanceToken(lexstream)){
        	printf("token error!\n");
            exit(1);
		}
	}
    printf("EOF\n");
    exit(0);
}

