
/****************************************************************************
*		ERRORS.H
*
* The ERRORS module stacks and unstacks setjmp locations for possible
* error recovery.
*/

#include <setjmp.h>

jmp_buf *PushBuf(void);		/* this function supplies a save area for setjmp */
int PopBuf(void);			/* pops off a no-longer-required setjmp */


#define OnError()	if(setjmp(*PushBuf()))
#define EndError()	PopBuf()

#if defined(LogicError)
#else
#define LogicError()	{fprintf(stderr,"LOGIC ERROR file=%s line=%d\n",__FILE__,__LINE__);exit(99);}
#endif

int DoError(int ErrorNbr);
