/* DRIVER.H */


typedef struct {
    unsigned short  modeset_routine;
    unsigned short  paging_routine;
    unsigned short  driver_flags;
    unsigned short  def_tw;
    unsigned short  def_th;
    unsigned short  def_gw;
    unsigned short  def_gh;
} OLD_GR_DRIVER;

typedef struct {
    unsigned short  modeset_routine;
    unsigned short  paging_routine;
    unsigned short  driver_flags;
    unsigned short  def_tw;
    unsigned short  def_th;
    unsigned short  def_gw;
    unsigned short  def_gh;
    unsigned short  def_numcolor;
    unsigned short  driver_init_routine;
    unsigned short  text_table;
    unsigned short  graphics_table;
} NEW_GR_DRIVER;

typedef union {
    OLD_GR_DRIVER   old;
    NEW_GR_DRIVER   new;
} GR_DRIVER;

typedef struct {
    unsigned short  width;
    unsigned short  height;
    unsigned short  number_of_colors;
    unsigned char   BIOS_mode;
    unsigned char   special;
} GR_DRIVER_MODE_ENTRY;




#define GRD_NEW_DRIVER  0x0008		/* NEW FORMAT DRIVER IF THIS IS SET */

#define GRD_PAGING_MASK 0x0007		/* mask for paging modes */
#define GRD_NO_RW	0x0000		/* standard paging, no separate R/W */
#define GRD_RW_64K	0x0001		/* two separate 64K R/W pages */
/* THE FOLLOWING THREE OPTIONS ARE NOT SUPPORTED AT THIS TIME !!! */
#define GRD_RW_32K	0x0002		/* two separate 32Kb pages */
#define GRD_MAP_128K	0x0003		/* 128Kb memory map -- some Tridents
					   can do it (1024x768x16 without
					   paging!!!)
#define GRD_MAP_EXTMEM  0x0004		/* Can be mapped extended, above 1M.
					   Some Tseng 4000-s can do it, NO
					   PAGING AT ALL!!!! */

#define GRD_TYPE_MASK	0xf000		/* adapter type mask */
#define GRD_VGA		0x0000		/* vga */
#define GRD_EGA		0x1000		/* ega */
#define GRD_HERC	0x2000		/* hercules */

#define GRD_PLANE_MASK  0x0f00		/* bitplane number mask */
#define GRD_8_PLANES	0x0000		/* 8 planes = 256 colors */
#define GRD_4_PLANES	0x0100		/* 4 planes = 16 colors */
#define GRD_1_PLANE	0x0200		/* 1 plane  = 2 colors */
#define GRD_16_PLANES	0x0300		/* VGA with 32K colors */
#define GRD_8_X_PLANES  0x0400		/* VGA in mode X w/ 256 colors */

#define GRD_MEM_MASK	0x00f0		/* memory size mask */
#define GRD_64K		0x0010		/* 64K display memory */
#define GRD_128K	0x0020		/* 128K display memory */
#define GRD_256K	0x0030		/* 256K display memory */
#define GRD_512K	0x0040		/* 512K display memory */
#define GRD_1024K	0x0050		/* 1MB display memory */
#define GRD_192K	0x0060		/* 192K -- some 640x480 EGA-s */
#define GRD_M_NOTSPEC	0x0000		/* memory amount not specified */

