/*
    VGAXDEMO -- VGA ModeX graphics demo.  Mode setup, pixel plotting.
*/

#include <stdlib.h>
#include <conio.h>

void setmode(int mode);
void setmodex(void);
void cls(void);
void putpixel(int x, int y, int color);
int getpixel(int x, int y);

main()
{
    int i;

    setmodex();

    while(!kbhit())
    {
        for(i = 0; i < 200; i++)
            putpixel(random(320), random(240), random(256));
    }

    while(kbhit()) getch();
    cls();

    setmode(0x03);
    return 0;
}

void setmode(int mode)
{
    asm {
        mov ax,mode;
        xor ah,ah;
        int 10h;
    }
}

void setmodex(void)
{
    static int xdata[] = {
        0x0011, 0x0B06, 0x3E07, 0xEA10, 0x8C11,
        0xDF12, 0x0014, 0xE715, 0x0416, 0xE317 };

    setmode(0x13);          /* Set mode 13h 320x200x256 */

    asm {
        mov dx,03CCh;       /* Set ModeX 320x240x256 */
        in al,dx;
        or al,0C0h;
        mov dx,03C2h;
        out dx,al;
        mov dx,03C4h;
        mov ax,0604h;
        out dx,ax;

        push si;
        mov cx,10;
        lea si,xdata;
        mov dx,03D4h;
        rep outsw;
        pop si;
    }

    cls();
}

void cls(void)
{
    asm {

        mov ax,0A000h;      /* ES = video memory */
        mov es,ax;

        mov dx,03C4h;       /* Select all planes */
        mov ax,0F02h;
        out dx,ax;
    
        xor di,di;          /* Set up for clear */
        xor ax,ax;
        mov cx,8000h;
    
        rep stosw;          /* Clear the screen */
    }
}

void putpixel(int x, int y, int color)
{
    asm {
        mov ax,0A000h;          /* ES = video memory */
        mov es,ax;
        mov cx,x;               /* CX = X */
    
        mov dx,03C4h;           /* Set the memory plane */
        mov ax,1102h;
        rol ah,cl;
        out dx,ax;
    
        imul di,y,80;           /* DI = offset in video memory */
        shr cx,2;
        add di,cx;
        mov ax,color;           /* Set the pixel */
        stosb;
    }
}

int getpixel(int x, int y)
{
    asm {
        mov ax,0A000h;          /* ES = video memory */
        mov es,ax;
        mov cx,x;               /* CX = X */
    
        mov dx,03CEh;           /* Set the memory plane */
        mov al,4;
        mov ah,cl;
        and ah,3;
        out dx,ax;
    
        imul di,y,80;           /* DI = offset in video memory */
        shr cx,2;
        add di,cx;
        mov al,es:[di];         /* Read the pixel */
        or al,es:[di];          /* Buggy video card fix */
    }

    return _AL;
}
