/*--------------------------------------------------------------
   METAFILE.C -- Demonstrates GPI metafile creation and playing
                 (c) Ziff Communications Co, 1990
                 PC Magazine * Charles Petzold, 7/90
  --------------------------------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdio.h>

MRESULT EXPENTRY ClientWndProc  (HWND, USHORT, MPARAM, MPARAM) ;
HMF              CreateMetaFile (void) ;

HAB  hab ;

int main (void)
     {
     static CHAR  szClientClass[] = "Metafile" ;
     static ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU |
                                 FCF_SIZEBORDER    | FCF_MINMAX  |
                                 FCF_SHELLPOSITION | FCF_TASKLIST ;
     HMQ          hmq ;
     HWND         hwndFrame, hwndClient ;
     QMSG         qmsg ;

     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;
     WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0) ;

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                     &flFrameFlags, szClientClass, NULL,
                                     0L, 0, 0, &hwndClient) ;

     while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
          WinDispatchMsg (hab, &qmsg) ;

     WinDestroyWindow (hwndFrame) ;
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

#include "metarect.c"

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
     {
     static HMF   hmf ;
     static RECTL rclMetaFile, rclClient ;
     HPS          hps ;
     MATRIXLF     matlf ;

     switch (msg)
          {
          case WM_CREATE:
               hmf = CreateMetaFile () ;
               QueryMetaFileBoundaryRect (hab, hmf, &rclMetaFile) ;
               return 0 ;

          case WM_SIZE:
               WinQueryWindowRect (hwnd, &rclClient) ;
               return 0 ;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, NULL, NULL) ;
               GpiErase (hps) ;

                         // Translation transform

               matlf.fxM11 = MAKEFIXED (1, 0) ;
               matlf.fxM12 = 0 ;
               matlf.lM13  = 0 ;

               matlf.fxM21 = 0 ;
               matlf.fxM22 = MAKEFIXED (1, 0) ;
               matlf.lM23  = 0 ;

               matlf.lM31  = -rclMetaFile.xLeft ;
               matlf.lM32  = -rclMetaFile.yBottom ;
               matlf.lM33  = 1 ;

               GpiSetDefaultViewMatrix (hps, 9L, &matlf, TRANSFORM_REPLACE) ;

                         // Scaling transform

               matlf.fxM11 = 65536L * (rclClient.xRight - 1) /
                             (rclMetaFile.xRight - rclMetaFile.xLeft) ;

               matlf.fxM22 = 65536L * (rclClient.yTop - 1) /
                             (rclMetaFile.yTop - rclMetaFile.yBottom) ;

               matlf.lM31  = 0 ;
               matlf.lM32  = 0 ;

               GpiSetDefaultViewMatrix (hps, 9L, &matlf, TRANSFORM_ADD) ;

                         // Play the metafile using this composite transform

               GpiPlayMetaFile (hps, hmf, 0L, NULL, NULL, 0L, NULL) ;

               WinEndPaint (hps) ;
               return 0 ;

          case WM_DESTROY:
               GpiDeleteMetaFile (hmf) ;
               return 0 ;
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }

HMF CreateMetaFile (void)
     {
     static DEVOPENSTRUC dop = { NULL, "DISPLAY" } ;
     static POINTL       aptl[] = { -50,-50, -50,50, 0,100,  50,50,
                                    -50,-50, 50,-50, 50,50, -50,50, 50,-50 } ;
     HDC                 hdcMetafile ;
     HMF                 hmf ;
     HPS                 hps ;
     SIZEL               sizlPage ;

               // Open a metafile device context

     hdcMetafile = DevOpenDC (hab, OD_METAFILE, "*", 2L,
                              (PDEVOPENDATA) &dop, NULL) ;

               // Create a presentation space associated with that DC

     sizlPage.cx = 100 ;
     sizlPage.cy = 150 ;

     hps = GpiCreatePS (hab, hdcMetafile, &sizlPage,
                        GPIT_MICRO | GPIA_ASSOC | PU_LOENGLISH) ;

               // Draw a house using eight lines

     GpiMove (hps, aptl) ;
     GpiPolyLine (hps, 8L, aptl + 1) ;

               // Destroy the presentation space

     GpiDestroyPS (hps) ;

               // Close the device context to get the metafile handle

     hmf = DevCloseDC (hdcMetafile) ;

     return hmf ;
     }
