/*
    MAKENIF.C   Creates ordered non-indexed random
                access file for use by SRCHNIF.C
    Copyright (c) 1989 Ziff Communications Co.
    PC Magazine * Ray Duncan

    The user is prompted to enter from zero to one hundred
    ASCII strings.  These strings are then sorted and used 
    to build records in the file TESTFILE.DAT.

    Each record in TESTFILE.DAT is RSIZE bytes long.  Bytes 
    0 to (KSIZE-1) of the record are the ASCII key for searches
    by SRCHNIF.C.  Bytes KSIZE to (RSIZE-1) of the record
    are initialized to zero and are not used.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#define ISIZE   80                  /* max entry length */
#define N_ITEMS 100                 /* max number of strings */
#define RSIZE   64                  /* fixed record size */
#define KSIZE    8                  /* maximum key length */

static char items[N_ITEMS * ISIZE]; /* entered keys stored here */

main(int argc, char *argv[])
{
    int i, j;                       /* some scratch variables */
    int fh;                         /* handle for output file */
    char rec[RSIZE];                /* scratch record buffer */

    puts("\nEnter keys for file records...");

    i = 0;                          /* initialize string count */

    while(i < N_ITEMS)              /* enforce maximum entries */
    {
        printf("%2d: ", i+1);       /* prompt user for next string */
        gets(&items[ISIZE * i]);    /* read keyboard, store in array */

                                    /* last entry if empty line */
        if(items[ISIZE * i] == 0) break;

        for(j = 0; j < i; j++)      /* make sure not duplicate key */
        {
            if(strncmp(&items[ISIZE * i], &items[ISIZE * j], KSIZE) == 0)
                break;              /* exit loop if duplicate found */
        }

        if(i == j) i++;             /* count non-duplicate strings */
        else puts("Duplicate key, try again.");
    }

                                    /* sort strings if any entered */
    if(i != 0) qsort(items, i, ISIZE, strcmp);

                                    /* create the output file */
    fh = open("TESTFILE.DAT", O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, S_IWRITE);

    if(fh == -1)                    /* terminate if create failed */
    {
        puts("\nCan't create TESTFILE.DAT.");
        exit(1);
    }
 
    puts("\nWriting TESTFILE.DAT...");

    j = 0;                          /* initialize string counter */

    while (j < i)                   /* write file records */
    {                               /* using strings as keys */
        memset(rec, 0, RSIZE);
        strncpy(rec, &items[ISIZE * j], KSIZE);
        write(fh, rec, RSIZE);
        j++;                        /* bump string counter */
    }

    close(fh);                      /* release file handle */
}
