 (*****************    W A I T   *************************
 * Delays NumberOfSecs seconds.  This is done by         *
 * accessing the PC clock via function $2C of DOS int    *
 * 21h.  Its accuracy is limited by the fact that the    *
 * time is calculated from the ROM BIOS tick count,      *
 * which is updated only about 18.2 times per second.    *
 * This means that Wait will be accurate to about        *
 * 1/18 second.                                          *
 *                                                       *
 * Requires "Uses DOS" if in TP4 or TP5                  *
 ******************    W A I T   ************************)

  PROCEDURE Wait(NumberOfSecs : Real);
  CONST
    Secs_PER_DAY = 86400.0; {60 * 60 * 24}
  VAR
    TimeIsUp : Boolean;
    StartingSecs,
    Secs : Real;

    (******************   READ CLOCK  ************************
    *                                                        *
    *  Reads the PC clock, by using service $2C of int 21h.  *
    *  This service returns information in the 8088          *
    *  registers as follows:                                 *
    *                                                        *
    *    CH      Hour                  (0 through 23)        *
    *    CL      Minute                (0 through 59)        *
    *    DH      Seconds               (0 through 59)        *
    *    DL      Hundredths of seconds (0 through 99)        *
    *******************   READ CLOCK  ***********************)

    PROCEDURE ReadClock(VAR Secs : Real);

    CONST
      Secs_PER_HOUR = 3600.0; {This must be a real constant!}
      Secs_PER_MINUTE = 60.0;
    TYPE {Delete this type for TP4 and TP5}
      Registers = RECORD
        CASE Boolean OF
          True : (AL,AH,BL,BH,CL,CH,DL,DH:Byte);
          False : (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags:Integer)
        END;
    VAR Register : Registers;
    BEGIN
      Register.AH := $2C;
      msDos(Register);
      Secs := Secs_PER_HOUR*(Register.CH)
                +Secs_PER_MINUTE*(Register.CL)
                +Register.DH
                +0.01*Register.DL;
    END;

{********************** BODY OF WAIT ************************}

  BEGIN
    ReadClock(StartingSecs);
    REPEAT
      ReadClock(Secs);
      IF Secs-StartingSecs >= 0.0 THEN {Normal situation.}
        TimeIsUp := Secs-StartingSecs >= NumberOfSecs
      ELSE {During call, clock has ticked past midnight.}
        TimeIsUp := Secs_PER_DAY-StartingSecs+Secs >= NumberOfSecs
    UNTIL TimeIsUp
  END;
