PROGRAM NewExist;
(*Demonstrates using FSearch to
  test for file existence.*)
USES DOS;
CONST Reps = 100;
VAR
  start, total, N, IfTime : LongInt;
  example                 : PathStr;

  FUNCTION time100ths : LongInt;
  VAR H,M,S,F : Word;
  BEGIN
    GetTime(H,M,S,F);
    Time100ths := (((((LongInt(H)*60)+M)*60)+S)*100)+F;
  END;

  FUNCTION Exists(Name : PathStr) : Boolean;
  VAR F : File;
  BEGIN
    Assign(F,Name);
    {$I-} Reset(F); {$I+}
    IF IOresult = 0 THEN
      BEGIN
        close(F);
        Exists := TRUE;
      END
    ELSE Exists := FALSE;
  END;

  PROCEDURE Announce(method, kind : String);
  BEGIN
    WriteLn(reps,' repetitions of ',method,' with ',kind,' file.');
  END;

  PROCEDURE Report(T : LongInt);
  BEGIN
    WriteLn('That took ',T div 100,'.',T mod 100,' seconds.');
  END;

BEGIN
  (*Time a minimal IF loop*)
  start := time100ths;
  FOR N := 1 to reps DO IF TRUE THEN;
  IfTime := time100ths - start;
  (*Try example files on floppy disks and on hard disks.*)
  example := 'NEWEXIST.PAS';

  Announce('Exists','existing');
  start := time100ths;
  FOR N := 1 to reps DO
    IF NOT Exists(example) THEN;
  total := time100ths - start - IfTime;
  Report(total);

  Announce('FSearch','existing');
  start := time100ths;
  FOR N := 1 to reps DO
    IF FSearch(example,'') = '' THEN;
  total := time100ths - start - IfTime;
  Report(total);
  example := 'QWERTYUI.OP';

  Announce('Exists','non-existing');
  start := time100ths;
  FOR N := 1 to reps DO
    IF Exists(example) THEN;
  total := time100ths - start - IfTime;
  Report(total);

  Announce('FSearch','non-existing');
  start := time100ths;
  FOR N := 1 to reps DO
    IF FSearch(example,'') <> '' THEN;
  total := time100ths - start - IfTime;
  Report(total);
  WriteLn;
  ReadLn;
END.
