/*  TD.C:  Time & Date Formatting Functions, OS/2 version
    Copyright (c) 1989 Ziff Communications Co.
    PC Magazine * Ray Duncan
 */

#include <stdio.h>
#include <stdlib.h>

char * systcvt(int);                /* local function prototypes */
char * sysdcvt(int);
char * dirtcvt(int, unsigned);
char * dirdcvt(int, unsigned);
char * tcvt(int, int, int, int, int);
char * dcvt(int, int, int, int);
static void getctry(void);

#define API unsigned extern far pascal

API DosGetDateTime(void far *);     /* API function prototypes */

API DosGetCtryInfo(int, int far *, void far *, int far *);

static char cbuff[38];              /* receives country info */

static int cflag = 0;               /* true if country info */
                                    /* present in cbuff */

static struct _tdinfo {             /* used by DosGetDateTime */
    char hour;
    char min;
    char sec;
    char csec;
    char day;
    char month;
    int  year;
    int  zone;
    char dow; } tdinfo;              

/* Convert current system time to ASCII string. */

char * systcvt(int length) {   
    DosGetDateTime(&tdinfo);        /* get current time */
                                    /* convert it to ASCII */
    return(tcvt(length, tdinfo.hour, tdinfo.min, tdinfo.sec, tdinfo.csec));
}

/* Convert current system date to ASCII string. */

char * sysdcvt(int length) {   
    DosGetDateTime(&tdinfo);        /* get current date */
                                    /* convert it to ASCII */
    return(dcvt(length, tdinfo.month, tdinfo.day, tdinfo.year-1900));
}

/* Convert time in directory format to ASCII string. */

char * dirtcvt(int length, unsigned dirtime) {   
    int hour, min, sec, csec;

    hour = (dirtime >> 11) & 0x1f;  /* isolate time fields */ 
    min = (dirtime >> 5) & 0x3f;
    sec = (dirtime & 0x1f) * 2;
    csec = 0;
    return(tcvt(length, hour, min, sec, csec)); /* convert it to ASCII */
}

/* Convert date in directory format to ASCII string. */

char * dirdcvt(int length, unsigned dirdate) {
    int month, day, year;

    day = dirdate & 0x1f;           /* isolate date fields */
    month = (dirdate >> 5) & 0x0f;
    year = 80 + ((dirdate >> 9) & 0x3f);

    return(dcvt(length, month, day, year)); /* convert it to ASCII */
}

/* Convert hours, minutes, seconds, and hundredths of seconds to ASCII string,
   truncating string to lesser of specified length or 11 characters. */

char * tcvt(int length, int hour, int min, int sec, int csec) {   
    static char time[12];           /* receives formatted time */

    getctry();                      /* get country info */
    sprintf(time,"%02d%c%02d%c%02d%c%02d", 
            hour, cbuff[17], min, cbuff[17], sec, cbuff[13], csec);

    time[(int) min(length, 11)] = 0; /* truncate if necessary */
    return(time);                   /* return pointer */
}

/* Convert month, day, and year to ASCII string, truncating
   string to lesser of specified length or 8 characters. */

char * dcvt(int length, int month, int day, int year) {   
    static char date[9];            /* receives formatted date */

    getctry();                      /* get country info */
    switch(cbuff[4])                /* format by date code */
    {
        case 0:                     /* USA: m d y */
        sprintf(date,"%02d%c%02d%c%02d", 
                month, cbuff[15], day, cbuff[15], year);
            break;

        case 1:                     /* Europe: d m y */
        sprintf(date,"%02d%c%02d%c%02d", 
                day, cbuff[15], month, cbuff[15], year);
            break;

        case 2:                     /* Japan: y m d */
        sprintf(date,"%02d%c%02d%c%02d", 
                year, cbuff[15], month, cbuff[15], day);
            break;
    }

    date[(int) min(length, 8)] = 0; /* truncate string */
    return(date);                   /* return pointer */
}

/* Get internationalization information into 'cbuff', or provide
   default information. */

static void getctry(void) {   
    int ccode[2];                   /* country & code page */
    int cbytes;                     /* receives length of info */
    unsigned status;                /* scratch variable */

    if(cflag) return;               /* exit if information already in buffer */
    
    memset(cbuff,0,sizeof(cbuff));  /* initialize buffer */
    ccode[0] = 0;                   /* country = default */
    ccode[1] = 0;                   /* code page = default */

                            /* get country info or supply USA defaults */
    if(DosGetCtryInfo(sizeof(cbuff), ccode, cbuff, &cbytes)) {
        cbuff[13] = '.';            /* decimal separator */
        cbuff[15] = '-';            /* date separator */
        cbuff[17] = ':';            /* time separator */
    }
}
