;----------------------------------------------------------------------
;	Typical usage:	IMPORT NETNAME >FILENAME
;
;	Receives file from network using NETBIOS name IMPORT_NETNAME<10>
;	and writes it to standard output
;	Network traffic is overlapped with Disk I/O to demonstrate the
;	use of the No-Wait function of NETBIOS without needing an interrupt
;	handler (POST=0).  This program takes best advantage of
;	intelligent adapters with network coprocessors.
;
;	Author: Jack Schoof, President, ARTISOFT, Inc.
;----------------------------------------------------------------------
;	NCB DEFINITION

NCBDEF	STRUC				;PRE FILLED WITH ALL ZEROES
NCB_COMMAND	DB 0
NCB_RETCODE	DB 0
NCB_LSN 	DB 0
NCB_NUM 	DB 0
NCB_BUFFER	DD 0			;POINTER TO MESSAGE BUFFER
NCB_LENGTH	DW 0			;NUMBER OF BYTES IN BUFFER
NCB_CALLNAME	DB 16 DUP (0)
NCB_NAME	DB 16 DUP (0)
NCB_RTO 	DB 0
NCB_STO 	DB 0
NCB_POST	DD 0			;POINTER TO POST ADDRESS
NCB_LANA_NUM	DB 0
NCB_CMD_CPLT	DB 0
NCB_RESERVED	DB 14 DUP (0)		;RESERVED
NCBDEF	ENDS

;	NCB COMMANDS

NO_WAIT 		EQU 80H
NCB_ADD_NAME		EQU 30H
NW_DELETE_NAME		EQU 31H+NO_WAIT
NW_LISTEN		EQU 11H+NO_WAIT
NW_HANG_UP		EQU 12H+NO_WAIT
NW_RECEIVE		EQU 15H+NO_WAIT
;----------------------------------------------------------------------
MAIN_DATA SEGMENT PUBLIC 'DATA'

LNCB	NCBDEF <>			;DEFINE NCB

	ORG LNCB.NCB_NAME
	DB 'IMPORT_'			;PREFIX TO NAME TYPED BY USER
	ORG LNCB.NCB_NAME+15
	DB 10				;SUFFIX ON NAME TO NOT COLLIDE WITH
	ORG LNCB.NCB_CALLNAME		;IBM PC LAN, LANTASTIC NOS AND OTHERS
	DB '*'				;* IN CALLNAME TO LISTEN FOR ANYONE
	ORG LNCB+SIZE NCBDEF

BUFFER_ONE	DB 4000H DUP (?)	;uses two buffers
BUFFER_TWO	DB 4000H DUP (?)	;of 16K each

ERROR_MESSAGE	DB ' NETBIOS ERROR: ERROR '
ERROR_SWITCH	DB 1 DUP(0)
ERROR_BUFFER	DB 1 DUP(0)

MAIN_DATA ENDS
;----------------------------------------------------------------------
MAIN_CODE SEGMENT PUBLIC 'CODE'
	ASSUME CS:MAIN_CODE, DS:MAIN_DATA

NOTICE	DB '(C) 1988 ARTISOFT, INC.',0

BEGIN:	PUSH ES
	POP DS				;PUT ADDRESS OF PSP IN DS
	MOV AX,SEG MAIN_DATA
	MOV ES,AX			;ES IS OUR DATA SEGMENT

	MOV SI,5DH			;GET THE FCB1 POINTER IN PSP
	MOV DI,OFFSET LNCB.NCB_NAME+7	;POINT TO NCB_NAME IN NCB
	MOV CX,8			;TRANSFER 8 CHARACTERS TO NCB NAME
	REP MOVSB			;DONE

	MOV DS,AX
	MOV WORD PTR LNCB.NCB_BUFFER+2,AX ;SET UP THE BUFFER SEGMENT AS OUR
					  ;DATA SEGMENT

	MOV LNCB.NCB_COMMAND,NCB_ADD_NAME
	CALL NETBIOS			;HERE WE ADD THE NAME
	JNZ BAD_EXIT			;PROBLEM, QUIT

LISTEN: MOV LNCB.NCB_COMMAND,NW_LISTEN	;LISTEN FOR SOMEONE TO CALL US
	CALL NETBIOS
	JNZ DELETE_NAME 		;PROBLEM, SO DELETE THE NAME AND LEAVE

	CALL WAIT_MYSELF		;WAIT FOR THE CALL OR ANY CHARACTER
	JNZ DELETE_NAME 		;TYPED BY THE USER TO QUIT

	MOV DX,OFFSET BUFFER_ONE
	CALL RECEIVE_BUFFER		;RECEIVE THE FIRST BUFFER
	JNZ HANG_UP			;PROBLEMS? THEN HANG UP THE SESSION
;
;	HERE IS WHERE WE WILL LOOP FOR THE REST OF THE FILE
;
MAIN_LOOP:
	CALL WAIT_MYSELF		;WAIT FOR THE BUFFER TO SHOW UP
	JNZ HANG_UP

	MOV CX,LNCB.NCB_LENGTH		;DID WE RECEIVE ZERO LENGTH?
	JCXZ CLOSE_FILE 		;THIS IS A SIGNAL TO CLOSE THE FILE

	MOV DX,OFFSET BUFFER_TWO
	CALL RECEIVE_BUFFER		;RECEIVE BUFFER_TWO
	JNZ HANG_UP			;IMMEDIATE PROBLEMS?

	MOV DX,OFFSET BUFFER_ONE	;POINT TO THIS BUFFER FOR DOS
	CALL WRITE_BUFFER		;WRITE IT OUT, LENGTH IS STILL IN CX

	CALL WAIT_MYSELF		;NOW WAIT FOR THE SECOND BUFFER WHICH
	JNZ HANG_UP			;MIGHT HAVE ARRIVED ALREADY

	MOV CX,LNCB.NCB_LENGTH		;DOES THIS BUFFER HAVE THE END OF FILE?
	JCXZ CLOSE_FILE 		;YEP, CLOSE THE FILE AND QUIT

	MOV DX,OFFSET BUFFER_ONE
	CALL RECEIVE_BUFFER		;RECEIVE BUFFER ONE AGAIN
	JNZ HANG_UP

	MOV DX,OFFSET BUFFER_TWO	;WHILE WRITING BUFFER TWO TO DISK
	CALL WRITE_BUFFER		;LENGTH IS STILL IN CX

	JMP MAIN_LOOP			;CONTINUE UNTIL WE ARE DONE

CLOSE_FILE:
	MOV AH,3EH
	MOV BX,1
	INT 21H 			;CLOSE THE OUTPUT FILE

HANG_UP:
	MOV BX,OFFSET LNCB
	MOV LNCB.NCB_COMMAND,NW_HANG_UP
	CALL NETBIOS			;HANG UP THE SESSION
	JNZ DELETE_NAME

	CALL WAIT_MYSELF
	JNZ DELETE_NAME

DELETE_NAME:
	MOV LNCB.NCB_COMMAND,NW_DELETE_NAME
	CALL NETBIOS			;REMOVE THE NAME FROM THE ADAPTER
	JNZ BAD_EXIT

	CALL WAIT_MYSELF		;WAIT UNTIL IT IS DONE
	JNZ BAD_EXIT

	MOV AX,4C00H
	INT 21H 			;BYE FOR NOW

BAD_EXIT:
	CALL ERROR_MSG
	MOV AX,4C01H
	INT 21H 			;PUT OUT A BAD RETURN CODE TO
					;TEST IN A BATCH FILE
WAIT_MYSELF:
	MOV AL,LNCB.NCB_CMD_CPLT	;WAIT FOR THE COMMAND
	CMP AL,0FFH			;TO HAVE DONE SOMETHING
	JZ TEST_CHAR			;WAIT FOR A CHARACTER
	XOR AL,AL
	RET				;Z FLAG IS ON
TEST_CHAR:
	MOV AH,1
	INT 16H 			;IS A CHARACTER AVAILABLE?
	JZ WAIT_MYSELF
	XOR AH,AH
	INT 16H
	OR AL,0FFH			;NZ FLAG IS ON
	RET

WRITE_BUFFER PROC
	MOV AH,40H
	MOV BX,1			;OUTPUT HANDLE IS STANDARD OUTPUT
	INT 21H 			;DO THE DOS DISK WRITE
	RET
WRITE_BUFFER ENDP

RECEIVE_BUFFER PROC
	MOV WORD PTR LNCB.NCB_BUFFER,DX 	;THE LOCATION OF THE BUFFER
	MOV LNCB.NCB_COMMAND,NW_RECEIVE 	;A NO-WAIT RECEIVE
	MOV LNCB.NCB_LENGTH,SIZE BUFFER_ONE	;AND HOW MUCH WE WANT
NETBIOS PROC
	MOV BX,OFFSET LNCB		;ES:BX POINTS TO NCB
	INT 5CH 			;CALL THE NETBIOS
	TEST AL,AL			;ANY IMMEDIATE PROBLEMS?
	RET				;RETURN WITH FLAGS SET
NETBIOS ENDP
RECEIVE_BUFFER ENDP

ERROR_MSG   PROC
	MOV ERROR_SWITCH,01		;SET SWITCH FOR ONLY ONE MESSAGE

	MOV CX,22
	LEA DX,ERROR_MESSAGE		;PRINT OUT ERROR MESSAGE
	MOV BX,2			;TO STANDARD DEVICE - NO REDIRECTION
	MOV AH,40H
	INT 21H

	MOV BH,LNCB.NCB_RETCODE 	;MOVE RETURN CODE TO BH
	MOV CL,04
	MOV CH,02
AGAIN:
	ROL BX,CL			;ROUTINE TO CONVERT BINARY TO
	MOV AL,BL			;HEX
	AND AL,0FH
	ADD AL,30H
	CMP AL,39H
	JLE PRINT_CHAR
	ADD AL,7
PRINT_CHAR:
	MOV ERROR_BUFFER,AL
	PUSH CX

	MOV CX,1
	LEA DX,ERROR_BUFFER		;PRINT OUT ERROR MESSAGE
	PUSH BX 			;TO STANDARD DEVICE - NO REDIRECTION
	MOV BX,2
	MOV AH,40H
	INT 21H

	POP BX
	POP CX
	DEC CH
	JNZ AGAIN
	RET
ERROR_MSG   ENDP


MAIN_CODE ENDS

MAIN_STACK	SEGMENT STACK
	DW 100H DUP (?) 		;AUTOMATIC STACK SETUP BY LINKER
MAIN_STACK	ENDS

	END BEGIN
