'******** MousDemo.Bas

If FNMouseInstalled% Then
   Screen 0 : Cls
   Print "Text mode cursor . . . move the mouse, then press any key"
   Call MouseOn
   While Inkey$ = "" : Wend

   Screen 9
   Cls : Print "Default graphics cursor . . . press a button to continue"
   Call LoadCursor
   Call MouseOn

WaitButton:
   Call Mouse(3, Mouse%, X%, Y%)
   If Mouse% = 0 Goto WaitButton

   'Mouse% is zero if no button is pressed,
   '  1 if left button, 2 if right button,
   '  3 if both buttons

   Cls : Print "Hand cursor . . . press any key"
   Call LoadCursor
   While Inkey$="":Wend

   Cls : Print "Hour Glass cursor . . . press any key"
   Call LoadCursor
   While Inkey$="":Wend
   Call MouseOff
Else
   Cls
   Print "Mouse Driver Not Installed"
   Stop
End if

Screen 0
Cls
Print "Program Over"
End


'---------------------------------------
'returns -1 if mouse installed, 0 if not

Def FNMouseInstalled%
    Local X%
    Reg 1, X%
    Call Interrupt 51
    FnMouseInstalled% = Reg(1)
End Def

'---------------------------------
'similar to Microsoft's mouse call

Sub Mouse(M1%, M2%, M3%, M4%)
   Reg 1, M1%         'AX
   Reg 2, M2%         'BX
   Reg 3, M3%         'CX
   Reg 4, M4%         'DX
   Call Interrupt 51
   M1% = Reg(1)
   M2% = Reg(2)
   M3% = Reg(3)
   M4% = Reg(4)
End Sub

'----------------
'shows the cursor

Sub MouseOn
   M1% = 1
   Call Mouse(M1%, M2%, M3%, M4%)
End Sub

'----------------
'hides the cursor

Sub MouseOff
   M1% = 2
   Call Mouse(M1%, M2%, M3%, M4%)
End Sub

'--------------------------------------
'load a graphics cursor from Data items

Sub LoadCursor
   Local Cursor%()
   Dim Cursor%(0:15,0:1)

   For X% = 0 To 1
       For Y% = 0 To 15
           Read Pattern$
           Cursor%(Y%, X%) = Val("&H" + Pattern$)
       Next
   Next

   Reg 1, 9                       'AX
   Reg 2, 0                       'BX
   Reg 3, 0                       'CX
   Reg 9, VarSeg(Cursor%(0,0))    'ES
   Reg 4, VarPtr(Cursor%(0,0))    'DX
   Call Interrupt 51

   'defines the arrow cursor (graphics mode only)
   Data 3FFF, 1FFF, 0FFF, 07FF, 03FF, 01FF, 00FF, 007F
   Data 003F, 001F, 01FF, 10FF, 30FF, F87F, F87F, FC3F
   Data 0000, 4000, 6000, 7000, 7800, 7C00, 7E00, 7F00
   Data 7F80, 78C0, 7C00, 4600, 0600, 0300, 0300, 0180

   'defines the hand cursor (graphics mode only)
   Data E1FF, E1FF, E1FF, E1FF, E1FF, E000, E000, E000
   Data 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000
   Data 1E00, 1200, 1200, 1200, 1200, 13FF, 1249, 1249
   Data F249, 9001, 9001, 9001, 8001, 8001, 8001, FFFF

   'defines the hand cursor (graphics mode only)
   Data 0000, 0000, 0000, 0000, 8001, C003, E007, F00F
   Data E007, C003, 8001, 0000, 0000, 0000, 0000, FFFF
   Data 0000, 7FFE, 6006, 3C3C, 1FF8, 0FF0, 07E0, 03C0
   Data 0660, 0C30, 1998, 37EC, 6FF6, 7FFE, 0000, 0000

End Sub