**************************************************************
* FUNCTION Idincr( cId )
* Increment a character string to the next unique ID using
* the printable characters from chr(33) - chr(126).
* Syntax:  cNewId = Idincr( cId )
**************************************************************
FUNCTION Idincr
PARAMETER cId

#DEFINE LoChar 33
#DEFINE HiChar 126
#DEFINE Errchar 27

PRIVATE ReturnID, Cpos, CurDigit

m.nIdlen = LEN(m.cID)   && Save the length of the id
IF EMPTY(m.cID)
  * Return the beginning ID (just like starting at 1).
  m.ReturnID = REPLICATE( CHR(LoChar), m.nIdlen )
ELSE
  * Start at the beginning, incrementing the first character.
  * If the first character is equal to HiChar, reset it to
  * LoChar and continue to the second character.  Continue in
  * in this fashion until a character is not equal to HiChar (or
  * in the most unusual circumstance, every character in cID is
  * equal to HiChar and is to be replaced with LoChar, essentially
  * exhausting the pool of IDs, in which case we return a string
  * of Errchars.)
  m.ReturnID = m.cID
  m.Cpos = 1
  DO WHILE .T.
    m.CurDigit = ASC( SUBSTR(m.ReturnID,m.Cpos,1) )
    IF m.CurDigit < HiChar
      m.ReturnID = STUFF( m.ReturnID, m.Cpos, 1, CHR(m.CurDigit+1) )
      EXIT
    ELSE
      m.ReturnID = STUFF( m.ReturnID, m.Cpos, 1, CHR(LoChar) )
      m.Cpos = m.Cpos + 1
      IF m.Cpos > m.nIDlen
         m.ReturnID = REPLICATE( CHR(Errchar), m.nIDlen )
         EXIT
      ENDIF
    ENDIF
  ENDDO
ENDIF
RETURN m.ReturnID

#UNDEF LoChar
#UNDEF HiChar
#UNDEF Errchar
