//***********************************************************************
//
//  Detab.cpp
//
//***********************************************************************

#include <afxwin.h>
#include <afxcmn.h>
#include <afxdlgs.h>
#include "Detab.h"

#define IDC_SELECT       100
#define IDC_TABSIZE      101
#define BLOCKSIZE       1024

CMyApp myApp;

/////////////////////////////////////////////////////////////////////////
// CMyApp member functions

BOOL CMyApp::InitInstance ()
{
    SetRegistryKey ("PC Magazine Utilities");

    m_pMainWnd = new CMainWindow;
    m_pMainWnd->ShowWindow (m_nCmdShow);
    m_pMainWnd->UpdateWindow ();
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////
// CMainWindow message map and member functions

BEGIN_MESSAGE_MAP (CMainWindow, CWnd)
    ON_WM_CREATE ()
    ON_WM_DESTROY ()
    ON_WM_ENDSESSION ()
    ON_COMMAND (IDC_SELECT, OnSelectFiles)
END_MESSAGE_MAP ()

CMainWindow::CMainWindow ()
{
    m_nTabSize = myApp.GetProfileInt ("V1.0", "TabSize", 4);
    if (m_nTabSize < 1)
        m_nTabSize = 1;
    else if (m_nTabSize > 32)
        m_nTabSize = 32;

    CString strWndClass = AfxRegisterWndClass (
        0,
        myApp.LoadStandardCursor (IDC_ARROW),
        (HBRUSH) (COLOR_3DFACE + 1),
        myApp.LoadStandardIcon (IDI_APPLICATION)
    );

    CreateEx (WS_EX_TOOLWINDOW, strWndClass, "Detab for Windows",
        WS_POPUP | WS_SYSMENU | WS_CAPTION, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL);

    CRect rect (0, 0, m_cxChar * 30, m_cyChar * 3);
    CalcWindowRect (&rect);

    SetWindowPos (NULL, 0, 0, rect.Width (), rect.Height (),
        SWP_NOZORDER | SWP_NOMOVE | SWP_NOREDRAW);
}

int CMainWindow::OnCreate (LPCREATESTRUCT lpcs)
{
    if (CWnd::OnCreate (lpcs) == -1)
        return -1;

    // Create a font and initialize m_cxChar and m_cyChar
    CClientDC dc (this);
    int nHeight = -((dc.GetDeviceCaps (LOGPIXELSY) * 8) / 72);

    m_font.CreateFont (nHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0,
        DEFAULT_CHARSET, OUT_CHARACTER_PRECIS, CLIP_CHARACTER_PRECIS,
        DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "MS Sans Serif");

    TEXTMETRIC tm;
    CFont* pOldFont = dc.SelectObject (&m_font);
    dc.GetTextMetrics (&tm);
    m_cxChar = tm.tmAveCharWidth;
    m_cyChar = tm.tmHeight + tm.tmExternalLeading;
    dc.SelectObject (pOldFont);

    // Create the push button control
    CRect rect (m_cxChar, m_cyChar / 2, m_cxChar * 19,
        (m_cyChar * 5) / 2);
    m_ctlButton.Create ("Select File(s)...", WS_CHILD | WS_VISIBLE |
        BS_PUSHBUTTON, rect, this, IDC_SELECT);
    m_ctlButton.SetFont (&m_font);

    // Create the edit control
    m_ctlEdit.CreateEx (WS_EX_CLIENTEDGE, "edit", NULL,
        WS_CHILD | WS_VISIBLE | WS_BORDER| ES_READONLY,
        m_cxChar * 20, m_cyChar / 2, m_cxChar * 9, m_cyChar * 2,
        m_hWnd, (HMENU) IDC_TABSIZE);
    m_ctlEdit.SetFont (&m_font);

    // Create the spin button control
    m_ctlSpin.Create (WS_CHILD | WS_VISIBLE | UDS_AUTOBUDDY |
        UDS_SETBUDDYINT | UDS_ALIGNRIGHT, CRect (0, 0, 0, 0), this,
        (UINT) -1);
    m_ctlSpin.SetRange (1, 32);
    m_ctlSpin.SetPos (m_nTabSize);
    return 0;
}

void CMainWindow::OnSelectFiles ()
{
    m_nTabSize = GetDlgItemInt (IDC_TABSIZE, NULL, FALSE);

    CFileDialog dlg (TRUE, NULL, "*.*", OFN_HIDEREADONLY |
        OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_ALLOWMULTISELECT,
        "All Files (*.*)|*.*||", this);
    dlg.m_ofn.lpstrTitle = "Select File(s)";

    if (dlg.DoModal () == IDOK) {
        POSITION pos = dlg.GetStartPosition ();

        CString strFileName;
        while (pos != NULL) {
            strFileName = dlg.GetNextPathName (pos);
            if (!DetabFile (strFileName))
                break;
        }
    }
}

void CMainWindow::OnDestroy ()
{
    m_nTabSize = GetDlgItemInt (IDC_TABSIZE, NULL, FALSE);
    myApp.WriteProfileInt ("V1.0", "TabSize", m_nTabSize);
}

void CMainWindow::OnEndSession (BOOL bEnding)
{
    m_nTabSize = GetDlgItemInt (IDC_TABSIZE, NULL, FALSE);
    myApp.WriteProfileInt ("V1.0", "TabSize", m_nTabSize);
}

void CMainWindow::PostNcDestroy ()
{
    delete this;
}

BOOL CMainWindow::DetabFile (CString& strFileName)
{
    CString strError;
    BYTE inbuffer[BLOCKSIZE];
    BYTE outbuffer[BLOCKSIZE * 32]; // Assumes max tab size is 32 spaces
    char szTempPath[MAX_PATH];
    char szTempFile[MAX_PATH];

    // Create a temporary file to receive the output
    ::GetTempPath (sizeof (szTempPath), szTempPath);
    if (!::GetTempFileName (szTempPath, "DTB", 0, szTempFile)) {
        strError.Format ("Unable to create temporary file for " \
            "detabbing %s", strFileName);
        MessageBox (strError, "Error", MB_ICONSTOP | MB_OK);
        return FALSE;
    }

    CFile outfile;
    if (!outfile.Open (szTempFile, CFile::modeCreate | CFile::modeWrite)) {
        strError.Format ("Unable to create temporary file for " \
            "detabbing %s", strFileName);
        MessageBox (strError, "Error", MB_ICONSTOP | MB_OK);
        return FALSE;
    }

    // Open the input file for reading
    CFile infile;
    if (!infile.Open (strFileName, CFile::modeRead)) {
        strError.Format ("Unable to open %s", strFileName);
        MessageBox (strError, "Error", MB_ICONSTOP | MB_OK);
        outfile.Close ();
        DeleteFile (szTempFile);
        return FALSE;
    }

    // Convert tabs in the input file to spaces in the output file
    DWORD dwBytesRead, dwBytesToOutput;
    DWORD dwBytesRemaining = infile.GetLength ();

    while (dwBytesRemaining) {
        dwBytesRead = (DWORD) infile.Read (inbuffer, BLOCKSIZE);
        dwBytesToOutput = DetabBuffer (inbuffer, outbuffer, dwBytesRead);

        try {
            outfile.Write (outbuffer, (UINT) dwBytesToOutput);
        }
        catch (CFileException* e) {
            if (e->m_cause == CFileException::diskFull)
                strError.Format ("Disk full error while detabbing %s",
                    strFileName);
            else // Unknown output error
                strError.Format ("Error writing data to temporary " \
                    "file for %s", strFileName);
            MessageBox (strError, "Error", MB_ICONSTOP | MB_OK);
            outfile.Close ();
            DeleteFile (szTempFile);
            e->Delete ();
            return FALSE;
        }
        dwBytesRemaining -= dwBytesRead;
    }

    // Close the files and replace the input file with the output file
    infile.Close ();
    outfile.Close ();
    DeleteFile (strFileName);

    if (!::MoveFile (szTempFile, strFileName)) {
        strError.Format ("Unable to replace the original version of " \
            "%s (which is now deleted) with the detabbed version. The " \
            "detabbed version of the file is %s.", strFileName,
            szTempFile);
        MessageBox (strError, "Error", MB_ICONSTOP | MB_OK);
        return FALSE;
    }
    return TRUE;
}

DWORD CMainWindow::DetabBuffer (BYTE* pIn, BYTE* pOut, DWORD dwBytes)
{
    DWORD j = 0;
    static UINT nCol = 0;

    for (DWORD i=0; i<dwBytes; i++) {
        if (pIn[i] == 0x09) {
            if (m_nTabSize == 1) // Special case for m_nTabSize == 1
                continue;
            int nSpaces = m_nTabSize - (nCol % m_nTabSize);
            for (int k=0; k<nSpaces; k++)
                pOut[j++] = 0x20;
            nCol += nSpaces;
        }
        else {
            pOut[j++] = pIn[i];
            if (pIn[i] == 0x0D)
                nCol = 0;
            else if (pIn[i] != 0x0A)
                nCol++;
        }
    }
    return j;
}
/*
/////////////////////////////////////////////////////////////////////////
// CSelectFileDialog member functions

BOOL CSelectFileDialog::OnInitDialog ()
{
    CFileDialog::OnInitDialog ();

    CWnd* pBtn = GetDlgItem (IDOK);
    if (pBtn != NULL)
        pBtn->SetWindowText ("&Detab");
    return TRUE;
}
*/
