/*-----------------------------------------
   WIDELINE.C -- WidenPath Demo
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>

char szClass [] = "WideLine" ;
char szTitle [] = "WideLine: WidenPath Demo" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     INT      i ;
     LOGBRUSH lb ;

               // Set up an isotropic display area

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx   (hdc, 400, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea, cyArea, NULL) ;

     lb.lbStyle = BS_HATCHED ;
     lb.lbColor = RGB (0, 0, 0) ;
     lb.lbHatch = HS_DIAGCROSS ;

     for (i = 0 ; i < 4 ; i++)
          {
          SetViewportOrgEx (hdc, i * cxArea / 4, 0, NULL) ;

          switch (i)
               {
               case 0:
                    MoveToEx (hdc, 50, 20, NULL) ;
                    LineTo   (hdc, 50, 80) ;
                    break ;

               case 1:
                    SelectObject (hdc,
                         ExtCreatePen (PS_GEOMETRIC | PS_SOLID,
                                       30, &lb, 0, NULL)) ;

                    MoveToEx (hdc, 50, 20, NULL) ;
                    LineTo   (hdc, 50, 80) ;

                    DeleteObject (
                         SelectObject (hdc, GetStockObject (BLACK_PEN))) ;

                    break ;

               case 2:
                    SelectObject (hdc,
                         ExtCreatePen (PS_GEOMETRIC | PS_SOLID,
                                       30, &lb, 0, NULL)) ;

                    BeginPath (hdc) ;

                    MoveToEx (hdc, 50, 20, NULL) ;
                    LineTo   (hdc, 50, 80) ;

                    EndPath (hdc) ;

                    WidenPath (hdc) ;

                    DeleteObject (
                         SelectObject (hdc, GetStockObject (BLACK_PEN))) ;

                    StrokePath (hdc) ;
                    break ;

               case 3:
                    SelectObject (hdc,
                         ExtCreatePen (PS_GEOMETRIC | PS_SOLID,
                                       30, &lb, 0, NULL)) ;

                    BeginPath (hdc) ;

                    MoveToEx (hdc, 50, 20, NULL) ;
                    LineTo   (hdc, 50, 80) ;

                    EndPath (hdc) ;

                    WidenPath (hdc) ;

                    DeleteObject (
                         SelectObject (hdc, GetStockObject (BLACK_PEN))) ;

                    SelectObject (hdc, CreateBrushIndirect (&lb)) ;

                    StrokeAndFillPath (hdc) ;

                    DeleteObject (
                         SelectObject (hdc, GetStockObject (WHITE_BRUSH))) ;
                    break ;
               }
          }
     }
