/*-----------------------------------------
   PATHRGN3.C -- Paths and Regions
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>
#include <math.h>

#define TWOPI (2 * 3.14159)

char szClass [] = "PathRgn3" ;
char szTitle [] = "PathRgn3: Paths and Regions" ;

#define WIDTH 50

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     HBRUSH   hBrushBlue, hBrushRed ;
     HPEN     hPenBlue ;
     HRGN     hRgn [2] ;
     INT      i, x, y, iAngle ;
     LOGBRUSH lb ;
     POINT    pt [5] ;

               // Define points on a pentagon used for the stars

     for (i = 0 ; i < 5 ; i++)
          {
          iAngle = 90 + 72 * i ;

          pt[2 * i % 5].x = (INT) (900 * cos (TWOPI * iAngle / 360)) ;
          pt[2 * i % 5].y = (INT) (900 * sin (TWOPI * iAngle / 360)) ;
          }

               // Create the path and regions

     for (i = 0 ; i < 2 ; i++)
          {
          SetPolyFillMode (hdc, i ? WINDING : ALTERNATE) ;

          BeginPath  (hdc) ;
          MoveToEx   (hdc, pt[0].x, pt[0].y, NULL) ;
          PolylineTo (hdc, pt + 1, 4) ;
          CloseFigure (hdc) ;
          EndPath (hdc) ;

          hRgn [i] = PathToRegion (hdc) ;
          }

               // Set up an isotropic display area

     SetMapMode (hdc, MM_ISOTROPIC) ;
     SetWindowExtEx   (hdc, 3000, 2000, NULL) ;
     SetViewportExtEx (hdc, cxArea / 3, -cyArea / 2, NULL) ;

               // Create brushes and a pen

     lb.lbStyle = BS_SOLID ;
     lb.lbColor = RGB (0, 0, 255) ;
     lb.lbHatch = 0 ;

     hBrushBlue = CreateBrushIndirect (&lb) ;

     hPenBlue   = ExtCreatePen (PS_GEOMETRIC | PS_SOLID,
                                WIDTH, &lb, 0, NULL) ;

     lb.lbStyle = BS_HATCHED ;
     lb.lbColor = RGB (255, 0, 0) ;
     lb.lbHatch = HS_DENSE1 ;

     hBrushRed  = CreateBrushIndirect (&lb) ;

               // Loop through the six figures

     for (y = 0 ; y < 2 ; y++)
          {
          SetPolyFillMode (hdc, y ? WINDING : ALTERNATE) ;

          for (x = 0 ; x < 3 ; x++)
               {
               SetViewportOrgEx (hdc, (2 * x + 1) * cxArea / 6,
                                      (2 * y + 1) * cyArea / 4, NULL) ;

                    // Create the path

               if (x < 2)
                    {
                    BeginPath  (hdc) ;
                    MoveToEx   (hdc, pt[0].x, pt[0].y, NULL) ;
                    PolylineTo (hdc, pt + 1, 4) ;
                    CloseFigure (hdc) ;
                    EndPath (hdc) ;
                    }

                    // Render the path or region

               switch (x)
                    {
                    case 0:
                         SelectObject (hdc, GetStockObject (BLACK_PEN)) ;
                         StrokePath (hdc) ;
                         break ;

                    case 1:
                         SelectObject (hdc, hPenBlue) ;
                         SelectObject (hdc, hBrushRed) ;
                         StrokeAndFillPath (hdc) ;
                         break ;

                    case 2:
                         FillRgn  (hdc, hRgn [y], hBrushRed) ;
                         FrameRgn (hdc, hRgn [y], hBrushBlue, WIDTH, WIDTH) ;
                         break ;
                    }
               }
          }

     DeleteObject (hRgn [0]) ;
     DeleteObject (hRgn [1]) ;

     SelectObject (hdc, GetStockObject (BLACK_PEN)) ;
     SelectObject (hdc, GetStockObject (WHITE_BRUSH)) ;

     DeleteObject (hBrushRed) ;
     DeleteObject (hBrushBlue) ;
     DeleteObject (hPenBlue) ;
     }
